package net.doo.snap.lib.snap;

import android.os.Bundle;
import android.os.Handler;
import android.view.Window;

import com.google.inject.Inject;

import net.doo.snap.lib.R;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.ui.CustomThemeActivity;
import net.doo.snap.lib.ui.SnappingFragment;

/**
 * Main activity for snapping workflow.
 * Shows {@link net.doo.snap.lib.snap.camera.CameraPreviewFragment} for snapping
 * and {@link net.doo.snap.lib.snap.preview.ImagePreviewFragment} for each snapped image
 * in {@link net.doo.snap.lib.ui.widget.ViewPager}
 */
public class SnappingActivity extends CustomThemeActivity {

    @Inject
    private PictureProcessor pictureProcessor;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_ACTION_BAR_OVERLAY);

        setContentView(R.layout.snapping_activity);
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                ((SnappingFragment) getSupportFragmentManager()
                        .findFragmentById(R.id.snapping_fragment)).setCameraEnabled(true);
            }
        }, 500);
    }
}

