/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OperatorDetector {
    private static final int MCC_LENGTH = 3;
    private static final String TELEKOM_MCC = "262";
    private static final String TELEKOM_MNC = "01";
    private static final List<String> TELEKOM_OPERATOR_NAMES = Arrays.asList("Telekom", "Telekom.de", "Telekom D", "T-Mobile", "T-Mobile.de", "T-Mobile D");
    private NetworkOperator networkOperator = NetworkOperator.UNKNOWN;

    @Inject
    public OperatorDetector(Context context) {
        String operator;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String operatorName = telephonyManager.getNetworkOperatorName();
        if (TELEKOM_OPERATOR_NAMES.contains(operatorName) && !StringUtils.isEmpty((String)(operator = telephonyManager.getNetworkOperator())) && operator.length() >= 3) {
            String mcc = operator.substring(0, 3);
            String mnc = operator.substring(3);
            if (TELEKOM_MCC.equals(mcc) && TELEKOM_MNC.equals(mnc)) {
                this.networkOperator = NetworkOperator.TELEKOM;
            }
        }
    }

    public NetworkOperator getNetworkOperator() {
        return this.networkOperator;
    }

    public static enum NetworkOperator {
        UNKNOWN,
        TELEKOM;

    }
}

