package net.doo.snap.lib.util;

import android.content.Context;
import android.telephony.TelephonyManager;

import com.google.inject.Inject;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Detects current network operator
 */
public class OperatorDetector {
    private static final int MCC_LENGTH = 3;

    private static final String TELEKOM_MCC = "262";
    private static final String TELEKOM_MNC = "01";

    private static final List<String> TELEKOM_OPERATOR_NAMES = Arrays.asList(
            "Telekom",
            "Telekom.de",
            "Telekom D",
            "T-Mobile",
            "T-Mobile.de",
            "T-Mobile D"
    );

    private NetworkOperator networkOperator = NetworkOperator.UNKNOWN;

    @Inject
    public OperatorDetector(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String operatorName = telephonyManager.getNetworkOperatorName();

        if (TELEKOM_OPERATOR_NAMES.contains(operatorName)) {
            String operator = telephonyManager.getNetworkOperator();
            if (!StringUtils.isEmpty(operator) && operator.length() >= MCC_LENGTH) {
                String mcc = operator.substring(0, MCC_LENGTH);
                String mnc = operator.substring(MCC_LENGTH);

                if (TELEKOM_MCC.equals(mcc) && TELEKOM_MNC.equals(mnc)) {
                    networkOperator = NetworkOperator.TELEKOM;
                }
            }
        }
    }

    /**
     *
     * @return current registered network operator
     */
    public NetworkOperator getNetworkOperator() {
        return networkOperator;
    }

    /**
     * Network operators that could be detected
     */
    public enum NetworkOperator {
        UNKNOWN,
        TELEKOM
    }
}
