/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;

public class FileChooserUtils {
    private static final String CONTENT_SCHEME = "content";
    private static final String FILE_SCHEME = "file";
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileChooserUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileChooserUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)Long.valueOf(id2));
                    return FileChooserUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileChooserUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileChooserUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if (CONTENT_SCHEME.equalsIgnoreCase(uri.getScheme())) {
                return FileChooserUtils.getDataColumn(context, uri, null, null);
            }
            if (FILE_SCHEME.equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String[] projection = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
        if (cursor != null) {
            int columnIndex = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(columnIndex);
        }
        return uri.getPath();
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return EXTERNALSTORAGE_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return DOWNLOADS_AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return MEDIA_AUTHORITY.equals(uri.getAuthority());
    }
}

