package net.doo.snap.lib.billing;

import android.text.format.DateUtils;

public interface BillingConstants {
    String AMAZON_STORE_PACKAGE = "com.amazon.venezia";

    //SKUs
    String PRO_PACK_SKU = "pro_pack";
    String PRO_PACK_DISCOUNT_1_SKU = "pro_pack_discount_1";
    String PRO_PACK_DISCOUNT_2_SKU = "pro_pack_discount_2";
    String PRO_PACK_DISCOUNT_3_SKU = "pro_pack_discount_3";

    String PRO_PACK_XMAS_UNCOMMON_SKU   = "pro_pack_xmas_uncommon";
    String PRO_PACK_XMAS_RARE_SKU       = "pro_pack_xmas_rare";
    String PRO_PACK_XMAS_EPIC_SKU       = "pro_pack_xmas_epic";
    String PRO_PACK_XMAS_LEGENDARY_SKU  = "pro_pack_xmas_legendary";

    String PRO_PACK_SUBSCRIPTION_SKU = "pro_pack_subscription";
    String PRO_PACK_SUBSCRIPTION_TELEKOM_SKU = "pro_pack_subscription_telekom";
    String PRO_PACK_TRIAL_TELEKOM_SKU_LOCAL = "pro_pack_trial_telekom_local";

    int DISCOUNT_1_PERCENT = 25;
    int DISCOUNT_2_PERCENT = 30;
    int DISCOUNT_3_PERCENT = 40;

    int XMAS_UNCOMMON_PERCENT = 20;
    int XMAS_RARE_PERCENT = 40;
    int XMAS_EPIC_PERCENT = 60;
    int XMAS_LEGENDARY_PERCENT = 80;

    int PROMO_PERCENT = 40;

    String PROMO_DATE = "13/11/2014";
    long PROMO_TIME_DURATION = DateUtils.DAY_IN_MILLIS * 4;

    //add new SCUs here
    String[] ALL_SKUS = {
            PRO_PACK_SKU,
            PRO_PACK_DISCOUNT_1_SKU,
            PRO_PACK_DISCOUNT_2_SKU,
            PRO_PACK_DISCOUNT_3_SKU,
            PRO_PACK_SUBSCRIPTION_SKU,
            PRO_PACK_SUBSCRIPTION_TELEKOM_SKU,
            PRO_PACK_XMAS_UNCOMMON_SKU,
            PRO_PACK_XMAS_RARE_SKU,
            PRO_PACK_XMAS_EPIC_SKU,
            PRO_PACK_XMAS_LEGENDARY_SKU
    };

    int TELEKOM_TRIAL_PERIOD_MONTHS = 6;
    int TELEKOM_TRIAL_PERIOD_DAYS = 183;
}
