/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.genuineness;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.widget.Toast;
import com.google.inject.Inject;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.persistence.DocumentDraft;
import net.doo.snap.lib.snap.event.CheckGenuinenessEvent;
import net.doo.snap.lib.snap.event.SaveDocumentEvent;
import net.doo.snap.lib.util.MarketPageOpener;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.event.EventManager;
import roboguice.event.Observes;

public class GenuinenessChecker {
    private static final int DEBUG_SIGNATURE = 1105598010;
    private static final int RELEASE_SIGNATURE = 2027059470;
    private static final int AMAZON_SIGNATURE = -20283086;
    public static final String BASE64_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu82nw1cLa7TrVGRF00wnHci9NqHuVAnH5EFeyoUKhLBX9duv6guVRktGx5ad7K35SPy8ZksaIvZnL6j2IbUtjweRPP+tXewONGhV4j+7wROQ2G4k2zbBVo7bKXzgKEfbpbKTbH4iub0xdBxsvW6X4OwbZ1zDrC+b4pHlddJpP167XouU7DCuaErLnnchf/ZA/2yha9s4boqIYty6e9hrOwjDf13Co05k+FWHMI5hQBCwL/4oljB/GXHs0mDvUsLa9vos3jjNxGht3aheZBlgLRyIht8u/hN1ZWs4RyUqI9Mmok3CSajbcnQj8PLzuY274iqklg4shgAzoVTOv3it4wIDAQAB";
    private static final int ERROR_DEBUG_SIGNATURE = 2146616982;
    private static final int ERROR_RELEASE_SIGNATURE = 349857392;
    private static final int ERROR_DEBUGGABLE = 645892742;
    private static final int GOOD_LICENSE = -309808353;
    private Genuineness genuineness = Genuineness.NO;
    @Inject
    private Context context;
    @Inject
    private EventManager eventManager;
    @Inject
    private MarketPageOpener marketPageOpener;

    @Inject
    public GenuinenessChecker(Context context) {
        this.context = context;
        int signature = 0;
        try {
            Signature[] signatures = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
            signature = signatures[0].hashCode();
        }
        catch (PackageManager.NameNotFoundException e) {
            DebugLog.logException(e);
        }
        if (1105598010 == signature) {
            this.genuineness = Genuineness.UNKNOWN;
            return;
        }
        this.trackLicense(2146616982);
        this.genuineness = Genuineness.NO;
    }

    public Genuineness getAppGenuineness() {
        return this.genuineness;
    }

    private void trackLicense(int reason) {
        switch (reason) {
            case -309808353: {
                EasyTrackerWrapper.sendEvent("license", "genuine", "license_check", 0L);
                break;
            }
            case 2146616982: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "debug_signature", 0L);
                break;
            }
            case 349857392: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "release_signature", 0L);
                break;
            }
            case 645892742: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "debuggable", 0L);
            }
        }
    }

    private void checkDocument(@Observes CheckGenuinenessEvent event) {
        DocumentDraft documentDraft = event.getDraft();
        if (this.getAppGenuineness().equals((Object)Genuineness.NO)) {
            this.redirectToGooglePlay();
            EasyTrackerWrapper.sendEvent("license", "unauthorized_use", "save_document", 0L);
            return;
        }
        this.eventManager.fire((Object)new SaveDocumentEvent(documentDraft));
    }

    private void redirectToGooglePlay() {
        Toast.makeText((Context)this.context, (int)2131165257, (int)1).show();
        this.marketPageOpener.openMarketPage();
    }

    public static enum Genuineness {
        YES,
        NO,
        UNKNOWN;

    }
}

