package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;

import com.google.zxing.client.result.ExpandedProductParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductParsedResult;

import net.doo.snap.lib.R;
import net.doo.snap.lib.util.ThemesHelper;

/**
 * Handles generic products which are not books.
 */
public final class ProductResultHandler extends ResultHandler {
    private static final int[] buttons = {
            R.string.button_product_search,
            R.string.button_web_search
    };
    private static final int OPEN_PRODUCT_SEARCH = 0;
    private static final int WEB_SEARCH = 1;

    public ProductResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        String productID = getProductIDFromResult(getResult());
        switch (index) {
            case OPEN_PRODUCT_SEARCH:
                openProductSearch(productID);
                break;
            case WEB_SEARCH:
                webSearch(productID);
                break;
        }
    }

    private static String getProductIDFromResult(ParsedResult rawResult) {
        if (rawResult instanceof ProductParsedResult) {
            return ((ProductParsedResult) rawResult).getNormalizedProductID();
        }
        if (rawResult instanceof ExpandedProductParsedResult) {
            return ((ExpandedProductParsedResult) rawResult).getRawText();
        }
        throw new IllegalArgumentException(rawResult.getClass().toString());
    }

    @Override
    public String getDisplayTitle() {
        return getProductIDFromResult(getResult());
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_barcode);
    }
}
