package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import com.google.zxing.client.result.ParsedResult;
import net.doo.snap.lib.R;
import net.doo.snap.lib.util.ThemesHelper;

/**
 * This class handles TextParsedResult as well as unknown formats. It's the fallback handler.
 */
public final class TextResultHandler extends ResultHandler {

    public TextResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return 0;
    }

    @Override
    public int getButtonText(int index) {
        return 0;
    }

    @Override
    public void handleButtonPress(int index) {
    }

    @Override
    public String getDisplayTitle() {
        return null;
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return getResult().getDisplayResult();
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_barcode);
    }
}
