
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import com.google.inject.AnnotationDatabase;
import roboguice.fragment.FragmentUtil;

public class AnnotationDatabaseImpl extends AnnotationDatabase {

    public void fillAnnotationClassesAndFieldsNames(HashMap<String, Map<String, Set<String>>> mapAnnotationToMapClassWithInjectionNameToFieldSet) {
    
        String annotationClassName = null;
        Map<String, Set<String>> mapClassWithInjectionNameToFieldSet = null;
        Set<String> fieldNameSet = null;


        annotationClassName = "com.google.inject.Inject";
        mapClassWithInjectionNameToFieldSet = mapAnnotationToMapClassWithInjectionNameToFieldSet.get(annotationClassName);
        if( mapClassWithInjectionNameToFieldSet == null ) {
            mapClassWithInjectionNameToFieldSet = new HashMap<String, Set<String>>();
            mapAnnotationToMapClassWithInjectionNameToFieldSet.put(annotationClassName, mapClassWithInjectionNameToFieldSet);
        }

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("bitmapLruCache");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.persistence.PictureProcessor", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("barcodeDetector");
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.camera.SnapCameraHost", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("preferences");
        fieldNameSet.add("bitmapLruCache");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.persistence.PageFactory", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.preview.zoom.ZoomedPreviewFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("smartNameBuilder");
        fieldNameSet.add("eventManager");
        fieldNameSet.add("deletePageEditor");
        fieldNameSet.add("editLock");
        fieldNameSet.add("rotatePageEditor");
        fieldNameSet.add("pagesRearranger");
        fieldNameSet.add("adapter");
        fieldNameSet.add("pictureProcessor");
        fieldNameSet.add("checker");
        fieldNameSet.add("bitmapLruCache");
        fieldNameSet.add("preferences");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.SnappingFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.SaveModeFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("context");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.persistence.SignatureStoreStrategy", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        fieldNameSet.add("operatorDetector");
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.billing.LocalItemsManager", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("activityAnalytics");
        fieldNameSet.add("bitmapLruCache");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.edit.EditPolygonActivity", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.Nexus4RebootFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("activityAnalytics");
        fieldNameSet.add("pictureProcessor");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.camera.CameraActivity", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.edit.RenameDocumentFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.util.snap.OrientationHandler", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("cameraPreviewConfiguration");
        fieldNameSet.add("eventManager");
        fieldNameSet.add("snapCameraHost");
        fieldNameSet.add("sensorHelper");
        fieldNameSet.add("cameraConfiguration");
        fieldNameSet.add("orientationHandler");
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.camera.CameraPreviewFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("context");
        fieldNameSet.add("barcodeDetector");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.BarcodeFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("ignored");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.RoboActionBarActivity", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.edit.ChangeFilterFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("localItemsManager");
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.billing.AmazonBillingManagerImpl", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.RetakePhotoDropTargetFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("pageFactory");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.PreviewFragmentPagerAdapter", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("context");
        fieldNameSet.add("sharedPreferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.tutorial.OneTimeFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("marketPageOpener");
        fieldNameSet.add("eventManager");
        fieldNameSet.add("context");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.genuineness.GenuinenessChecker", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.camera.debug.DebugCameraHost", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("smartNameBuilder");
        fieldNameSet.add("activityAnalytics");
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.SmartNameActivity", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("eventManager");
        fieldNameSet.add("editLock");
        fieldNameSet.add("activity");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.preview.zoom.ZoomingManager", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("localItemsManager");
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.billing.BillingManagerImpl", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("context");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.camera.HostProvider", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("pictureProcessor");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.SnappingActivity", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("zoomingManager");
        fieldNameSet.add("eventManager");
        fieldNameSet.add("editLock");
        fieldNameSet.add("bitmapLruCache");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.snap.preview.ImagePreviewFragment", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("activityAnalytics");
        fieldNameSet.add("sensorHelper");
        fieldNameSet.add("signatureStoreStrategy");
        fieldNameSet.add("bitmapLruCache");
        fieldNameSet.add("sharedPreferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.lib.ui.CreateSignatureActivity", fieldNameSet);

    }
    
    public void fillAnnotationClassesAndMethods(HashMap<String, Map<String, Set<String>>> mapAnnotationToMapClassWithInjectionNameToMethodsSet) {

        String annotationClassName = null;
        Map<String, Set<String>> mapClassWithInjectionNameToMethodSet = null;
        Set<String> methodSet = null;


        annotationClassName = "roboguice.event.Observes";
        mapClassWithInjectionNameToMethodSet = mapAnnotationToMapClassWithInjectionNameToMethodsSet.get(annotationClassName);
        if( mapClassWithInjectionNameToMethodSet == null ) {
            mapClassWithInjectionNameToMethodSet = new HashMap<String, Set<String>>();
            mapAnnotationToMapClassWithInjectionNameToMethodsSet.put(annotationClassName, mapClassWithInjectionNameToMethodSet);
        }

        methodSet = new HashSet<String>();
        methodSet.add("onPageDeletion:net.doo.snap.lib.snap.edit.events.DeletePageEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.snap.edit.DeletePageEditor", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onResume:roboguice.activity.event.OnResumeEvent");
        methodSet.add("onStart:roboguice.context.event.OnStartEvent");
        methodSet.add("onPause:roboguice.activity.event.OnPauseEvent");
        methodSet.add("onStop:roboguice.activity.event.OnStopEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.analytics.ActivityAnalytics", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onScaleEnded:net.doo.snap.lib.snap.preview.zoom.ZoomingFinishedEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.snap.preview.zoom.ZoomingManager", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onActivityResume:roboguice.activity.event.OnResumeEvent");
        methodSet.add("onActivityPause:roboguice.activity.event.OnPauseEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.sensor.SensorHelper", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onCreate:roboguice.context.event.OnCreateEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.util.snap.OrientationLocker", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onPageRotation:net.doo.snap.lib.snap.edit.events.RotatePageEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.snap.edit.RotatePageEditor", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onPictureTaken:net.doo.snap.lib.snap.event.PictureTakenEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.snap.camera.CameraActivity", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("checkDocument:net.doo.snap.lib.snap.event.CheckGenuinenessEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.genuineness.GenuinenessChecker", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onPrepareZooming:net.doo.snap.lib.snap.preview.zoom.PrepareZoomEvent");
        methodSet.add("onQuickScale:net.doo.snap.lib.snap.preview.zoom.QuickScaleEvent");
        methodSet.add("onPreScaleChanged:net.doo.snap.lib.snap.preview.zoom.PreScaleChangedEvent");
        methodSet.add("onZoomingStarted:net.doo.snap.lib.snap.preview.zoom.StartZoomingEvent");
        methodSet.add("onBackPressed:net.doo.snap.lib.ui.events.BackPressedEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.snap.preview.zoom.ZoomedPreviewFragment", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onDocumentRename:net.doo.snap.lib.snap.edit.events.DocumentRenamedEvent");
        methodSet.add("onPictureProcessingStatusChanged:net.doo.snap.lib.snap.event.PictureProcessingStatusChangedEvent");
        methodSet.add("onPageLongPressed:net.doo.snap.lib.ui.events.OnPageLongPressedEvent");
        methodSet.add("onDocumentSave:net.doo.snap.lib.snap.event.ProcessDocumentsEvent");
        methodSet.add("onFinishZooming:net.doo.snap.lib.snap.preview.zoom.ZoomingFinishedEvent");
        methodSet.add("onStartZooming:net.doo.snap.lib.snap.preview.zoom.PrepareZoomEvent");
        methodSet.add("onPageOptimizationTypeChanged:net.doo.snap.lib.snap.event.PageOptimizationTypeChangedEvent");
        methodSet.add("onRetakePage:net.doo.snap.lib.snap.edit.events.RetakePageEvent");
        methodSet.add("onPictureTaken:net.doo.snap.lib.snap.event.PictureTakenEvent");
        methodSet.add("saveDocument:net.doo.snap.lib.snap.event.SaveDocumentEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.ui.SnappingFragment", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onOptimizationTypeChanged:net.doo.snap.lib.snap.event.PageOptimizationTypeChangedEvent");
        methodSet.add("editPolygonFinished:roboguice.activity.event.OnActivityResultEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.snap.preview.ImagePreviewFragment", methodSet);

        methodSet = new HashSet<String>();
        methodSet.add("onStart:roboguice.context.event.OnStartEvent");
        methodSet.add("onStop:roboguice.activity.event.OnStopEvent");
        mapClassWithInjectionNameToMethodSet.put("net.doo.snap.lib.smartname.SmartNameValuesProvider", methodSet);

    }
    
    public void fillAnnotationClassesAndConstructors(HashMap<String, Map<String, Set<String>>> mapAnnotationToMapClassWithInjectionNameToConstructorsSet) {

        String annotationClassName = null;
        Map<String, Set<String>> mapClassWithInjectionNameToConstructorSet = null;
        Set<String> constructorSet = null;


        annotationClassName = "com.google.inject.Inject";
        mapClassWithInjectionNameToConstructorSet = mapAnnotationToMapClassWithInjectionNameToConstructorsSet.get(annotationClassName);
        if( mapClassWithInjectionNameToConstructorSet == null ) {
            mapClassWithInjectionNameToConstructorSet = new HashMap<String, Set<String>>();
            mapAnnotationToMapClassWithInjectionNameToConstructorsSet.put(annotationClassName, mapClassWithInjectionNameToConstructorSet);
        }

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.lib.persistence.PageFactory:net.doo.snap.lib.persistence.PageStoreStrategy:android.content.res.Resources:android.content.SharedPreferences");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.persistence.PictureProcessor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Application");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.persistence.PageStoreStrategy", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.camera.SnapCameraHost", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.ActivityManager");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.util.bitmap.BitmapLruCache", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.lib.persistence.PageStoreStrategy");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.persistence.PageFactory", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.persistence.SignatureStoreStrategy", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.util.OperatorDetector", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.SharedPreferences:net.doo.snap.lib.smartname.SmartNameValuesProvider");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.smartname.SmartNameGenerator", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.billing.LocalItemsManager", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Activity");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.util.snap.OrientationLocker", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.camera.barcode.BarcodeDetector", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.util.snap.OrientationHandler", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.billing.AmazonBillingManagerImpl", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Activity:net.doo.snap.lib.snap.edit.EditLock:net.doo.snap.lib.persistence.PageStoreStrategy");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.edit.DeletePageEditor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.support.v4.app.FragmentManager");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.PreviewFragmentPagerAdapter", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.hardware.SensorManager");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.sensor.SensorHelper", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.SnapModule", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.lib.snap.edit.EditLock");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.edit.RotatePageEditor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.genuineness.GenuinenessChecker", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.camera.debug.DebugCameraHost", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.util.CameraConfiguration", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Activity");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.analytics.ActivityAnalytics", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.preview.zoom.ZoomingManager", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.billing.BillingManagerImpl", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.res.Resources:net.doo.snap.lib.snap.edit.EditLock");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.edit.drag.PagesRearranger", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Activity");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.smartname.SmartNameValuesProvider", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.lib.snap.camera.CameraPreviewConfiguration", constructorSet);

    }
    
    public void fillClassesContainingInjectionPointSet(HashSet<String> classesContainingInjectionPointsSet) {
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.persistence.PageStoreStrategy");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.persistence.PictureProcessor");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.SnapCameraHost");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.util.bitmap.BitmapLruCache");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.persistence.PageFactory");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.preview.zoom.ZoomedPreviewFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.SnappingFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.SaveModeFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.util.OperatorDetector");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.persistence.SignatureStoreStrategy");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.smartname.SmartNameGenerator");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.billing.LocalItemsManager");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.edit.EditPolygonActivity");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.Nexus4RebootFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.barcode.BarcodeDetector");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.util.snap.OrientationLocker");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.CameraActivity");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.edit.RenameDocumentFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.util.snap.OrientationHandler");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.CameraPreviewFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.BarcodeFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.RoboActionBarActivity");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.edit.ChangeFilterFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.billing.AmazonBillingManagerImpl");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.edit.DeletePageEditor");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.RetakePhotoDropTargetFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.PreviewFragmentPagerAdapter");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.sensor.SensorHelper");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.tutorial.OneTimeFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.SnapModule");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.edit.RotatePageEditor");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.genuineness.GenuinenessChecker");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.debug.DebugCameraHost");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.util.CameraConfiguration");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.SmartNameActivity");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.analytics.ActivityAnalytics");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.preview.zoom.ZoomingManager");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.billing.BillingManagerImpl");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.HostProvider");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.SnappingActivity");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.edit.drag.PagesRearranger");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.preview.ImagePreviewFragment");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.ui.CreateSignatureActivity");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.snap.camera.CameraPreviewConfiguration");
        classesContainingInjectionPointsSet.add("net.doo.snap.lib.smartname.SmartNameValuesProvider");
    }
    

    public void fillBindableClasses(HashSet<String> injectedClasses) {
        injectedClasses.add("net.doo.snap.lib.persistence.PictureProcessor");
        injectedClasses.add("net.doo.snap.lib.util.bitmap.BitmapLruCache");
        injectedClasses.add("net.doo.snap.lib.persistence.PageFactory");
        injectedClasses.add("net.doo.snap.lib.snap.preview.zoom.ZoomingFinishedEvent");
        injectedClasses.add("net.doo.snap.lib.util.OperatorDetector");
        injectedClasses.add("net.doo.snap.lib.smartname.SmartNameGenerator");
        injectedClasses.add("net.doo.snap.lib.snap.preview.zoom.PrepareZoomEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.events.RotatePageEvent");
        injectedClasses.add("net.doo.snap.lib.snap.preview.zoom.StartZoomingEvent");
        injectedClasses.add("roboguice.context.event.OnCreateEvent");
        injectedClasses.add("net.doo.snap.lib.util.snap.OrientationHandler");
        injectedClasses.add("net.doo.snap.lib.ui.events.OnPageLongPressedEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.DeletePageEditor");
        injectedClasses.add("net.doo.snap.lib.ui.events.BackPressedEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.RotatePageEditor");
        injectedClasses.add("net.doo.snap.lib.genuineness.GenuinenessChecker");
        injectedClasses.add("roboguice.activity.event.OnPauseEvent");
        injectedClasses.add("android.hardware.SensorManager");
        injectedClasses.add("net.doo.snap.lib.snap.event.ProcessDocumentsEvent");
        injectedClasses.add("net.doo.snap.lib.util.CameraConfiguration");
        injectedClasses.add("net.doo.snap.lib.util.MarketPageOpener");
        injectedClasses.add("android.content.Context");
        injectedClasses.add("android.content.SharedPreferences");
        injectedClasses.add("net.doo.snap.lib.persistence.PageStoreStrategy");
        injectedClasses.add("net.doo.snap.lib.snap.camera.SnapCameraHost");
        injectedClasses.add("roboguice.activity.event.OnResumeEvent");
        injectedClasses.add("android.app.ActivityManager");
        injectedClasses.add("net.doo.snap.lib.snap.preview.zoom.QuickScaleEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.events.RetakePageEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.events.DeletePageEvent");
        injectedClasses.add("net.doo.snap.lib.snap.event.PageOptimizationTypeChangedEvent");
        injectedClasses.add("net.doo.snap.lib.persistence.SignatureStoreStrategy");
        injectedClasses.add("net.doo.snap.lib.billing.LocalItemsManager");
        injectedClasses.add("net.doo.snap.lib.snap.camera.barcode.BarcodeDetector");
        injectedClasses.add("android.app.Activity");
        injectedClasses.add("net.doo.snap.lib.snap.event.CheckGenuinenessEvent");
        injectedClasses.add("roboguice.activity.event.OnActivityResultEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.EditLock");
        injectedClasses.add("android.content.res.Resources");
        injectedClasses.add("net.doo.snap.lib.snap.PreviewFragmentPagerAdapter");
        injectedClasses.add("net.doo.snap.lib.sensor.SensorHelper");
        injectedClasses.add("android.app.Application");
        injectedClasses.add("roboguice.event.EventManager");
        injectedClasses.add("android.support.v4.app.FragmentManager");
        injectedClasses.add("net.doo.snap.lib.snap.preview.zoom.PreScaleChangedEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.events.DocumentRenamedEvent");
        injectedClasses.add("net.doo.snap.lib.snap.event.PictureProcessingStatusChangedEvent");
        injectedClasses.add("roboguice.inject.ContentViewListener");
        injectedClasses.add("roboguice.activity.event.OnStopEvent");
        injectedClasses.add("net.doo.snap.lib.analytics.ActivityAnalytics");
        injectedClasses.add("net.doo.snap.lib.snap.preview.zoom.ZoomingManager");
        injectedClasses.add("net.doo.snap.lib.snap.event.SaveDocumentEvent");
        injectedClasses.add("roboguice.context.event.OnStartEvent");
        injectedClasses.add("net.doo.snap.lib.snap.event.PictureTakenEvent");
        injectedClasses.add("net.doo.snap.lib.snap.edit.drag.PagesRearranger");
        injectedClasses.add("net.doo.snap.lib.snap.camera.CameraPreviewConfiguration");
        injectedClasses.add("net.doo.snap.lib.smartname.SmartNameValuesProvider");

        if(FragmentUtil.hasNative) {
            injectedClasses.add("android.app.FragmentManager");
        }

        if(FragmentUtil.hasSupport) {
            injectedClasses.add("android.support.v4.app.FragmentManager");
        }
    }

}
