/*
 * Decompiled with CFR 0.152.
 */
package de.aflx.sardine;

import de.aflx.sardine.model.Propstat;
import de.aflx.sardine.model.Response;
import de.aflx.sardine.util.Logger;
import de.aflx.sardine.util.QName;
import de.aflx.sardine.util.SardineUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DavResource {
    private static Logger log = new Logger();
    public static final String DEFAULT_CONTENT_TYPE = "application/octetstream";
    public static final long DEFAULT_CONTENT_LENGTH = -1L;
    public static final String HTTPD_UNIX_DIRECTORY_CONTENT_TYPE = "httpd/unix-directory";
    private static final String SEPARATOR = "/";
    private final URI href;
    private final Date creation;
    private final Date modified;
    private final String contentType;
    private final String etag;
    private final Long contentLength;
    private final Map<QName, String> customProps;

    protected DavResource(String href, Date creation, Date modified, String contentType, Long contentLength, String etag, Map<QName, String> customProps) throws URISyntaxException {
        this.href = new URI(href);
        this.creation = creation;
        this.modified = modified;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.etag = etag;
        this.customProps = customProps;
    }

    public DavResource(Response response) throws URISyntaxException {
        this.href = new URI(response.getHref());
        this.creation = SardineUtil.parseDate(this.getCreationDate(response));
        this.modified = SardineUtil.parseDate(this.getModifiedDate(response));
        this.contentType = this.getContentType(response);
        this.contentLength = this.getContentLength(response);
        this.etag = this.getEtag(response);
        this.customProps = this.getCustomProps(response);
    }

    private String getModifiedDate(Response response) {
        Propstat list = response.getPropstat();
        if (list.equals("") || null == list) {
            return null;
        }
        return list.getProp().getGetlastmodified();
    }

    private String getCreationDate(Response response) {
        Propstat list = response.getPropstat();
        if (list.equals("") || null == list) {
            return null;
        }
        return list.getProp().getCreationdate();
    }

    private String getContentType(Response response) {
        Propstat list = response.getPropstat();
        if (list.equals("") || null == list) {
            return null;
        }
        String type = list.getProp().getGetcontenttype();
        if (null == type) {
            type = this.getHref().toString().endsWith(SEPARATOR) ? HTTPD_UNIX_DIRECTORY_CONTENT_TYPE : DEFAULT_CONTENT_TYPE;
        }
        return type;
    }

    private long getContentLength(Response response) {
        return -1L;
    }

    private String getEtag(Response response) {
        Propstat list = response.getPropstat();
        if (list.equals("") || null == list) {
            return null;
        }
        return list.getProp().getGetetag();
    }

    private Map<QName, String> getCustomProps(Response response) {
        return null;
    }

    public Date getCreation() {
        return this.creation;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean isDirectory() {
        return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE.equals(this.contentType);
    }

    public Map<String, String> getCustomProps() {
        HashMap<String, String> local = new HashMap<String, String>();
        Map<QName, String> properties = this.getCustomPropsNS();
        for (QName key : properties.keySet()) {
            local.put(key.getLocalPart(), properties.get(key));
        }
        return local;
    }

    public Map<QName, String> getCustomPropsNS() {
        return this.customProps;
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        String path = this.href.getPath();
        try {
            if (path.endsWith(SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            return path.substring(path.lastIndexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warn(String.format("Failed to parse name from path %s", path));
            return null;
        }
    }

    public String getPath() {
        return this.href.getPath();
    }

    public String toString() {
        return this.getPath();
    }
}

