/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0007J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\t*\u00020\u00132\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lorg/intellij/markdown/lexer/Compat;", "", "()V", "MIN_HIGH_SURROGATE", "", "MIN_LOW_SURROGATE", "MIN_SUPPLEMENTARY_CODE_POINT", "", "assert", "", "condition", "", "messageProducer", "Lkotlin/Function0;", "", "charCount", "char", "codePointAt", "seq", "", "index", "codePointBefore", "codePointToString", "c", "offsetByCodePoints", "codePointOffset", "toCodePoint", "high", "low", "forEachCodePoint", "f", "Lkotlin/Function1;", "markdown"})
public final class Compat {
    private static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MIN_LOW_SURROGATE = '\udc00';
    public static final Compat INSTANCE;

    public final void forEachCodePoint(@NotNull CharSequence $this$forEachCodePoint, @NotNull Function1<? super Integer, Unit> f) {
        int codePoint;
        Intrinsics.checkNotNullParameter($this$forEachCodePoint, "$this$forEachCodePoint");
        Intrinsics.checkNotNullParameter(f, "f");
        for (int offset = 0; offset < $this$forEachCodePoint.length(); offset += this.charCount(codePoint)) {
            codePoint = this.codePointAt($this$forEachCodePoint, offset);
            f.invoke((Integer)codePoint);
        }
    }

    @NotNull
    public final String codePointToString(int c) {
        String string;
        if (this.charCount(c) == 1) {
            string = String.valueOf((char)c);
        } else {
            char high = (char)((c >>> 10) + 55232);
            char low = (char)((c & 0x3FF) + 56320);
            string = StringsKt.concatToString(new char[]{high, low});
        }
        return string;
    }

    public final int offsetByCodePoints(@NotNull CharSequence seq, int index, int codePointOffset) {
        Intrinsics.checkNotNullParameter(seq, "seq");
        int length = seq.length();
        if (index < 0 || index > length) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        int x = index;
        if (codePointOffset >= 0) {
            int i = 0;
            for (i = 0; x < length && i < codePointOffset; ++i) {
                char c = seq.charAt(x++);
                boolean bl = false;
                if (!Character.isHighSurrogate(c) || x >= length) continue;
                c = seq.charAt(x);
                bl = false;
                if (!Character.isLowSurrogate(c)) continue;
                ++x;
            }
            if (i < codePointOffset) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
        } else {
            int i = 0;
            for (i = codePointOffset; x > 0 && i < 0; ++i) {
                char c = seq.charAt(--x);
                boolean bl = false;
                if (!Character.isLowSurrogate(c) || x <= 0) continue;
                c = seq.charAt(x - 1);
                bl = false;
                if (!Character.isHighSurrogate(c)) continue;
                --x;
            }
            if (i < 0) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
        }
        return x;
    }

    public final int codePointBefore(@NotNull CharSequence seq, int index) {
        char c2;
        Intrinsics.checkNotNullParameter(seq, "seq");
        int index2 = index;
        char c = c2 = seq.charAt(--index2);
        char c3 = '\u0000';
        if (Character.isLowSurrogate(c) && index2 > 0) {
            char c1;
            c3 = c1 = seq.charAt(--index2);
            boolean bl = false;
            if (Character.isHighSurrogate(c3)) {
                return this.toCodePoint(c1, c2);
            }
        }
        return c2;
    }

    public final int charCount(int n) {
        return n >= 65536 ? 2 : 1;
    }

    public final int toCodePoint(char high, char low) {
        return (high << 10) + low + -56613888;
    }

    public final int codePointAt(@NotNull CharSequence seq, int index) {
        char c1;
        Intrinsics.checkNotNullParameter(seq, "seq");
        int index2 = index;
        char c = c1 = seq.charAt(index2);
        char c2 = '\u0000';
        if (Character.isHighSurrogate(c) && ++index2 < seq.length()) {
            char c22;
            c2 = c22 = seq.charAt(index2);
            boolean bl = false;
            if (Character.isLowSurrogate(c2)) {
                return this.toCodePoint(c1, c22);
            }
        }
        return c1;
    }

    public final void assert(boolean condition2, @NotNull Function0<String> messageProducer) {
        int $i$f$assert = 0;
        Intrinsics.checkNotNullParameter(messageProducer, "messageProducer");
        if (!condition2) {
            throw (Throwable)((Object)new AssertionError((Object)messageProducer.invoke()));
        }
    }

    public static /* synthetic */ void assert$default(Compat this_, boolean condition2, Function0 messageProducer, int n, Object object) {
        if ((n & 2) != 0) {
            messageProducer = assert.1.INSTANCE;
        }
        boolean $i$f$assert = false;
        Intrinsics.checkNotNullParameter(messageProducer, "messageProducer");
        if (!condition2) {
            throw (Throwable)((Object)new AssertionError(messageProducer.invoke()));
        }
    }

    private Compat() {
    }

    static {
        Compat compat;
        INSTANCE = compat = new Compat();
    }
}

