/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.GeneratedLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J&\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006J,\u0010#\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u001e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\"\u0010\u0018\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lorg/intellij/markdown/lexer/MarkdownLexer;", "", "baseLexer", "Lorg/intellij/markdown/lexer/GeneratedLexer;", "(Lorg/intellij/markdown/lexer/GeneratedLexer;)V", "<set-?>", "", "bufferEnd", "getBufferEnd", "()I", "bufferStart", "getBufferStart", "nextType", "Lorg/intellij/markdown/IElementType;", "", "originalText", "getOriginalText", "()Ljava/lang/CharSequence;", "state", "getState", "tokenEnd", "getTokenEnd", "tokenStart", "getTokenStart", "type", "getType", "()Lorg/intellij/markdown/IElementType;", "advance", "", "advanceBase", "calcNextType", "", "locateToken", "reset", "buffer", "start", "end", "initialState", "Companion", "markdown"})
public class MarkdownLexer {
    @Nullable
    private IElementType type;
    private IElementType nextType;
    @NotNull
    private CharSequence originalText;
    private int bufferStart;
    private int bufferEnd;
    private int tokenStart;
    private int tokenEnd;
    private final int state;
    private final GeneratedLexer baseLexer;
    private static final Set<IElementType> TOKENS_TO_MERGE;
    public static final Companion Companion;

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    public final int getBufferEnd() {
        return this.bufferEnd;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    public final int getState() {
        return this.state;
    }

    public final void start(@NotNull CharSequence originalText, int bufferStart, int bufferEnd, int state) {
        Intrinsics.checkNotNullParameter(originalText, "originalText");
        this.reset(originalText, bufferStart, bufferEnd, state);
        this.calcNextType();
    }

    public static /* synthetic */ void start$default(MarkdownLexer markdownLexer, CharSequence charSequence, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = charSequence.length();
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        markdownLexer.start(charSequence, n, n2, n3);
    }

    public final boolean advance() {
        return this.locateToken();
    }

    private final boolean locateToken() {
        this.type = this.nextType;
        this.tokenStart = this.tokenEnd;
        if (this.type == null) {
            return false;
        }
        this.calcNextType();
        return true;
    }

    private final void calcNextType() {
        IElementType it;
        do {
            this.tokenEnd = this.baseLexer.getTokenEnd();
            this.nextType = this.advanceBase();
            IElementType iElementType = this.type;
            boolean bl = false;
            boolean bl2 = false;
            it = iElementType;
            boolean bl3 = false;
        } while (Intrinsics.areEqual(this.nextType, it) && it != null && TOKENS_TO_MERGE.contains(it));
    }

    private final IElementType advanceBase() {
        try {
            return this.baseLexer.advance();
        }
        catch (Exception e) {
            throw (Throwable)((Object)new AssertionError((Object)"This could not be!"));
        }
    }

    public final void reset(@NotNull CharSequence buffer, int start, int end, int initialState) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.originalText = buffer;
        this.bufferStart = start;
        this.bufferEnd = end;
        this.baseLexer.reset(buffer, start, end, initialState);
        this.type = this.advanceBase();
        this.tokenStart = this.baseLexer.getTokenStart();
    }

    public MarkdownLexer(@NotNull GeneratedLexer baseLexer) {
        Intrinsics.checkNotNullParameter(baseLexer, "baseLexer");
        this.baseLexer = baseLexer;
        this.originalText = "";
        this.state = this.baseLexer.getState();
    }

    static {
        Companion = new Companion(null);
        TOKENS_TO_MERGE = SetsKt.setOf(MarkdownTokenTypes.TEXT, MarkdownTokenTypes.WHITE_SPACE, MarkdownTokenTypes.CODE_LINE, MarkdownTokenTypes.LINK_ID, MarkdownTokenTypes.LINK_TITLE, MarkdownTokenTypes.URL, MarkdownTokenTypes.AUTOLINK, MarkdownTokenTypes.EMAIL_AUTOLINK, MarkdownTokenTypes.BAD_CHARACTER);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/markdown/lexer/MarkdownLexer$Companion;", "", "()V", "TOKENS_TO_MERGE", "", "Lorg/intellij/markdown/IElementType;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

