/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.cli;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.cli.ArgType;
import kotlinx.cli.ParsingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b&\u0018\u0000 \u0012*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0006\u0010\u0011\u0012\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lkotlinx/cli/ArgType;", "T", "", "hasParameter", "", "(Z)V", "description", "", "getDescription", "()Ljava/lang/String;", "getHasParameter", "()Z", "convert", "value", "name", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "Boolean", "Choice", "Companion", "Double", "Int", "String", "kotlinx-cli"})
public abstract class ArgType<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasParameter;

    public ArgType(boolean hasParameter) {
        this.hasParameter = hasParameter;
    }

    public final boolean getHasParameter() {
        return this.hasParameter;
    }

    @NotNull
    public abstract java.lang.String getDescription();

    @NotNull
    public abstract T convert(@NotNull java.lang.String var1, @NotNull java.lang.String var2);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lkotlinx/cli/ArgType$Boolean;", "Lkotlinx/cli/ArgType;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "kotlinx-cli"})
    public static final class Boolean
    extends ArgType<java.lang.Boolean> {
        @NotNull
        public static final Boolean INSTANCE = new Boolean();

        private Boolean() {
            super(false);
        }

        @Override
        @NotNull
        public java.lang.String getDescription() {
            return "";
        }

        @Override
        @NotNull
        public java.lang.Boolean convert(@NotNull java.lang.String value, @NotNull java.lang.String name2) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(name2, "name");
            return !Intrinsics.areEqual(value, "false");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lkotlinx/cli/ArgType$String;", "Lkotlinx/cli/ArgType;", "", "()V", "description", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "kotlinx-cli"})
    public static final class String
    extends ArgType<java.lang.String> {
        @NotNull
        public static final String INSTANCE = new String();

        private String() {
            super(true);
        }

        @Override
        @NotNull
        public java.lang.String getDescription() {
            return "{ String }";
        }

        @Override
        @NotNull
        public java.lang.String convert(@NotNull java.lang.String value, @NotNull java.lang.String name2) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(name2, "name");
            return value;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lkotlinx/cli/ArgType$Int;", "Lkotlinx/cli/ArgType;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "kotlinx-cli"})
    public static final class Int
    extends ArgType<Integer> {
        @NotNull
        public static final Int INSTANCE = new Int();

        private Int() {
            super(true);
        }

        @Override
        @NotNull
        public java.lang.String getDescription() {
            return "{ Int }";
        }

        @Override
        @NotNull
        public Integer convert(@NotNull java.lang.String value, @NotNull java.lang.String name2) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(name2, "name");
            Integer n = StringsKt.toIntOrNull(value);
            if (n == null) {
                throw new ParsingException("Option " + name2 + " is expected to be integer number. " + value + " is provided.");
            }
            return (int)n;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lkotlinx/cli/ArgType$Double;", "Lkotlinx/cli/ArgType;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "convert", "value", "name", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "kotlinx-cli"})
    public static final class Double
    extends ArgType<java.lang.Double> {
        @NotNull
        public static final Double INSTANCE = new Double();

        private Double() {
            super(true);
        }

        @Override
        @NotNull
        public java.lang.String getDescription() {
            return "{ Double }";
        }

        @Override
        @NotNull
        public java.lang.Double convert(@NotNull java.lang.String value, @NotNull java.lang.String name2) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(name2, "name");
            java.lang.Double d = StringsKt.toDoubleOrNull(value);
            if (d == null) {
                throw new ParsingException("Option " + name2 + " is expected to be double number. " + value + " is provided.");
            }
            return (double)d;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0010\b\u0001\u0010\u0005\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0014\b\n\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00050\b2\u0014\b\n\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\t0\bH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"Lkotlinx/cli/ArgType$Companion;", "", "()V", "Choice", "Lkotlinx/cli/ArgType$Choice;", "T", "", "toVariant", "Lkotlin/Function1;", "", "toString", "kotlinx-cli"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T extends Enum<T>> Choice<T> Choice(Function1<? super java.lang.String, ? extends T> toVariant, Function1<? super T, java.lang.String> toString2) {
            Intrinsics.checkNotNullParameter(toVariant, "toVariant");
            Intrinsics.checkNotNullParameter(toString2, "toString");
            boolean $i$f$Choice = false;
            Intrinsics.reifiedOperationMarker(5, "T");
            return new Choice<T>(ArraysKt.toList(new Enum[0]), toVariant, toString2);
        }

        public static /* synthetic */ Choice Choice$default(Companion this_, Function1 toVariant, Function1 toString2, int n, Object object) {
            if ((n & 1) != 0) {
                Intrinsics.needClassReification();
                toVariant = Choice.1.INSTANCE;
            }
            if ((n & 2) != 0) {
                Intrinsics.needClassReification();
                toString2 = Choice.2.INSTANCE;
            }
            Intrinsics.checkNotNullParameter(toVariant, "toVariant");
            Intrinsics.checkNotNullParameter(toString2, "toString");
            boolean $i$f$Choice = false;
            Intrinsics.reifiedOperationMarker(5, "T");
            return new Choice<Enum>(ArraysKt.toList(new Enum[0]), toVariant, toString2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lkotlinx/cli/ArgType$Choice;", "T", "", "Lkotlinx/cli/ArgType;", "choices", "", "toVariant", "Lkotlin/Function1;", "", "variantToString", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "choicesMap", "", "description", "getDescription", "()Ljava/lang/String;", "getToVariant", "()Lkotlin/jvm/functions/Function1;", "getVariantToString", "convert", "value", "name", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "kotlinx-cli"})
    public static final class Choice<T>
    extends ArgType<T> {
        @NotNull
        private final Function1<java.lang.String, T> toVariant;
        @NotNull
        private final Function1<T, java.lang.String> variantToString;
        @NotNull
        private final Map<java.lang.String, T> choicesMap;

        /*
         * WARNING - void declaration
         */
        public Choice(@NotNull List<? extends T> choices, @NotNull Function1<? super java.lang.String, ? extends T> toVariant, @NotNull Function1<? super T, java.lang.String> variantToString) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter(choices, "choices");
            Intrinsics.checkNotNullParameter(toVariant, "toVariant");
            Intrinsics.checkNotNullParameter(variantToString, "variantToString");
            super(true);
            this.toVariant = toVariant;
            this.variantToString = variantToString;
            Iterable iterable = choices;
            Choice choice = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            void var7_9 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object element$iv$iv;
                Object t = element$iv$iv = iterator2.next();
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(this.getVariantToString().invoke(it), element$iv$iv);
            }
            choice.choicesMap = destination$iv$iv;
            if (!(this.choicesMap.size() == choices.size())) {
                boolean bl = false;
                java.lang.String string = "Command line representations of enum choices are not distinct";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Choice(List list, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function12 = 1.INSTANCE;
            }
            this(list, function1, function12);
        }

        @NotNull
        public final Function1<java.lang.String, T> getToVariant() {
            return this.toVariant;
        }

        @NotNull
        public final Function1<T, java.lang.String> getVariantToString() {
            return this.variantToString;
        }

        @Override
        @NotNull
        public java.lang.String getDescription() {
            return "{ Value should be one of " + this.choicesMap.keySet() + " }";
        }

        @Override
        @NotNull
        public T convert(@NotNull java.lang.String value, @NotNull java.lang.String name2) {
            T t;
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(name2, "name");
            try {
                t = this.toVariant.invoke(value);
            }
            catch (Exception e) {
                throw new ParsingException("Option " + name2 + " is expected to be one of " + this.choicesMap.keySet() + ". " + value + " is provided.");
            }
            return t;
        }
    }
}

