/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnnotationMapper {
    @NotNull
    public static final JavaAnnotationMapper INSTANCE = new JavaAnnotationMapper();
    @NotNull
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    @NotNull
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    @NotNull
    private static final Name RETENTION_ANNOTATION_VALUE;
    @NotNull
    private static final Map<FqName, FqName> kotlinToJavaNameMap;
    @NotNull
    private static final Map<FqName, FqName> javaToKotlinNameMap;

    private JavaAnnotationMapper() {
    }

    @NotNull
    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    @NotNull
    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    @NotNull
    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation2, @NotNull LazyJavaResolverContext c, boolean isFreshlySupportedAnnotation) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Intrinsics.checkNotNullParameter(c, "c");
        ClassId classId = annotation2.getClassId();
        return Intrinsics.areEqual(classId, ClassId.topLevel(JvmAnnotationNames.TARGET_ANNOTATION)) ? (AnnotationDescriptor)new JavaTargetAnnotationDescriptor(annotation2, c) : (Intrinsics.areEqual(classId, ClassId.topLevel(JvmAnnotationNames.RETENTION_ANNOTATION)) ? (AnnotationDescriptor)new JavaRetentionAnnotationDescriptor(annotation2, c) : (Intrinsics.areEqual(classId, ClassId.topLevel(JvmAnnotationNames.REPEATABLE_ANNOTATION)) ? (AnnotationDescriptor)new JavaAnnotationDescriptor(c, annotation2, StandardNames.FqNames.repeatable) : (Intrinsics.areEqual(classId, ClassId.topLevel(JvmAnnotationNames.DOCUMENTED_ANNOTATION)) ? (AnnotationDescriptor)new JavaAnnotationDescriptor(c, annotation2, StandardNames.FqNames.mustBeDocumented) : (Intrinsics.areEqual(classId, ClassId.topLevel(JvmAnnotationNames.DEPRECATED_ANNOTATION)) ? null : (AnnotationDescriptor)new LazyJavaAnnotationDescriptor(c, annotation2, isFreshlySupportedAnnotation)))));
    }

    public static /* synthetic */ AnnotationDescriptor mapOrResolveJavaAnnotation$default(JavaAnnotationMapper javaAnnotationMapper, JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaAnnotationMapper.mapOrResolveJavaAnnotation(javaAnnotation, lazyJavaResolverContext, bl);
    }

    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        FqName fqName2;
        FqName fqName3;
        Intrinsics.checkNotNullParameter(kotlinName, "kotlinName");
        Intrinsics.checkNotNullParameter(annotationOwner, "annotationOwner");
        Intrinsics.checkNotNullParameter(c, "c");
        if (Intrinsics.areEqual(kotlinName, StandardNames.FqNames.deprecated)) {
            fqName3 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue(fqName3, "DEPRECATED_ANNOTATION");
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(fqName3);
            if (javaAnnotation != null || annotationOwner.isDeprecatedInJavaDoc()) {
                return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c);
            }
        }
        if ((fqName2 = kotlinToJavaNameMap.get(kotlinName)) == null) {
            annotationDescriptor = null;
        } else {
            fqName3 = fqName2;
            boolean bl = false;
            boolean bl2 = false;
            FqName javaName = fqName3;
            boolean bl3 = false;
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(javaName);
            if (javaAnnotation == null) {
                annotationDescriptor = null;
            } else {
                JavaAnnotation javaAnnotation2 = javaAnnotation;
                boolean bl4 = false;
                boolean bl5 = false;
                JavaAnnotation annotation2 = javaAnnotation2;
                boolean bl6 = false;
                annotationDescriptor = JavaAnnotationMapper.mapOrResolveJavaAnnotation$default(this, annotation2, c, false, 4, null);
            }
        }
        return annotationDescriptor;
    }

    static {
        Pair[] pairArray = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(pairArray, "identifier(\"message\")");
        DEPRECATED_ANNOTATION_MESSAGE = pairArray;
        pairArray = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue(pairArray, "identifier(\"allowedTargets\")");
        TARGET_ANNOTATION_ALLOWED_TARGETS = pairArray;
        pairArray = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue(pairArray, "identifier(\"value\")");
        RETENTION_ANNOTATION_VALUE = pairArray;
        pairArray = new Pair[]{TuplesKt.to(StandardNames.FqNames.target, JvmAnnotationNames.TARGET_ANNOTATION), TuplesKt.to(StandardNames.FqNames.retention, JvmAnnotationNames.RETENTION_ANNOTATION), TuplesKt.to(StandardNames.FqNames.repeatable, JvmAnnotationNames.REPEATABLE_ANNOTATION), TuplesKt.to(StandardNames.FqNames.mustBeDocumented, JvmAnnotationNames.DOCUMENTED_ANNOTATION)};
        kotlinToJavaNameMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(JvmAnnotationNames.TARGET_ANNOTATION, StandardNames.FqNames.target), TuplesKt.to(JvmAnnotationNames.RETENTION_ANNOTATION, StandardNames.FqNames.retention), TuplesKt.to(JvmAnnotationNames.DEPRECATED_ANNOTATION, StandardNames.FqNames.deprecated), TuplesKt.to(JvmAnnotationNames.REPEATABLE_ANNOTATION, StandardNames.FqNames.repeatable), TuplesKt.to(JvmAnnotationNames.DOCUMENTED_ANNOTATION, StandardNames.FqNames.mustBeDocumented)};
        javaToKotlinNameMap = MapsKt.mapOf(pairArray);
    }
}

