/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.serialization.constant.AnnotationValue;
import org.jetbrains.kotlin.fir.serialization.constant.ArrayValue;
import org.jetbrains.kotlin.fir.serialization.constant.BooleanValue;
import org.jetbrains.kotlin.fir.serialization.constant.ByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.CharValue;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValue;
import org.jetbrains.kotlin.fir.serialization.constant.DoubleValue;
import org.jetbrains.kotlin.fir.serialization.constant.EnumValue;
import org.jetbrains.kotlin.fir.serialization.constant.FloatValue;
import org.jetbrains.kotlin.fir.serialization.constant.IntValue;
import org.jetbrains.kotlin.fir.serialization.constant.KClassValue;
import org.jetbrains.kotlin.fir.serialization.constant.LongValue;
import org.jetbrains.kotlin.fir.serialization.constant.NullValue;
import org.jetbrains.kotlin.fir.serialization.constant.ShortValue;
import org.jetbrains.kotlin.fir.serialization.constant.StringValue;
import org.jetbrains.kotlin.fir.serialization.constant.UByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.UIntValue;
import org.jetbrains.kotlin.fir.serialization.constant.ULongValue;
import org.jetbrains.kotlin.fir.serialization.constant.UShortValue;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstantValue;", "", "()V", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "data", "visitArrayOfCall", "arrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "fir-serialization"})
public final class FirToConstantValueTransformer
extends FirDefaultVisitor {
    @NotNull
    public static final FirToConstantValueTransformer INSTANCE = new FirToConstantValueTransformer();

    private FirToConstantValueTransformer() {
    }

    @Override
    @Nullable
    public ConstantValue<?> visitElement(@NotNull FirElement element, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        String string2 = Intrinsics.stringPlus("Illegal element as annotation argument: ", Reflection.getOrCreateKotlinClass(element.getClass()).getQualifiedName());
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @Override
    @Nullable
    public <T> ConstantValue<?> visitConstExpression(@NotNull FirConstExpression<T> constExpression, @Nullable Void data2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(constExpression, "constExpression");
        T value2 = constExpression.getValue();
        FirConstKind<T> firConstKind = constExpression.getKind();
        if (Intrinsics.areEqual(firConstKind, FirConstKind.Boolean.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            constantValue = new BooleanValue((Boolean)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Char.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
            }
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Byte.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
            }
            constantValue = new ByteValue((Byte)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.UnsignedByte.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
            }
            constantValue = new UByteValue((Byte)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Short.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
            }
            constantValue = new ShortValue((Short)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.UnsignedShort.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
            }
            constantValue = new UShortValue((Short)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Int.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            constantValue = new IntValue((Integer)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.UnsignedInt.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            constantValue = new UIntValue((Integer)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Long.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
            }
            constantValue = new LongValue((Long)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.UnsignedLong.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
            }
            constantValue = new ULongValue((Long)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.String.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            constantValue = new StringValue((String)value2);
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Float.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            constantValue = new FloatValue(((Float)value2).floatValue());
        } else if (Intrinsics.areEqual(firConstKind, FirConstKind.Double.INSTANCE)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            constantValue = new DoubleValue((Double)value2);
        } else {
            constantValue = Intrinsics.areEqual(firConstKind, FirConstKind.Null.INSTANCE) ? (ConstantValue)NullValue.INSTANCE : null;
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ConstantValue<?> visitArrayOfCall(@NotNull FirArrayOfCall arrayOfCall, @Nullable Void data2) {
        List list2;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(arrayOfCall, "arrayOfCall");
        Iterable $this$mapNotNull$iv = arrayOfCall.getArgumentList().getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue constantValue;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if ((ConstantValue)it.accept(this, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ConstantValue it$iv$iv = constantValue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list2 = (List)destination$iv$iv;
        return new ArrayValue(list3);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        return new AnnotationValue(annotationCall);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitGetClassCall(@NotNull FirGetClassCall getClassCall, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(getClassCall, "getClassCall");
        FirTypeRef $this$coneTypeUnsafe$iv = getClassCall.getTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        return KClassValue.Companion.create(coneKotlinType);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable Void data2) {
        ClassId classId;
        FirEnumEntry firEnumEntry;
        Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (firCallableSymbol == null) {
            return null;
        }
        FirCallableSymbol<?> symbol2 = firCallableSymbol;
        Object object = symbol2.getFir();
        FirEnumEntry firEnumEntry2 = firEnumEntry = object instanceof FirEnumEntry ? (FirEnumEntry)object : null;
        if (firEnumEntry == null) {
            return null;
        }
        FirEnumEntry enumEntry = firEnumEntry;
        FirTypeRef $this$coneType$iv = enumEntry.getReturnTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        object = ConeTypeUtilsKt.getClassId(coneKotlinType);
        if (object == null) {
            return null;
        }
        Object classId2 = object;
        ClassId classId3 = ((ClassId)classId2).getOuterClassId();
        if (classId3 == null) {
            return null;
        }
        ClassId outerClassId = classId = classId3;
        return new EnumValue(outerClassId, enumEntry.getName());
    }
}

