/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.DefaultHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002()B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "oldLoopToNewLoop", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;Ljava/util/Map;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/DefaultHeaderInfoBuilder;", "headerProcessor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "gatherLoopVariableInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "lowerHeader", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "loopHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "lowerWhileLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "FindInitializerCallVisitor", "LoopVariableInfo", "ir.backend.common"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;
    @NotNull
    private final DefaultHeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final HeaderProcessor headerProcessor;

    public RangeLoopTransformer(@NotNull CommonBackendContext context2, @NotNull IrSymbolOwner container2, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(container2, "container");
        Intrinsics.checkNotNullParameter(oldLoopToNewLoop, "oldLoopToNewLoop");
        this.context = context2;
        this.container = container2;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.headerInfoBuilder = new DefaultHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            @NotNull
            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }
        });
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            @NotNull
            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }
        });
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Scope scope2;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        IrSymbol irSymbol = scopeWithIr == null ? null : ((scope2 = scopeWithIr.getScope()) == null ? null : scope2.getScopeOwnerSymbol());
        return irSymbol == null ? this.container.getSymbol() : irSymbol;
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.FOR_LOOP.INSTANCE)) {
            return super.visitBlock(expression2);
        }
        List<IrStatement> list2 = expression2.getStatements();
        boolean bl = false;
        boolean bl2 = false;
        List<IrStatement> $this$visitBlock_u24lambda_u2d3 = list2;
        boolean bl3 = false;
        boolean bl4 = $this$visitBlock_u24lambda_u2d3.size() == 2;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$622 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$622 = Intrinsics.stringPlus("Expected 2 statements in for-loop block, was:\n", DumpIrTreeKt.dump$default(expression2, false, 1, null));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$622));
        }
        IrVariable iteratorVariable = (IrVariable)$this$visitBlock_u24lambda_u2d3.get(0);
        bl5 = Intrinsics.areEqual(iteratorVariable.getOrigin(), IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$622 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$52 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$52 = Intrinsics.stringPlus("Expected FOR_LOOP_ITERATOR origin for iterator variable, was:\n", DumpIrTreeKt.dump$default(iteratorVariable, false, 1, null));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$52));
        }
        ForLoopHeader $i$a$-assert-RangeLoopTransformer$visitBlock$1$622 = this.headerProcessor.extractHeader(iteratorVariable);
        if ($i$a$-assert-RangeLoopTransformer$visitBlock$1$622 == null) {
            return super.visitBlock(expression2);
        }
        ForLoopHeader loopHeader = $i$a$-assert-RangeLoopTransformer$visitBlock$1$622;
        IrStatement loweredHeader = this.lowerHeader(iteratorVariable, loopHeader);
        IrWhileLoop oldLoop = (IrWhileLoop)$this$visitBlock_u24lambda_u2d3.get(1);
        boolean bl6 = Intrinsics.areEqual(oldLoop.getOrigin(), IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        boolean bl7 = false;
        if (_Assertions.ENABLED && !bl6) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = Intrinsics.stringPlus("Expected FOR_LOOP_INNER_WHILE origin for while loop, was:\n", DumpIrTreeKt.dump$default(oldLoop, false, 1, null));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$42));
        }
        LoopReplacement loopReplacement = this.lowerWhileLoop(oldLoop, loopHeader);
        if (loopReplacement == null) {
            return super.visitBlock(expression2);
        }
        LoopReplacement loopReplacement2 = loopReplacement;
        IrLoop newLoop = loopReplacement2.component1();
        IrExpression loopReplacementExpression = loopReplacement2.component2();
        Map<IrLoop, IrLoop> map = this.getOldLoopToNewLoop();
        boolean bl8 = false;
        map.put(oldLoop, newLoop);
        $this$visitBlock_u24lambda_u2d3.set(0, loweredHeader);
        $this$visitBlock_u24lambda_u2d3.set(1, loopReplacementExpression);
        return super.visitBlock(expression2);
    }

    private final IrStatement lowerHeader(IrVariable variable2, ForLoopHeader loopHeader) {
        return new IrCompositeImpl(variable2.getStartOffset(), variable2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, loopHeader.getLoopInitStatements());
    }

    private final LoopReplacement lowerWhileLoop(IrWhileLoop loop2, ForLoopHeader loopHeader) {
        IrExpression irExpression;
        boolean bl;
        Object object;
        IrExpression irExpression2 = loop2.getBody();
        IrContainerExpression irContainerExpression = irExpression2 instanceof IrContainerExpression ? (IrContainerExpression)irExpression2 : null;
        Object object2 = object = irContainerExpression == null ? null : irContainerExpression.getStatements();
        if (object == null) {
            return null;
        }
        List<IrStatement> loopBodyStatements = object;
        object = this.gatherLoopVariableInfo(loopBodyStatements);
        IrVariable mainLoopVariable = ((LoopVariableInfo)object).component1();
        int mainLoopVariableIndex = ((LoopVariableInfo)object).component2();
        Map<Integer, IrVariable> loopVariableComponents = ((LoopVariableInfo)object).component3();
        List<Integer> loopVariableComponentIndices = ((LoopVariableInfo)object).component4();
        if (loopHeader.getConsumesLoopVariableComponents() && !Intrinsics.areEqual(mainLoopVariable.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE)) {
            return null;
        }
        IrExpression irExpression3 = mainLoopVariable.getInitializer();
        Intrinsics.checkNotNull(irExpression3);
        IrExpression initializer2 = irExpression3;
        Object object3 = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer2.getStartOffset(), initializer2.getEndOffset());
        boolean bl2 = false;
        boolean bl3 = false;
        DeclarationIrBuilder $this$lowerWhileLoop_u24lambda_u2d4 = object3;
        boolean bl4 = false;
        IrCompositeImpl replacement = new IrCompositeImpl(mainLoopVariable.getStartOffset(), mainLoopVariable.getEndOffset(), $this$lowerWhileLoop_u24lambda_u2d4.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE, loopHeader.initializeIteration(mainLoopVariable, loopVariableComponents, $this$lowerWhileLoop_u24lambda_u2d4));
        if (loopHeader.getConsumesLoopVariableComponents()) {
            object3 = CollectionsKt.asReversed(loopVariableComponentIndices).iterator();
            while (object3.hasNext()) {
                int index2 = ((Number)object3.next()).intValue();
                bl3 = index2 > mainLoopVariableIndex;
                boolean bl5 = false;
                bl = false;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl6 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                loopBodyStatements.remove(index2);
            }
        }
        loopBodyStatements.set(mainLoopVariableIndex, replacement);
        IrExpression irExpression4 = loop2.getBody();
        if (irExpression4 == null) {
            irExpression = null;
        } else {
            IrExpression irExpression5 = irExpression4;
            boolean bl7 = false;
            bl = false;
            IrExpression it = irExpression5;
            boolean bl8 = false;
            irExpression = it instanceof IrContainerExpression && !((IrContainerExpression)it).isTransparentScope() ? (IrExpression)new IrCompositeImpl(loop2.getStartOffset(), loop2.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        }
        IrExpression newBody = irExpression;
        return loopHeader.buildLoop(LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop2.getStartOffset(), loop2.getEndOffset()), loop2, newBody);
    }

    private final LoopVariableInfo gatherLoopVariableInfo(List<IrStatement> statements2) {
        IrStatement mainLoopVariable = null;
        int mainLoopVariableIndex = -1;
        boolean bl = false;
        Map loopVariableComponents = new LinkedHashMap();
        boolean bl2 = false;
        List loopVariableComponentIndices = new ArrayList();
        Object object = statements2.iterator();
        int n = 0;
        while (object.hasNext()) {
            IrStatementOrigin origin;
            Object object2;
            IrCall irCall;
            int i = n++;
            IrStatement stmt = (IrStatement)object.next();
            if (!(stmt instanceof IrVariable)) continue;
            IrExpression irExpression = ((IrVariable)stmt).getInitializer();
            if (irExpression == null) {
                irCall = null;
            } else {
                object2 = irExpression;
                boolean bl3 = false;
                boolean bl4 = false;
                IrExpression it = object2;
                boolean bl5 = false;
                FindInitializerCallVisitor findInitializerCallVisitor = new FindInitializerCallVisitor((IrVariable)mainLoopVariable);
                boolean bl6 = false;
                boolean bl7 = false;
                FindInitializerCallVisitor $this$gatherLoopVariableInfo_u24lambda_u2d7_u24lambda_u2d6 = findInitializerCallVisitor;
                boolean bl8 = false;
                IrElementVisitorVoidKt.acceptVoid(it, $this$gatherLoopVariableInfo_u24lambda_u2d7_u24lambda_u2d6);
                irCall = findInitializerCallVisitor.getInitializerCall();
            }
            IrCall initializer2 = irCall;
            object2 = initializer2;
            IrStatementOrigin irStatementOrigin = origin = object2 == null ? null : ((IrMemberAccessExpression)object2).getOrigin();
            if (Intrinsics.areEqual(origin, IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE)) {
                mainLoopVariable = stmt;
                mainLoopVariableIndex = i;
                continue;
            }
            if (!(origin instanceof IrStatementOrigin.COMPONENT_N)) continue;
            object2 = loopVariableComponents;
            Integer n2 = ((IrStatementOrigin.COMPONENT_N)origin).getIndex();
            IrVariable irVariable2 = (IrVariable)stmt;
            boolean bl9 = false;
            object2.put(n2, irVariable2);
            loopVariableComponentIndices.add(i);
        }
        object = (IrVariable)mainLoopVariable;
        n = 0;
        boolean bl10 = false;
        if (object == null) {
            boolean bl11 = false;
            String string2 = "No 'next' statement in for-loop";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        boolean bl12 = mainLoopVariableIndex >= 0;
        n = 0;
        bl10 = false;
        if (_Assertions.ENABLED && !bl12) {
            boolean bl13 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        return new LoopVariableInfo((IrVariable)mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003JC\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "mainLoopVariableIndex", "", "loopVariableComponents", "", "loopVariableComponentIndices", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;ILjava/util/Map;Ljava/util/List;)V", "getLoopVariableComponentIndices", "()Ljava/util/List;", "getLoopVariableComponents", "()Ljava/util/Map;", "getMainLoopVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getMainLoopVariableIndex", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class LoopVariableInfo {
        @NotNull
        private final IrVariable mainLoopVariable;
        private final int mainLoopVariableIndex;
        @NotNull
        private final Map<Integer, IrVariable> loopVariableComponents;
        @NotNull
        private final List<Integer> loopVariableComponentIndices;

        public LoopVariableInfo(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter(mainLoopVariable, "mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, "loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, "loopVariableComponentIndices");
            this.mainLoopVariable = mainLoopVariable;
            this.mainLoopVariableIndex = mainLoopVariableIndex;
            this.loopVariableComponents = loopVariableComponents;
            this.loopVariableComponentIndices = loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable getMainLoopVariable() {
            return this.mainLoopVariable;
        }

        public final int getMainLoopVariableIndex() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> getLoopVariableComponents() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> getLoopVariableComponentIndices() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable component1() {
            return this.mainLoopVariable;
        }

        public final int component2() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> component3() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> component4() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final LoopVariableInfo copy(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter(mainLoopVariable, "mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, "loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, "loopVariableComponentIndices");
            return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
        }

        public static /* synthetic */ LoopVariableInfo copy$default(LoopVariableInfo loopVariableInfo, IrVariable irVariable2, int n, Map map, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irVariable2 = loopVariableInfo.mainLoopVariable;
            }
            if ((n2 & 2) != 0) {
                n = loopVariableInfo.mainLoopVariableIndex;
            }
            if ((n2 & 4) != 0) {
                map = loopVariableInfo.loopVariableComponents;
            }
            if ((n2 & 8) != 0) {
                list2 = loopVariableInfo.loopVariableComponentIndices;
            }
            return loopVariableInfo.copy(irVariable2, n, map, list2);
        }

        @NotNull
        public String toString() {
            return "LoopVariableInfo(mainLoopVariable=" + this.mainLoopVariable + ", mainLoopVariableIndex=" + this.mainLoopVariableIndex + ", loopVariableComponents=" + this.loopVariableComponents + ", loopVariableComponentIndices=" + this.loopVariableComponentIndices + ')';
        }

        public int hashCode() {
            int result2 = this.mainLoopVariable.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.mainLoopVariableIndex);
            result2 = result2 * 31 + ((Object)this.loopVariableComponents).hashCode();
            result2 = result2 * 31 + ((Object)this.loopVariableComponentIndices).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopVariableInfo)) {
                return false;
            }
            LoopVariableInfo loopVariableInfo = (LoopVariableInfo)other;
            if (!Intrinsics.areEqual(this.mainLoopVariable, loopVariableInfo.mainLoopVariable)) {
                return false;
            }
            if (this.mainLoopVariableIndex != loopVariableInfo.mainLoopVariableIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loopVariableComponents, loopVariableInfo.loopVariableComponents)) {
                return false;
            }
            return Intrinsics.areEqual(this.loopVariableComponentIndices, loopVariableInfo.loopVariableComponentIndices);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$FindInitializerCallVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;)V", "initializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "visitCall", "", "expression", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.backend.common"})
    private static final class FindInitializerCallVisitor
    implements IrElementVisitorVoid {
        @Nullable
        private final IrVariable mainLoopVariable;
        @Nullable
        private IrCall initializerCall;

        public FindInitializerCallVisitor(@Nullable IrVariable mainLoopVariable) {
            this.mainLoopVariable = mainLoopVariable;
        }

        @Nullable
        public final IrCall getInitializerCall() {
            return this.initializerCall;
        }

        public final void setInitializerCall(@Nullable IrCall irCall) {
            this.initializerCall = irCall;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            IrExpression irExpression;
            IrGetValue irGetValue;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Object object = expression2.getOrigin();
            IrCall irCall = Intrinsics.areEqual(object, IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE) ? expression2 : (object instanceof IrStatementOrigin.COMPONENT_N ? (this.mainLoopVariable != null && Intrinsics.areEqual((irGetValue = (irExpression = expression2.getDispatchReceiver()) instanceof IrGetValue ? (IrGetValue)irExpression : null) == null ? null : irGetValue.getSymbol(), this.mainLoopVariable.getSymbol()) ? expression2 : (IrCall)null) : null);
            IrCall candidateCall = irCall;
            if (candidateCall == null) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            } else if (this.initializerCall == null) {
                this.initializerCall = candidateCall;
            } else {
                StringBuilder stringBuilder2 = new StringBuilder().append("Multiple initializer calls found. First: ");
                object = this.initializerCall;
                Intrinsics.checkNotNull(object);
                throw new IllegalStateException(stringBuilder2.append(RenderIrElementKt.render((IrElement)object)).append("\nSecond: ").append(RenderIrElementKt.render(candidateCall)).toString());
            }
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }
    }
}

