/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.extensions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.extensions.predicate.AnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.AnnotatedWithMeta;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicateVisitor;
import org.jetbrains.kotlin.fir.extensions.predicate.MetaAnnotated;
import org.jetbrains.kotlin.fir.extensions.predicate.UnderAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.UnderMetaAnnotated;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0002#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J6\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00190\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00190\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0016J\u001e\u0010!\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eH\u0002J*\u0010\"\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00190\u0010*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cache", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "matcher", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "registeredPluginAnnotations", "Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotations;", "fileHasPluginAnnotations", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getOwnersOfDeclaration", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "declaration", "getSymbolsByPredicate", "declarations", "", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "getSymbolsWithOwnersByPredicate", "Lkotlin/Pair;", "matches", "registerAnnotatedDeclaration", "", "owners", "Lkotlinx/collections/immutable/PersistentList;", "registerGeneratedDeclaration", "owner", "registerOwnersDeclarations", "zipWithParents", "Cache", "Matcher", "resolve"})
final class FirPredicateBasedProviderImpl
extends FirPredicateBasedProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirRegisteredPluginAnnotations registeredPluginAnnotations;
    @NotNull
    private final Cache cache;
    @NotNull
    private final Matcher matcher;

    public FirPredicateBasedProviderImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session);
        this.cache = new Cache();
        this.matcher = new Matcher();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotatedDeclaration> getSymbolsByPredicate(@NotNull DeclarationPredicate predicate) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Set<FqName> annotations2 = this.registeredPluginAnnotations.getAnnotationsForPredicate(predicate);
        if (annotations2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = annotations2;
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FqName it = (FqName)element$iv;
            boolean bl2 = false;
            Collection<FirAnnotatedDeclaration> collection2 = this.cache.getDeclarationByAnnotation().get(it);
            Intrinsics.checkNotNullExpressionValue(collection2, "cache.declarationByAnnotation[it]");
            Collection<FirAnnotatedDeclaration> collection3 = collection2;
            collection2 = this.cache.getDeclarationsUnderAnnotated().get(it);
            Intrinsics.checkNotNullExpressionValue(collection2, "cache.declarationsUnderAnnotated[it]");
            Iterable list$iv = CollectionsKt.plus(collection3, (Iterable)collection2);
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        Set declarations2 = (Set)destination$iv;
        return this.getSymbolsByPredicate(declarations2, predicate);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotatedDeclaration> getSymbolsByPredicate(@NotNull Collection<? extends FirAnnotatedDeclaration> declarations2, @NotNull DeclarationPredicate predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(declarations2, "declarations");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Iterable $this$filter$iv = declarations2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirAnnotatedDeclaration it = (FirAnnotatedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!this.matches(predicate, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> getSymbolsWithOwnersByPredicate(@NotNull DeclarationPredicate predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return this.zipWithParents(this.getSymbolsByPredicate(predicate));
    }

    @Override
    @NotNull
    public List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> getSymbolsWithOwnersByPredicate(@NotNull Collection<? extends FirAnnotatedDeclaration> declarations2, @NotNull DeclarationPredicate predicate) {
        Intrinsics.checkNotNullParameter(declarations2, "declarations");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return this.zipWithParents(this.getSymbolsByPredicate(declarations2, predicate));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> zipWithParents(List<? extends FirAnnotatedDeclaration> $this$zipWithParents) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$zipWithParents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirAnnotatedDeclaration firAnnotatedDeclaration = (FirAnnotatedDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<void, PersistentList<FirAnnotatedDeclaration>> pair = TuplesKt.to(it, MapsKt.getValue(this.cache.getOwnersForDeclaration(), it));
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean fileHasPluginAnnotations(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return this.cache.getFilesWithPluginAnnotations().contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerAnnotatedDeclaration(@NotNull FirAnnotatedDeclaration declaration2, @NotNull PersistentList<? extends FirAnnotatedDeclaration> owners) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(owners, "owners");
        Map<FirAnnotatedDeclaration, PersistentList<FirAnnotatedDeclaration>> map = this.cache.getOwnersForDeclaration();
        boolean bl = false;
        map.put(declaration2, owners);
        this.registerOwnersDeclarations(declaration2, owners);
        if (declaration2.getAnnotations().isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = declaration2.getAnnotations();
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FqName fqName2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl3 = false;
            if (ResolveUtilsKt.fqName(it, this.session) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            FqName it$iv$iv = fqName2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl7 = false;
            if (!this.registeredPluginAnnotations.getAnnotations().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingAnnotations = (List)destination$iv$iv;
        if (matchingAnnotations.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = matchingAnnotations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl8 = false;
            this.cache.getDeclarationByAnnotation().put(it, declaration2);
        }
        this.cache.getAnnotationsOfDeclaration().putAll((Object)declaration2, (Iterable)matchingAnnotations);
        FirFile file2 = (FirFile)CollectionsKt.first((List)owners);
        Cache cache2 = this.cache;
        object = cache2.getFilesWithPluginAnnotations();
        boolean bl9 = false;
        object.add(file2);
    }

    @Override
    @Nullable
    public List<FirAnnotatedDeclaration> getOwnersOfDeclaration(@NotNull FirAnnotatedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.cache.getOwnersForDeclaration().get(declaration2);
    }

    @Override
    public void registerGeneratedDeclaration(@NotNull FirAnnotatedDeclaration declaration2, @NotNull FirAnnotatedDeclaration owner) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(owner, "owner");
        PersistentList<FirAnnotatedDeclaration> owners = MapsKt.getValue(this.cache.getOwnersForDeclaration(), owner).add(owner);
        this.registerAnnotatedDeclaration(declaration2, owners);
    }

    private final void registerOwnersDeclarations(FirAnnotatedDeclaration declaration2, PersistentList<? extends FirAnnotatedDeclaration> owners) {
        FirAnnotatedDeclaration firAnnotatedDeclaration = (FirAnnotatedDeclaration)CollectionsKt.lastOrNull((List)owners);
        if (firAnnotatedDeclaration == null) {
            return;
        }
        FirAnnotatedDeclaration lastOwner = firAnnotatedDeclaration;
        Set annotationsFromLastOwner = this.cache.getAnnotationsOfDeclaration().get((Object)lastOwner);
        Set annotationsFromPreviousOwners = this.cache.getParentAnnotationsOfDeclaration().get((Object)lastOwner);
        Intrinsics.checkNotNullExpressionValue(annotationsFromLastOwner, "annotationsFromLastOwner");
        Intrinsics.checkNotNullExpressionValue(annotationsFromPreviousOwners, "annotationsFromPreviousOwners");
        Set allParentDeclarations = SetsKt.plus(annotationsFromLastOwner, annotationsFromPreviousOwners);
        Iterable $this$forEach$iv = allParentDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsUnderAnnotated().put(it, declaration2);
        }
        this.cache.getParentAnnotationsOfDeclaration().putAll((Object)declaration2, allParentDeclarations);
    }

    @Override
    public boolean matches(@NotNull DeclarationPredicate predicate, @NotNull FirAnnotatedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return (Boolean)predicate.accept$resolve(this.matcher, declaration2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\"\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\u001d\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010)R\"\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicateVisitor;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "(Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;)V", "userDefinedAnnotations", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotated;", "getUserDefinedAnnotations", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotated;)Ljava/util/Set;", "matchUnder", "declaration", "annotations", "matchWith", "visitAnd", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$And;", "data", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$And;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWithMeta", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWithMeta;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWithMeta;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitAny", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Any;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Any;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitOr", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Or;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Or;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitPredicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitUnderAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitUnderMetaAnnotated", "Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderMetaAnnotated;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderMetaAnnotated;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "resolve"})
    private final class Matcher
    extends DeclarationPredicateVisitor<Boolean, FirAnnotatedDeclaration> {
        public Matcher() {
            Intrinsics.checkNotNullParameter(FirPredicateBasedProviderImpl.this, "this$0");
        }

        @Override
        @NotNull
        public Boolean visitPredicate(@NotNull DeclarationPredicate predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            throw new IllegalStateException("Should not be there");
        }

        @Override
        @NotNull
        public Boolean visitAny(@NotNull DeclarationPredicate.Any predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return true;
        }

        @Override
        @NotNull
        public Boolean visitAnd(@NotNull DeclarationPredicate.And predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return (Boolean)predicate.getA().accept$resolve(this, data2) != false && (Boolean)predicate.getB().accept$resolve(this, data2) != false;
        }

        @Override
        @NotNull
        public Boolean visitOr(@NotNull DeclarationPredicate.Or predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return (Boolean)predicate.getA().accept$resolve(this, data2) != false || (Boolean)predicate.getB().accept$resolve(this, data2) != false;
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWith(@NotNull AnnotatedWith predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchWith(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitUnderAnnotatedWith(@NotNull UnderAnnotatedWith predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchUnder(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWithMeta(@NotNull AnnotatedWithMeta predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchWith(data2, this.getUserDefinedAnnotations(predicate));
        }

        @Override
        @NotNull
        public Boolean visitUnderMetaAnnotated(@NotNull UnderMetaAnnotated predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchUnder(data2, this.getUserDefinedAnnotations(predicate));
        }

        /*
         * WARNING - void declaration
         */
        private final Set<FqName> getUserDefinedAnnotations(MetaAnnotated $this$userDefinedAnnotations) {
            void $this$flatMapTo$iv;
            Iterable iterable = $this$userDefinedAnnotations.getMetaAnnotations();
            boolean bl = false;
            Collection collection = new LinkedHashSet();
            FirPredicateBasedProviderImpl firPredicateBasedProviderImpl = FirPredicateBasedProviderImpl.this;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                void destination$iv;
                FqName it = (FqName)element$iv;
                boolean bl2 = false;
                Iterable list$iv = firPredicateBasedProviderImpl.registeredPluginAnnotations.getAnnotationsWithMetaAnnotation(it);
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            return (Set)collection;
        }

        private final boolean matchWith(FirAnnotatedDeclaration declaration2, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfDeclaration().get((Object)declaration2);
                Intrinsics.checkNotNullExpressionValue(set, "cache.annotationsOfDeclaration[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchUnder(FirAnnotatedDeclaration declaration2, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getParentAnnotationsOfDeclaration().get((Object)declaration2);
                Intrinsics.checkNotNullExpressionValue(set, "cache.parentAnnotationsOfDeclaration[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "", "()V", "annotationsOfDeclaration", "Lcom/google/common/collect/LinkedHashMultimap;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "getAnnotationsOfDeclaration", "()Lcom/google/common/collect/LinkedHashMultimap;", "declarationByAnnotation", "Lcom/google/common/collect/Multimap;", "getDeclarationByAnnotation", "()Lcom/google/common/collect/Multimap;", "declarationsUnderAnnotated", "getDeclarationsUnderAnnotated", "filesWithPluginAnnotations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesWithPluginAnnotations", "()Ljava/util/Set;", "ownersForDeclaration", "", "Lkotlinx/collections/immutable/PersistentList;", "getOwnersForDeclaration", "()Ljava/util/Map;", "parentAnnotationsOfDeclaration", "getParentAnnotationsOfDeclaration", "resolve"})
    private static final class Cache {
        @NotNull
        private final Multimap<FqName, FirAnnotatedDeclaration> declarationByAnnotation;
        @NotNull
        private final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> annotationsOfDeclaration;
        @NotNull
        private final Multimap<FqName, FirAnnotatedDeclaration> declarationsUnderAnnotated;
        @NotNull
        private final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> parentAnnotationsOfDeclaration;
        @NotNull
        private final Map<FirAnnotatedDeclaration, PersistentList<FirAnnotatedDeclaration>> ownersForDeclaration;
        @NotNull
        private final Set<FirFile> filesWithPluginAnnotations;

        public Cache() {
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, "create()");
            this.declarationByAnnotation = linkedHashMultimap;
            linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, "create()");
            this.annotationsOfDeclaration = linkedHashMultimap;
            linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, "create()");
            this.declarationsUnderAnnotated = linkedHashMultimap;
            linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, "create()");
            this.parentAnnotationsOfDeclaration = linkedHashMultimap;
            boolean bl = false;
            this.ownersForDeclaration = new LinkedHashMap();
            bl = false;
            this.filesWithPluginAnnotations = new LinkedHashSet();
        }

        @NotNull
        public final Multimap<FqName, FirAnnotatedDeclaration> getDeclarationByAnnotation() {
            return this.declarationByAnnotation;
        }

        @NotNull
        public final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> getAnnotationsOfDeclaration() {
            return this.annotationsOfDeclaration;
        }

        @NotNull
        public final Multimap<FqName, FirAnnotatedDeclaration> getDeclarationsUnderAnnotated() {
            return this.declarationsUnderAnnotated;
        }

        @NotNull
        public final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> getParentAnnotationsOfDeclaration() {
            return this.parentAnnotationsOfDeclaration;
        }

        @NotNull
        public final Map<FirAnnotatedDeclaration, PersistentList<FirAnnotatedDeclaration>> getOwnersForDeclaration() {
            return this.ownersForDeclaration;
        }

        @NotNull
        public final Set<FirFile> getFilesWithPluginAnnotations() {
            return this.filesWithPluginAnnotations;
        }
    }
}

