/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser;", "", "()V", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParseResult;", "file", "Ljava/io/File;", "content", "", "jsonObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "MappingStream", "js.parser"})
public final class SourceMapParser {
    @NotNull
    public static final SourceMapParser INSTANCE = new SourceMapParser();

    private SourceMapParser() {
    }

    @NotNull
    public final SourceMapParseResult parse(@NotNull File file2) throws IOException {
        Intrinsics.checkNotNullParameter(file2, "file");
        return this.parse(FilesKt.readText(file2, Charsets.UTF_8));
    }

    @NotNull
    public final SourceMapParseResult parse(@NotNull String content) throws IOException {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter(content, "content");
        try {
            jsonNode = JSONKt.parseJson(content);
        }
        catch (JsonSyntaxException e) {
            String string2 = e.getMessage();
            return new SourceMapError(string2 == null ? "parse error" : string2);
        }
        JsonNode jsonObject = jsonNode;
        return this.parse(jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    private final SourceMapParseResult parse(JsonNode jsonObject) throws IOException {
        void $this$associateTo$iv$iv;
        List list2;
        List list3;
        String string2;
        SourceMapGroup it;
        Object object;
        Iterable destination$iv$iv;
        JsonArray sourcesProperty;
        String string3;
        JsonNode version;
        if (!(jsonObject instanceof JsonObject)) {
            return new SourceMapError("Top-level object expected");
        }
        JsonNode jsonNode = ((JsonObject)jsonObject).getProperties().get("version");
        if (jsonNode == null) {
            return new SourceMapError("Version not defined");
        }
        jsonNode = version = jsonNode;
        boolean bl = false;
        boolean bl2 = false;
        JsonNode it422 = jsonNode;
        boolean bl3 = false;
        if (!(version instanceof JsonNumber) || !(((JsonNumber)version).getValue() == 3.0)) {
            return new SourceMapError(Intrinsics.stringPlus("Unsupported version: ", it422));
        }
        JsonNode jsonNode2 = ((JsonObject)jsonObject).getProperties().get("sourceRoot");
        bl2 = false;
        boolean it422 = false;
        JsonNode it32 = jsonNode2;
        boolean bl4 = false;
        if (it32 != null) {
            JsonString jsonString;
            JsonString jsonString2 = jsonString = it32 instanceof JsonString ? (JsonString)it32 : null;
            if (jsonString == null) {
                return new SourceMapError("'sourceRoot' property is not of string type");
            }
            string3 = jsonString.getValue();
        } else {
            string3 = "";
        }
        String sourceRoot = string3;
        JsonNode jsonNode3 = ((JsonObject)jsonObject).getProperties().get("sources");
        it422 = false;
        boolean it32 = false;
        JsonNode it22 = jsonNode3;
        boolean bl5 = false;
        if (it22 != null) {
            void $this$mapTo$iv$iv;
            JsonArray jsonArray;
            JsonArray jsonArray2 = jsonArray = it22 instanceof JsonArray ? (JsonArray)it22 : null;
            if (jsonArray == null) {
                return new SourceMapError("'sources' property is not of array type");
            }
            sourcesProperty = jsonArray;
            Iterable $this$map$iv = sourcesProperty.getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonString jsonString;
                JsonNode jsonNode4 = (JsonNode)item$iv$iv;
                object = destination$iv$iv;
                boolean bl6 = false;
                JsonString jsonString3 = jsonString = it instanceof JsonString ? (JsonString)((Object)it) : null;
                if (jsonString == null) {
                    return new SourceMapError("'sources' array must contain strings");
                }
                string2 = jsonString.getValue();
                object.add(string2);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List sources = list3;
        JsonNode it422 = ((JsonObject)jsonObject).getProperties().get("sourcesContent");
        it32 = false;
        boolean it22 = false;
        JsonNode it5 = it422;
        boolean $i$a$-let-SourceMapParser$parse$sourcesContent$22 = false;
        if (it5 != null) {
            void $this$mapTo$iv$iv;
            JsonArray jsonArray = sourcesProperty = it5 instanceof JsonArray ? (JsonArray)it5 : null;
            if (sourcesProperty == null) {
                return new SourceMapError("'sourcesContent' property is not of array type");
            }
            JsonArray sourcesContentProperty = sourcesProperty;
            Iterable $this$map$iv = sourcesContentProperty.getElements();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string4;
                void it6;
                object = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl7 = false;
                string2 = it6;
                if (string2 instanceof JsonNull) {
                    string4 = null;
                } else if (string2 instanceof JsonString) {
                    string4 = ((JsonString)it6).getValue();
                } else {
                    return new SourceMapError("'sources' array must contain strings");
                }
                String string5 = string4;
                collection.add(string5);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List sourcesContent = list2;
        Iterable $this$associate$iv = CollectionsKt.zip((Iterable)sources, sourcesContent);
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable $i$a$-let-SourceMapParser$parse$sourcesContent$22 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            Pair it7 = (Pair)element$iv$iv;
            boolean bl8 = false;
            Pair pair = it7;
            boolean bl9 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map sourcePathToContent = destination$iv$iv3;
        JsonNode $i$f$associate22 = ((JsonObject)jsonObject).getProperties().get("mappings");
        if ($i$f$associate22 == null) {
            return new SourceMapError("'mappings' property not found");
        }
        JsonNode mappings = $i$f$associate22;
        if (!(mappings instanceof JsonString)) {
            return new SourceMapError("'mappings' property is not of string type");
        }
        int jsColumn = 0;
        int sourceLine = 0;
        int sourceColumn = 0;
        int sourceIndex = 0;
        MappingStream stream = new MappingStream(((JsonString)mappings).getValue());
        SourceMap sourceMap2 = new SourceMap((Function1<? super String, ? extends Reader>)new Function1<String, Reader>((Map<String, String>)sourcePathToContent){
            final /* synthetic */ Map<String, String> $sourcePathToContent;
            {
                this.$sourcePathToContent = $sourcePathToContent;
                super(1);
            }

            @Nullable
            public final Reader invoke(@NotNull String it) {
                StringReader stringReader;
                Intrinsics.checkNotNullParameter(it, "it");
                String string2 = this.$sourcePathToContent.get(it);
                if (string2 == null) {
                    stringReader = null;
                } else {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it2 = string3;
                    boolean bl3 = false;
                    stringReader = new StringReader(it2);
                }
                return stringReader;
            }
        });
        Object object2 = new SourceMapGroup();
        boolean bl10 = false;
        boolean bl11 = false;
        it = object2;
        boolean bl12 = false;
        SourceMap sourceMap3 = sourceMap2;
        Collection collection = sourceMap3.getGroups();
        boolean bl13 = false;
        collection.add(it);
        Object currentGroup = object2;
        while (!stream.isEof()) {
            boolean it82;
            SourceMapSegment sourceMapSegment;
            Collection collection2;
            if (stream.isGroupTerminator()) {
                object2 = new SourceMapGroup();
                boolean bl14 = false;
                boolean bl15 = false;
                Object it82 = object2;
                boolean bl16 = false;
                sourceMap3 = sourceMap2;
                collection = sourceMap3.getGroups();
                bl13 = false;
                collection.add(it82);
                currentGroup = object2;
                jsColumn = 0;
                stream.skipChar();
                continue;
            }
            object2 = stream.readInt();
            if (object2 == null) {
                return stream.createError("VLQ-encoded JS column number expected");
            }
            jsColumn += ((Integer)object2).intValue();
            if (stream.isEncodedInt()) {
                object2 = stream.readInt();
                if (object2 == null) {
                    return stream.createError("VLQ-encoded source index expected");
                }
                sourceIndex += ((Integer)object2).intValue();
                object2 = stream.readInt();
                if (object2 == null) {
                    return stream.createError("VLQ-encoded source line expected");
                }
                sourceLine += ((Integer)object2).intValue();
                object2 = stream.readInt();
                if (object2 == null) {
                    return stream.createError("VLQ-encoded source column expected");
                }
                sourceColumn += ((Integer)object2).intValue();
                if (stream.isEncodedInt()) {
                    object2 = stream.readInt();
                    if (object2 == null) {
                        return stream.createError("VLQ-encoded name index expected");
                    }
                    ((Integer)object2).intValue();
                }
                if (!(0 <= sourceIndex ? sourceIndex <= sources.size() + -1 : false)) {
                    return stream.createError("Source index " + sourceIndex + " is out of bounds " + CollectionsKt.getIndices(sources));
                }
                object2 = currentGroup;
                collection2 = ((SourceMapGroup)object2).getSegments();
                sourceMapSegment = new SourceMapSegment(jsColumn, Intrinsics.stringPlus(sourceRoot, sources.get(sourceIndex)), sourceLine, sourceColumn);
                it82 = false;
                collection2.add(sourceMapSegment);
            } else {
                object2 = currentGroup;
                collection2 = ((SourceMapGroup)object2).getSegments();
                sourceMapSegment = new SourceMapSegment(jsColumn, null, -1, -1);
                it82 = false;
                collection2.add(sourceMapSegment);
            }
            if (stream.isEof()) {
                return stream.createError("Unexpected EOF, ',' or ';' expected");
            }
            if (stream.isGroupTerminator()) {
                object2 = new SourceMapGroup();
                boolean bl17 = false;
                boolean bl18 = false;
                Object it9 = object2;
                boolean bl19 = false;
                sourceMap3 = sourceMap2;
                collection = sourceMap3.getGroups();
                bl13 = false;
                collection.add(it9);
                currentGroup = object2;
                jsColumn = 0;
            } else if (!stream.isSegmentTerminator()) {
                return stream.createError("Unexpected char, ',' or ';' expected");
            }
            stream.skipChar();
        }
        return new SourceMapSuccess(sourceMap2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\r\u0010\u001a\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser$MappingStream;", "", "string", "", "(Ljava/lang/String;)V", "isEncodedInt", "", "()Z", "isEof", "isGroupTerminator", "isSegmentTerminator", "position", "", "getPosition", "()I", "setPosition", "(I)V", "getString", "()Ljava/lang/String;", "base64value", "c", "", "(C)Ljava/lang/Integer;", "createError", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapError;", "error", "readInt", "()Ljava/lang/Integer;", "skipChar", "", "js.parser"})
    public static final class MappingStream {
        @NotNull
        private final String string;
        private int position;

        public MappingStream(@NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            this.string = string2;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean isEof() {
            return this.position == this.string.length();
        }

        public final boolean isSegmentTerminator() {
            return this.string.charAt(this.position) == ',';
        }

        public final boolean isGroupTerminator() {
            return this.string.charAt(this.position) == ';';
        }

        public final boolean isEncodedInt() {
            return !this.isEof() && !this.isSegmentTerminator() && !this.isGroupTerminator();
        }

        public final void skipChar() {
            MappingStream mappingStream = this;
            int n = mappingStream.position;
            mappingStream.position = n + 1;
        }

        @Nullable
        public final Integer readInt() {
            int value2 = 0;
            int shift = 0;
            while (true) {
                if (this.isEof()) {
                    return null;
                }
                MappingStream mappingStream = this;
                int n = mappingStream.position;
                mappingStream.position = n + 1;
                Integer n2 = this.base64value(this.string.charAt(n));
                if (n2 == null) {
                    return null;
                }
                int digit = n2;
                int digitValue = digit & 0x1F;
                value2 |= digitValue << shift;
                if ((digit & 0x20) == 0) break;
                shift += 5;
            }
            int unsignedValue = value2 >>> 1;
            return (value2 & 1) == 0 ? Integer.valueOf(unsignedValue) : Integer.valueOf(-unsignedValue);
        }

        private final Integer base64value(char c) {
            Integer n;
            block1: {
                char c2;
                block0: {
                    c2 = c;
                    boolean bl = 'A' <= c2 ? c2 <= 'Z' : false;
                    if (!bl) break block0;
                    n = c - 65;
                    break block1;
                }
                n = ('a' <= c2 ? c2 <= 'z' : false) ? Integer.valueOf(c - 97 + 26) : (('0' <= c2 ? c2 <= '9' : false) ? Integer.valueOf(c - 48 + 52) : (c2 == '+' ? Integer.valueOf(62) : (c2 == '/' ? Integer.valueOf(63) : null)));
            }
            return n;
        }

        @NotNull
        public final SourceMapError createError(@NotNull String error) {
            Intrinsics.checkNotNullParameter(error, "error");
            return new SourceMapError("Error parsing stream at offset " + this.position + ": " + error);
        }
    }
}

