/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAliasExpander;
import org.jetbrains.kotlin.types.TypeAliasExpansion;
import org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\u0018\u0000 }2\u00020\u0001:\u0003}~\u007fBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0002J:\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0002J&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00182\u0006\u0010,\u001a\u00020-H\u0002JB\u0010.\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0018\u0018\u00010/2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0018H\u0002J&\u00107\u001a\u0002082\u0006\u00101\u001a\u0002022\f\u00109\u001a\b\u0012\u0004\u0012\u0002000\u00182\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010?\u001a\u00020@2\u0006\u00101\u001a\u0002022\u0006\u0010A\u001a\u00020\u001dH\u0002J\u0010\u0010B\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0002J\u001e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010,\u001a\u00020-J(\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010E\u001a\u00020F2\u0006\u0010K\u001a\u00020L2\u0006\u0010,\u001a\u00020-2\u0006\u0010M\u001a\u00020\u0016J&\u0010N\u001a\u00020O2\u0006\u0010E\u001a\u00020F2\u0006\u0010K\u001a\u00020L2\u0006\u0010,\u001a\u00020-2\u0006\u0010M\u001a\u00020\u0016J\u000e\u0010P\u001a\u00020D2\u0006\u0010Q\u001a\u00020%J\u0016\u0010R\u001a\u0002082\u0006\u00101\u001a\u0002022\u0006\u0010G\u001a\u00020HJ\u0018\u0010S\u001a\u00020>2\u0006\u00101\u001a\u0002022\u0006\u0010G\u001a\u00020HH\u0002J&\u0010S\u001a\u00020>2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010,\u001a\u00020-2\u0006\u0010T\u001a\u00020\u0016J\u001c\u0010U\u001a\u00020V2\u0006\u00101\u001a\u0002022\n\u0010W\u001a\u0006\u0012\u0002\b\u00030XH\u0002J,\u0010Y\u001a\u0002082\u0006\u00101\u001a\u0002022\u0006\u0010Z\u001a\u00020V2\b\u0010[\u001a\u0004\u0018\u00010\\2\b\u0010(\u001a\u0004\u0018\u00010]H\u0002J0\u0010^\u001a\u0002082\u0006\u00101\u001a\u0002022\u0006\u0010Z\u001a\u00020V2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020OH\u0002J.\u0010d\u001a\u0002082\u0006\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020J2\u0006\u0010c\u001a\u00020O2\u0006\u0010a\u001a\u00020b2\u0006\u0010Z\u001a\u00020VJ0\u0010e\u001a\u0002082\u0006\u00101\u001a\u0002022\u0006\u0010Z\u001a\u00020V2\u0006\u0010$\u001a\u00020%2\u0006\u0010=\u001a\u00020b2\u0006\u0010c\u001a\u00020OH\u0002J2\u0010f\u001a\u00020>2\u0006\u00101\u001a\u0002022\u0006\u0010Z\u001a\u00020V2\u0006\u0010g\u001a\u00020\u001d2\u0006\u0010h\u001a\u00020i2\b\u0010j\u001a\u0004\u0018\u00010kH\u0002J*\u0010l\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\u0006\u00101\u001a\u0002022\u0006\u0010m\u001a\u00020;2\f\u0010n\u001a\b\u0012\u0004\u0012\u0002000\u0018J.\u0010o\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\u0006\u00101\u001a\u0002022\f\u0010n\u001a\b\u0012\u0004\u0012\u0002000\u00182\b\b\u0002\u0010p\u001a\u00020qH\u0002J\u0018\u0010r\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\u0006\u0010s\u001a\u00020>H\u0002J\u000e\u0010t\u001a\u00020\u0016*\u0004\u0018\u00010]H\u0002J\u0014\u0010u\u001a\b\u0012\u0004\u0012\u0002040\u0018*\u0004\u0018\u00010JH\u0002J\u001c\u0010v\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0018*\u00020F2\u0006\u0010w\u001a\u00020`H\u0002J\u001f\u0010x\u001a\n\u0012\u0006\b\u0001\u0012\u00020z0y*\u0006\u0012\u0002\b\u00030XH\u0000\u00a2\u0006\u0004\b{\u0010|R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001\u00b2\u0006\u000e\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "typeTransformerForTests", "Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "dynamicTypesSettings", "Lorg/jetbrains/kotlin/types/DynamicTypesSettings;", "dynamicCallableDescriptors", "Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "platformToKotlinClassMapper", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;Lorg/jetbrains/kotlin/types/DynamicTypesSettings;Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isNonParenthesizedAnnotationsOnFunctionalTypesEnabled", "", "appendDefaultArgumentsForLocalClassifier", "", "Lorg/jetbrains/kotlin/types/TypeProjectionImpl;", "fromIndex", "", "constructorParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "buildFinalArgumentList", "Lorg/jetbrains/kotlin/types/TypeProjection;", "argumentsFromUserType", "argumentsForOuterClass", "parameters", "canBeUsedAsBareType", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkNonParenthesizedAnnotationsOnFunctionalType", "", "typeElement", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "annotationEntries", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "collectArgumentsForClassifierTypeConstructor", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "c", "Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "qualifierParts", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$ExpressionQualifierPart;", "createErrorTypeForTypeConstructor", "Lorg/jetbrains/kotlin/resolve/PossiblyBareType;", "arguments", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "forceResolveTypeContents", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getScopeForTypeParameter", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "typeParameterDescriptor", "isPossibleToSpecifyTypeArgumentsFor", "resolveAbbreviatedType", "Lorg/jetbrains/kotlin/types/SimpleType;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "isDebuggerContext", "resolveDescriptorForType", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "resolveExpandedTypeForTypeAlias", "typeAliasDescriptor", "resolvePossiblyBareType", "resolveType", "checkBounds", "resolveTypeAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "modifierListsOwner", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "resolveTypeElement", "annotations", "outerModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "resolveTypeForClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "qualifierResolutionResult", "resolveTypeForClassifier", "resolveTypeForTypeAlias", "resolveTypeForTypeParameter", "typeParameter", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "resolveTypeProjections", "constructor", "argumentElements", "resolveTypeProjectionsWithErrorConstructor", "message", "", "shouldCheckBounds", "inType", "canHaveFunctionTypeModifiers", "classifierDescriptorsFromInnerToOuter", "findImplicitOuterClassArguments", "outerClass", "getAllModifierLists", "", "Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "getAllModifierLists$frontend", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;)[Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "Companion", "TracingTypeAliasExpansionReportStrategy", "TypeTransformerForTests", "frontend", "suspendModifier", "Lcom/intellij/psi/PsiElement;"})
public final class TypeResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final TypeTransformerForTests typeTransformerForTests;
    @NotNull
    private final DynamicTypesSettings dynamicTypesSettings;
    @NotNull
    private final DynamicCallableDescriptors dynamicCallableDescriptors;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final PlatformToKotlinClassMapper platformToKotlinClassMapper;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean isNonParenthesizedAnnotationsOnFunctionalTypesEnabled;

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull TypeTransformerForTests typeTransformerForTests, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull DynamicCallableDescriptors dynamicCallableDescriptors, @NotNull IdentifierChecker identifierChecker, @NotNull PlatformToKotlinClassMapper platformToKotlinClassMapper, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(annotationResolver, "annotationResolver");
        Intrinsics.checkNotNullParameter(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(typeTransformerForTests, "typeTransformerForTests");
        Intrinsics.checkNotNullParameter(dynamicTypesSettings, "dynamicTypesSettings");
        Intrinsics.checkNotNullParameter(dynamicCallableDescriptors, "dynamicCallableDescriptors");
        Intrinsics.checkNotNullParameter(identifierChecker, "identifierChecker");
        Intrinsics.checkNotNullParameter(platformToKotlinClassMapper, "platformToKotlinClassMapper");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.typeTransformerForTests = typeTransformerForTests;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.dynamicCallableDescriptors = dynamicCallableDescriptors;
        this.identifierChecker = identifierChecker;
        this.platformToKotlinClassMapper = platformToKotlinClassMapper;
        this.languageVersionSettings = languageVersionSettings;
        this.isNonParenthesizedAnnotationsOnFunctionalTypesEnabled = this.languageVersionSettings.getFeatureSupport(LanguageFeature.NonParenthesizedAnnotationsOnFunctionalTypes) == LanguageFeature.State.ENABLED;
    }

    @NotNull
    public final KotlinType resolveType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        Intrinsics.checkNotNullParameter(trace, "trace");
        return this.resolveType(new TypeResolutionContext(scope2, trace, checkBounds, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), false), typeReference);
    }

    @NotNull
    public final SimpleType resolveAbbreviatedType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace) {
        SimpleType simpleType2;
        UnwrappedType resolvedType;
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        Intrinsics.checkNotNullParameter(trace, "trace");
        UnwrappedType unwrappedType = resolvedType = this.resolveType(new TypeResolutionContext(scope2, trace, true, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference), true), typeReference).unwrap();
        if (unwrappedType instanceof DynamicType) {
            trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), resolvedType));
            SimpleType simpleType3 = ErrorUtils.createErrorType("dynamic type in wrong context");
            Intrinsics.checkNotNullExpressionValue(simpleType3, "{\n                trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on(typeReference, resolvedType))\n                ErrorUtils.createErrorType(\"dynamic type in wrong context\")\n            }");
            simpleType2 = simpleType3;
        } else if (unwrappedType instanceof SimpleType) {
            simpleType2 = (SimpleType)resolvedType;
        } else {
            String string2 = Intrinsics.stringPlus("Unexpected type: ", resolvedType);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return simpleType2;
    }

    @NotNull
    public final SimpleType resolveExpandedTypeForTypeAlias(@NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        SimpleType expandedType2 = TypeAliasExpander.Companion.getNON_REPORTING().expandWithoutAbbreviation(typeAliasExpansion, Annotations.Companion.getEMPTY());
        return expandedType2;
    }

    private final KotlinType resolveType(TypeResolutionContext c, KtTypeReference typeReference) {
        boolean bl = !c.allowBareTypes;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Use resolvePossiblyBareType() when bare types are allowed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        KotlinType kotlinType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "resolvePossiblyBareType(c, typeReference).actualType");
        return kotlinType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        KotlinType cachedType = (KotlinType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(cachedType)");
            return possiblyBareType;
        }
        WritableSlice<KtTypeReference, KotlinType> resolvedTypeSlice = c.abbreviated ? BindingContext.ABBREVIATED_TYPE : BindingContext.TYPE;
        Annotations annotations2 = this.resolveTypeAnnotations(c, typeReference);
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations2, typeReference.getModifierList(), typeReference.getTypeElement());
        Iterator<TypeProjection> iterator2 = c.trace;
        Intrinsics.checkNotNullExpressionValue(iterator2, "c.trace");
        BindingTrace bindingTrace = iterator2;
        iterator2 = c.scope;
        Intrinsics.checkNotNullExpressionValue(iterator2, "c.scope");
        BindingContextUtilsKt.recordScope(bindingTrace, (LexicalScope)((Object)iterator2), typeReference);
        if (!type2.isBare()) {
            for (TypeProjection argument : type2.getActualType().getArguments()) {
                KotlinType kotlinType = argument.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.type");
                this.forceResolveTypeContents(kotlinType);
            }
            c.trace.record(resolvedTypeSlice, typeReference, type2.getActualType());
        }
        return type2;
    }

    @NotNull
    public final KtDeclarationModifierList[] getAllModifierLists$frontend(@NotNull KtElementImplStub<?> $this$getAllModifierLists) {
        Intrinsics.checkNotNullParameter($this$getAllModifierLists, "<this>");
        PsiElement[] psiElementArray = $this$getAllModifierLists.getStubOrPsiChildren(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getStubOrPsiChildren(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.arrayFactory)");
        return (KtDeclarationModifierList[])psiElementArray;
    }

    private final void checkNonParenthesizedAnnotationsOnFunctionalType(KtFunctionType typeElement, List<? extends KtAnnotationEntry> annotationEntries, BindingTrace trace) {
        PsiElement psiElement;
        KtAnnotationEntry lastAnnotationEntry = CollectionsKt.lastOrNull(annotationEntries);
        UserDataHolder userDataHolder = lastAnnotationEntry;
        PsiElement psiElement2 = psiElement = userDataHolder == null ? null : PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)userDataHolder, false, 1, null);
        boolean isAnnotationsGroupedUsingBrackets = Intrinsics.areEqual(psiElement == null ? null : ((userDataHolder = psiElement.getNode()) == null ? null : userDataHolder.getElementType()), KtTokens.RBRACKET);
        userDataHolder = lastAnnotationEntry;
        boolean hasAnnotationParentheses = (userDataHolder == null ? null : ((KtAnnotationEntry)userDataHolder).getValueArgumentList()) != null;
        boolean isFunctionalTypeStartingWithParentheses = typeElement.getFirstChild() instanceof KtParameterList;
        PsiElement psiElement3 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default(typeElement, false, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        PsiElement $this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u2d1 = psiElement3;
        boolean bl3 = false;
        boolean hasSuspendModifierBeforeParentheses = $this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u2d1 instanceof KtDeclarationModifierList && PsiUtilsKt.hasSuspendModifier((KtModifierList)$this$checkNonParenthesizedAnnotationsOnFunctionalType_u24lambda_u2d1);
        if (lastAnnotationEntry != null && isFunctionalTypeStartingWithParentheses && !hasAnnotationParentheses && !isAnnotationsGroupedUsingBrackets && !hasSuspendModifierBeforeParentheses) {
            trace.report(Errors.NON_PARENTHESIZED_ANNOTATIONS_ON_FUNCTIONAL_TYPES.on(lastAnnotationEntry));
        }
    }

    private final Annotations resolveTypeAnnotations(TypeResolutionContext c, KtElementImplStub<?> modifierListsOwner) {
        KtDeclarationModifierList[] modifierLists = this.getAllModifierLists$frontend(modifierListsOwner);
        Annotations result2 = Annotations.Companion.getEMPTY();
        boolean isSplitModifierList = false;
        if (!this.isNonParenthesizedAnnotationsOnFunctionalTypesEnabled) {
            List<KtAnnotationEntry> annotationEntries;
            KtModifierList ktModifierList;
            KtElementImplStub<?> ktElementImplStub = modifierListsOwner;
            KtTypeElement targetType = ktElementImplStub instanceof KtNullableType ? ((KtNullableType)modifierListsOwner).getInnerType() : (ktElementImplStub instanceof KtTypeReference ? ((KtTypeReference)modifierListsOwner).getTypeElement() : null);
            KtElementImplStub<?> ktElementImplStub2 = modifierListsOwner;
            Object object = ktElementImplStub2 instanceof KtNullableType ? ((ktModifierList = ((KtNullableType)modifierListsOwner).getModifierList()) == null ? null : ktModifierList.getAnnotationEntries()) : (annotationEntries = ktElementImplStub2 instanceof KtTypeReference ? ((KtTypeReference)modifierListsOwner).getAnnotationEntries() : null);
            if (targetType instanceof KtFunctionType && ((KtFunctionType)targetType).getStub() == null && annotationEntries != null) {
                KtFunctionType ktFunctionType = (KtFunctionType)targetType;
                ktElementImplStub2 = c.trace;
                Intrinsics.checkNotNullExpressionValue(ktElementImplStub2, "c.trace");
                this.checkNonParenthesizedAnnotationsOnFunctionalType(ktFunctionType, annotationEntries, (BindingTrace)((Object)ktElementImplStub2));
            }
        }
        KtDeclarationModifierList[] ktDeclarationModifierListArray = modifierLists;
        int n = 0;
        int n2 = ktDeclarationModifierListArray.length;
        while (n < n2) {
            KtDeclarationModifierList modifierList2 = ktDeclarationModifierListArray[n];
            ++n;
            if (isSplitModifierList) {
                c.trace.report(Errors.MODIFIER_LIST_NOT_ALLOWED.on((KtModifierList)((PsiElement)modifierList2)));
            }
            Object object = c.scope;
            Intrinsics.checkNotNullExpressionValue(object, "c.scope");
            LexicalScope lexicalScope = object;
            object = modifierList2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(object, "modifierList.annotationEntries");
            Object object2 = object;
            object = c.trace;
            Intrinsics.checkNotNullExpressionValue(object, "c.trace");
            Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(lexicalScope, (List<KtAnnotationEntry>)object2, (BindingTrace)object);
            result2 = AnnotationsKt.composeAnnotations(result2, annotations2);
            isSplitModifierList = true;
        }
        return result2;
    }

    private final void forceResolveTypeContents(KotlinType type2) {
        type2.getAnnotations();
        if (FlexibleTypesKt.isFlexible(type2)) {
            this.forceResolveTypeContents(FlexibleTypesKt.asFlexibleType(type2).getLowerBound());
            this.forceResolveTypeContents(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
        } else {
            type2.getConstructor();
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "projection.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
    }

    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, KtModifierList outerModifierList, KtTypeElement typeElement) {
        Object object;
        Object object2;
        boolean bl;
        Ref.ObjectRef<PossiblyBareType> result2 = new Ref.ObjectRef<PossiblyBareType>();
        KtModifierList ktModifierList = outerModifierList;
        boolean hasSuspendModifier = ktModifierList == null ? false : (bl = ktModifierList.hasModifier(KtTokens.SUSPEND_KEYWORD));
        Lazy suspendModifier$delegate = LazyKt.lazy((Function0)new Function0<PsiElement>(outerModifierList){
            final /* synthetic */ KtModifierList $outerModifierList;
            {
                this.$outerModifierList = $outerModifierList;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                KtModifierList ktModifierList = this.$outerModifierList;
                return ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD);
            }
        });
        if (hasSuspendModifier && !this.canHaveFunctionTypeModifiers(typeElement)) {
            BindingTrace bindingTrace = c.trace;
            PsiElement psiElement = TypeResolver.resolveTypeElement$lambda-2(suspendModifier$delegate);
            Intrinsics.checkNotNull(psiElement);
            bindingTrace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement, KtTokens.SUSPEND_KEYWORD, "non-functional type"));
        } else if (hasSuspendModifier) {
            Object object3 = c.trace;
            Intrinsics.checkNotNullExpressionValue(object3, "c.trace");
            DiagnosticSink diagnosticSink = (DiagnosticSink)object3;
            object2 = TypeResolver.resolveTypeElement$lambda-2(suspendModifier$delegate);
            Intrinsics.checkNotNull(object2);
            object3 = object2;
            CoroutineCallCheckerKt.checkCoroutinesFeature(this.languageVersionSettings, diagnosticSink, (PsiElement)object3);
        }
        Object object4 = typeElement;
        if (object4 != null) {
            object4.accept(new KtVisitorVoid(this, c, result2, annotations2, outerModifierList, hasSuspendModifier){
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ Ref.ObjectRef<PossiblyBareType> $result;
                final /* synthetic */ Annotations $annotations;
                final /* synthetic */ KtModifierList $outerModifierList;
                final /* synthetic */ boolean $hasSuspendModifier;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    this.$result = $result;
                    this.$annotations = $annotations;
                    this.$outerModifierList = $outerModifierList;
                    this.$hasSuspendModifier = $hasSuspendModifier;
                }

                public void visitUserType(@NotNull KtUserType type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    Object object = this.$c.scope;
                    Intrinsics.checkNotNullExpressionValue(object, "c.scope");
                    LexicalScope lexicalScope = object;
                    object = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue(object, "c.trace");
                    QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult = this.this$0.resolveDescriptorForType(lexicalScope, type2, (BindingTrace)object, this.$c.isDebuggerContext);
                    ClassifierDescriptor classifier2 = qualifierResolutionResult.getClassifierDescriptor();
                    if (classifier2 == null) {
                        List<TypeProjection> arguments2 = this.this$0.resolveTypeProjections(this.$c, ErrorUtils.createErrorType("No type").getConstructor(), qualifierResolutionResult.getAllProjections());
                        this.$result.element = PossiblyBareType.type(ErrorUtils.createUnresolvedType(DebugTextUtilKt.getDebugText(type2), arguments2));
                        return;
                    }
                    KtSimpleNameExpression ktSimpleNameExpression = type2.getReferenceExpression();
                    if (ktSimpleNameExpression == null) {
                        return;
                    }
                    Object object2 = ktSimpleNameExpression;
                    KtSimpleNameExpression referenceExpression = object2;
                    object2 = this.$c.trace;
                    Intrinsics.checkNotNullExpressionValue(object2, "c.trace");
                    ReservedCheckingKt.checkReservedYield(referenceExpression, (DiagnosticSink)object2);
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifier2);
                    this.$result.element = this.this$0.resolveTypeForClassifier(this.$c, classifier2, qualifierResolutionResult, type2, this.$annotations);
                }

                public void visitNullableType(@NotNull KtNullableType nullableType) {
                    KtTypeElement innerType;
                    KtModifierList ktModifierList;
                    Annotations innerAnnotations;
                    PossiblyBareType baseType;
                    Intrinsics.checkNotNullParameter(nullableType, "nullableType");
                    KtModifierList innerModifierList = nullableType.getModifierList();
                    if (innerModifierList != null && this.$outerModifierList != null) {
                        this.$c.trace.report(Errors.MODIFIER_LIST_NOT_ALLOWED.on((KtModifierList)((PsiElement)innerModifierList)));
                    }
                    if ((baseType = TypeResolver.access$resolveTypeElement(this.this$0, this.$c, innerAnnotations = AnnotationsKt.composeAnnotations(this.$annotations, TypeResolver.access$resolveTypeAnnotations(this.this$0, this.$c, nullableType)), (ktModifierList = this.$outerModifierList) == null ? innerModifierList : ktModifierList, innerType = nullableType.getInnerType())).isNullable() || innerType instanceof KtNullableType || innerType instanceof KtDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    this.$result.element = baseType.makeNullable();
                }

                public void visitFunctionType(@NotNull KtFunctionType type2) {
                    Object object;
                    Object object2;
                    VariableDescriptor it;
                    Collection<KotlinType> collection;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    KotlinType kotlinType;
                    Object object3;
                    KotlinType kotlinType2;
                    Intrinsics.checkNotNullParameter(type2, "type");
                    KtTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    if (receiverTypeRef == null) {
                        kotlinType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue(typeResolutionContext, "c.noBareTypes()");
                        kotlinType2 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    KotlinType receiverType = kotlinType2;
                    List<KtParameter> list2 = type2.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, "type.parameters");
                    List<VariableDescriptor> parameterDescriptors = this.resolveParametersOfFunctionType(list2);
                    this.checkParametersOfFunctionType(parameterDescriptors);
                    KtTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        object3 = this.$c.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue(object3, "c.noBareTypes()");
                        kotlinType = TypeResolver.access$resolveType(this.this$0, (TypeResolutionContext)object3, returnTypeRef);
                    } else {
                        object3 = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType();
                        Intrinsics.checkNotNullExpressionValue(object3, "moduleDescriptor.builtIns.unitType");
                        kotlinType = (KotlinType)object3;
                    }
                    KotlinType returnType2 = kotlinType;
                    KtParameterList parameterList = type2.getParameterList();
                    Object object4 = parameterList;
                    if ((object4 == null ? null : (KotlinPlaceHolderStub)((StubBasedPsiElementBase)object4).getStub()) == null) {
                        object4 = parameterList;
                        PsiElement psiElement = object4 == null ? null : ((KtParameterList)object4).getTrailingComma();
                        object4 = this.$c.trace;
                        Intrinsics.checkNotNullExpressionValue(object4, "c.trace");
                        TrailingCommaChecker.INSTANCE.check(psiElement, (BindingTrace)object4, TypeResolver.access$getLanguageVersionSettings$p(this.this$0));
                    }
                    object4 = parameterDescriptors;
                    KotlinType kotlinType3 = receiverType;
                    Annotations annotations2 = this.$annotations;
                    KotlinBuiltIns kotlinBuiltIns = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns();
                    Ref.ObjectRef<PossiblyBareType> objectRef = this.$result;
                    boolean $i$f$map = false;
                    void var10_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        VariableDescriptor variableDescriptor = (VariableDescriptor)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getType();
                        Intrinsics.checkNotNullExpressionValue(object2, "it.type");
                        object = object2;
                        collection.add((KotlinType)object);
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = parameterDescriptors;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (VariableDescriptor)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getName();
                        Intrinsics.checkNotNullExpressionValue(object2, "it.name");
                        Object object5 = object2;
                        object.add(object5);
                    }
                    object = (List)destination$iv$iv;
                    objectRef.element = PossiblyBareType.type(FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType3, collection, (List<Name>)object, returnType2, this.$hasSuspendModifier));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParametersOfFunctionType(List<? extends VariableDescriptor> parameterDescriptors) {
                    Object list$iv$iv;
                    void $this$groupByTo$iv$iv;
                    VariableDescriptor it;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = parameterDescriptors;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (VariableDescriptor)element$iv$iv;
                        boolean bl = false;
                        if (!(!it.getName().isSpecial())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$groupBy$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$filterTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    Iterator<T> iterator2 = $this$groupByTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object object;
                        T element$iv$iv;
                        element$iv$iv = iterator2.next();
                        it = (VariableDescriptor)element$iv$iv;
                        boolean bl = false;
                        Name key$iv$iv = it.getName();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Object parametersByName = destination$iv$iv;
                    for (List parametersGroup : parametersByName.values()) {
                        if (parametersGroup.size() < 2) continue;
                        for (VariableDescriptor parameter : parametersGroup) {
                            Object object;
                            list$iv$iv = parameter.getSource();
                            Intrinsics.checkNotNullExpressionValue(list$iv$iv, "parameter.source");
                            PsiElement psiElement = KotlinSourceElementKt.getPsi((SourceElement)list$iv$iv);
                            if (psiElement == null) {
                                object = null;
                            } else {
                                PsiElement $this$safeAs$iv = psiElement;
                                boolean $i$f$safeAs = false;
                                PsiElement psiElement2 = $this$safeAs$iv;
                                if (!(psiElement2 instanceof KtParameter)) {
                                    psiElement2 = null;
                                }
                                object = iterator2 = (KtParameter)psiElement2;
                            }
                            if (iterator2 == null) continue;
                            Iterator<T> ktParameter = iterator2;
                            this.$c.trace.report(Errors.DUPLICATE_PARAMETER_NAME_IN_FUNCTION_TYPE.on((KtParameter)((PsiElement)((Object)ktParameter))));
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final List<VariableDescriptor> resolveParametersOfFunctionType(List<? extends KtParameter> parameters2) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $this$forEach$iv;
                    Iterable iterable = parameters2;
                    TypeResolver typeResolver = this.this$0;
                    TypeResolutionContext typeResolutionContext = this.$c;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl = false;
                        IdentifierChecker identifierChecker = TypeResolver.access$getIdentifierChecker$p(typeResolver);
                        KtDeclaration ktDeclaration = it;
                        BindingTrace bindingTrace = typeResolutionContext.trace;
                        Intrinsics.checkNotNullExpressionValue(bindingTrace, "c.trace");
                        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
                        this.checkParameterInFunctionType(it);
                    }
                    $this$forEach$iv = parameters2;
                    typeResolver = this.this$0;
                    typeResolutionContext = this.$c;
                    boolean $i$f$map = false;
                    Iterator<T> iterator2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void parameter;
                        KtParameter ktParameter = (KtParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Object object = typeResolutionContext.noBareTypes();
                        Intrinsics.checkNotNullExpressionValue(object, "c.noBareTypes()");
                        TypeResolutionContext typeResolutionContext2 = object;
                        Object object2 = parameter.getTypeReference();
                        Intrinsics.checkNotNull(object2);
                        object = object2;
                        KotlinType parameterType = TypeResolver.access$resolveType(typeResolver, typeResolutionContext2, (KtTypeReference)object);
                        DeclarationDescriptor declarationDescriptor = typeResolutionContext.scope.getOwnerDescriptor();
                        AnnotationResolver annotationResolver = TypeResolver.access$getAnnotationResolver$p(typeResolver);
                        object2 = typeResolutionContext.scope;
                        Intrinsics.checkNotNullExpressionValue(object2, "c.scope");
                        Object object3 = object2;
                        KtModifierList ktModifierList = parameter.getModifierList();
                        object2 = typeResolutionContext.trace;
                        Intrinsics.checkNotNullExpressionValue(object2, "c.trace");
                        Annotations annotations2 = annotationResolver.resolveAnnotationsWithoutArguments((LexicalScope)object3, ktModifierList, (BindingTrace)object2);
                        object2 = parameter.getNameAsSafeName();
                        Intrinsics.checkNotNullExpressionValue(object2, "parameter.nameAsSafeName");
                        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000S\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ5\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"org/jetbrains/kotlin/resolve/TypeResolver$resolveTypeElement$1$resolveParametersOfFunctionType$ParameterOfFunctionTypeDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorImpl;", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "name", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/SourceElement;)V", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getCompileTimeInitializer", "", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "isLateInit", "", "isVar", "substitute", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "frontend"})
                        public final class ParameterOfFunctionTypeDescriptor
                        extends VariableDescriptorImpl {
                            public ParameterOfFunctionTypeDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @NotNull KotlinType type2, @NotNull SourceElement source) {
                                Intrinsics.checkNotNullParameter(containingDeclaration, "containingDeclaration");
                                Intrinsics.checkNotNullParameter(annotations2, "annotations");
                                Intrinsics.checkNotNullParameter(name, "name");
                                Intrinsics.checkNotNullParameter(type2, "type");
                                Intrinsics.checkNotNullParameter(source, "source");
                                super(containingDeclaration, annotations2, name, type2, source);
                            }

                            @NotNull
                            public DescriptorVisibility getVisibility() {
                                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
                                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "LOCAL");
                                return descriptorVisibility;
                            }

                            @Nullable
                            public VariableDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
                                Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
                                throw new UnsupportedOperationException(Intrinsics.stringPlus("Should not be called for descriptor of type ", this.getClass()));
                            }

                            public boolean isVar() {
                                return false;
                            }

                            public boolean isLateInit() {
                                return false;
                            }

                            @Nullable
                            public Void getCompileTimeInitializer() {
                                return null;
                            }

                            public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
                                Intrinsics.checkNotNullParameter(visitor2, "visitor");
                                return visitor2.visitVariableDescriptor(this, data2);
                            }
                        }
                        ParameterOfFunctionTypeDescriptor descriptor2 = new ParameterOfFunctionTypeDescriptor(declarationDescriptor, annotations2, (Name)object2, parameterType, KotlinSourceElementKt.toSourceElement((KtPureElement)parameter));
                        typeResolutionContext.trace.record(BindingContext.VALUE_PARAMETER, parameter, descriptor2);
                        ParameterOfFunctionTypeDescriptor parameterOfFunctionTypeDescriptor = descriptor2;
                        collection.add(parameterOfFunctionTypeDescriptor);
                    }
                    return (List)destination$iv$iv;
                }

                public void visitDynamicType(@NotNull KtDynamicType type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getDynamicCallableDescriptors$p(this.this$0).getDynamicType().replaceAnnotations(this.$annotations));
                    if (!TypeResolver.access$getDynamicTypesSettings$p(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(@NotNull KtSelfType type2) {
                    Intrinsics.checkNotNullParameter(type2, "type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Self-types are not supported"));
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParameterInFunctionType(KtParameter param) {
                    PsiElement psiElement;
                    PsiElement it;
                    Object object;
                    KtModifierList modifierList2;
                    if (param.hasDefaultValue()) {
                        BindingTrace bindingTrace = this.$c.trace;
                        KtExpression ktExpression = param.getDefaultValue();
                        Intrinsics.checkNotNull(ktExpression);
                        bindingTrace.report(Errors.UNSUPPORTED.on(ktExpression, "default value of parameter in function type"));
                    }
                    if (param.getName() != null) {
                        for (KtAnnotationEntry psiElement2 : param.getAnnotationEntries()) {
                            this.$c.trace.report(Errors.UNSUPPORTED.on(psiElement2, "annotation on parameter in function type"));
                        }
                    }
                    if ((modifierList2 = param.getModifierList()) != null) {
                        void $this$mapNotNullTo$iv$iv;
                        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
                        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordTokenArray, "MODIFIER_KEYWORDS_ARRAY");
                        Object[] objectArray = ktModifierKeywordTokenArray;
                        boolean $i$f$mapNotNull = false;
                        Object[] objectArray2 = objectArray;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        void var10_20 = $this$forEach$iv$iv$iv;
                        int n = ((void)var10_20).length;
                        for (int i = 0; i < n; ++i) {
                            PsiElement psiElement3;
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = var10_20[i];
                            boolean bl = false;
                            KtModifierKeywordToken it2 = (KtModifierKeywordToken)element$iv$iv;
                            boolean bl2 = false;
                            if (modifierList2.getModifier(it2) == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            PsiElement it$iv$iv = psiElement3;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Iterable iterable = (List)destination$iv$iv;
                        object = this.$c;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv : iterable) {
                            it = (PsiElement)element$iv;
                            boolean bl = false;
                            ((TypeResolutionContext)object).trace.report(Errors.UNSUPPORTED.on(it, "modifier on parameter in function type"));
                        }
                    }
                    if ((psiElement = param.getValOrVarKeyword()) != null) {
                        object = psiElement;
                        TypeResolutionContext typeResolutionContext = this.$c;
                        boolean bl = false;
                        boolean bl5 = false;
                        it = object;
                        boolean bl7 = false;
                        typeResolutionContext.trace.report(Errors.UNSUPPORTED.on(it, "val or val on parameter in function type"));
                    }
                }
            });
        }
        object4 = (PossiblyBareType)result2.element;
        if (object4 == null) {
            String string2;
            KtTypeElement ktTypeElement = typeElement;
            object2 = PossiblyBareType.type(ErrorUtils.createErrorType(ktTypeElement == null ? "No type element" : ((string2 = DebugTextUtilKt.getDebugText(ktTypeElement)) == null ? "No type element" : string2)));
            Intrinsics.checkNotNullExpressionValue(object2, "type(ErrorUtils.createErrorType(typeElement?.getDebugText() ?: \"No type element\"))");
            object = object2;
        } else {
            object = object4;
        }
        return object;
    }

    private final boolean canHaveFunctionTypeModifiers(KtTypeElement $this$canHaveFunctionTypeModifiers) {
        return $this$canHaveFunctionTypeModifiers instanceof KtFunctionType;
    }

    private final KotlinType resolveTypeForTypeParameter(TypeResolutionContext c, Annotations annotations2, TypeParameterDescriptor typeParameter, KtSimpleNameExpression referenceExpression, KtTypeArgumentList typeArgumentList) {
        KotlinType kotlinType;
        MemberScope scopeForTypeParameter = this.getScopeForTypeParameter(c, typeParameter);
        if (typeArgumentList != null) {
            TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
            List<KtTypeProjection> list2 = typeArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "typeArgumentList.arguments");
            this.resolveTypeProjections(c, typeConstructor2, list2);
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)typeArgumentList), "for type parameters"));
        }
        Object object = typeParameter.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(object, "typeParameter.containingDeclaration");
        DeclarationDescriptor containing = object;
        if (containing instanceof ClassDescriptor) {
            DescriptorResolver.checkHasOuterClassInstance(c.scope, c.trace, referenceExpression, (ClassDescriptor)containing);
        }
        if (scopeForTypeParameter instanceof ErrorUtils.ErrorScope) {
            object = ErrorUtils.createErrorType("?");
            Intrinsics.checkNotNullExpressionValue(object, "createErrorType(\"?\")");
            kotlinType = (KotlinType)object;
        } else {
            object = typeParameter.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(object, "typeParameter.typeConstructor");
            boolean bl = false;
            kotlinType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, (TypeConstructor)object, CollectionsKt.emptyList(), false, scopeForTypeParameter);
        }
        return kotlinType;
    }

    private final MemberScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        return c.checkBounds ? TypeIntersector.getUpperBoundsAsType(typeParameterDescriptor).getMemberScope() : (MemberScope)new LazyScopeAdapter(null, new Function0<MemberScope>(typeParameterDescriptor){
            final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;
            {
                this.$typeParameterDescriptor = $typeParameterDescriptor;
                super(0);
            }

            @NotNull
            public final MemberScope invoke() {
                return TypeIntersector.getUpperBoundsAsType(this.$typeParameterDescriptor).getMemberScope();
            }
        }, 1, null);
    }

    @NotNull
    public final PossiblyBareType resolveTypeForClassifier(@NotNull TypeResolutionContext c, @NotNull ClassifierDescriptor descriptor2, @NotNull QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult, @NotNull KtElement element, @NotNull Annotations annotations2) {
        PossiblyBareType possiblyBareType;
        Object object;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(qualifierResolutionResult, "qualifierResolutionResult");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        List<QualifiedExpressionResolver.ExpressionQualifierPart> qualifierParts = qualifierResolutionResult.getQualifierParts();
        if (element instanceof KtUserType && ((KtUserType)element).getStub() == null) {
            object = ((KtUserType)element).getTypeArgumentList();
            PsiElement psiElement = object == null ? null : ((KtTypeArgumentList)object).getTrailingComma();
            object = c.trace;
            Intrinsics.checkNotNullExpressionValue(object, "c.trace");
            TrailingCommaChecker.INSTANCE.check(psiElement, (BindingTrace)object, this.languageVersionSettings);
        }
        if ((object = descriptor2) instanceof TypeParameterDescriptor) {
            boolean bl = qualifierParts.size() == 1;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Type parameter can be resolved only by it's short name, but '" + element.getText() + "' is contradiction with " + qualifierParts.size() + " qualifier parts";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            QualifiedExpressionResolver.ExpressionQualifierPart qualifierPart = CollectionsKt.single(qualifierParts);
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(this.resolveTypeForTypeParameter(c, annotations2, (TypeParameterDescriptor)descriptor2, qualifierPart.getExpression(), qualifierPart.getTypeArguments()));
            Intrinsics.checkNotNullExpressionValue(possiblyBareType2, "{\n                assert(qualifierParts.size == 1) {\n                    \"Type parameter can be resolved only by it's short name, but '${element.text}' is contradiction \" +\n                            \"with ${qualifierParts.size} qualifier parts\"\n                }\n\n                val qualifierPart = qualifierParts.single()\n                type(resolveTypeForTypeParameter(c, annotations, descriptor, qualifierPart.expression, qualifierPart.typeArguments))\n            }");
            possiblyBareType = possiblyBareType2;
        } else if (object instanceof ClassDescriptor) {
            possiblyBareType = this.resolveTypeForClass(c, annotations2, (ClassDescriptor)descriptor2, element, qualifierResolutionResult);
        } else if (object instanceof TypeAliasDescriptor) {
            possiblyBareType = this.resolveTypeForTypeAlias(c, annotations2, (TypeAliasDescriptor)descriptor2, element, qualifierResolutionResult);
        } else {
            String string3 = Intrinsics.stringPlus("Unexpected classifier type: ", descriptor2.getClass());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return possiblyBareType;
    }

    private final PossiblyBareType resolveTypeForClass(TypeResolutionContext c, Annotations annotations2, ClassDescriptor classDescriptor2, KtElement element, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        TypeConstructor typeConstructor2 = classDescriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "classDescriptor.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair = typeConstructor3.getParameters();
        Intrinsics.checkNotNullExpressionValue(pair, "typeConstructor.parameters");
        List<TypeParameterDescriptor> parameters2 = pair;
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor2)) {
            pair = PossiblyBareType.bare(typeConstructor3, false);
            Intrinsics.checkNotNullExpressionValue(pair, "bare(typeConstructor, false)");
            return pair;
        }
        if (ErrorUtils.isError(classDescriptor2)) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair2 = this.collectArgumentsForClassifierTypeConstructor(c, classDescriptor2, qualifierResolutionResult.getQualifierParts());
        if (pair2 == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        pair = pair2;
        List<KtTypeProjection> collectedArgumentAsTypeProjections = pair.component1();
        List<TypeProjection> argumentsForOuterClass = pair.component2();
        boolean bl = collectedArgumentAsTypeProjections.size() <= parameters2.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TypeResolver$resolveTypeForClass$32 = false;
            String $i$a$-assert-TypeResolver$resolveTypeForClass$32 = "Collected arguments count should be not greater then parameters count, but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + element.getText();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypeResolver$resolveTypeForClass$32));
        }
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, collectedArgumentAsTypeProjections);
        List<TypeProjection> arguments2 = this.buildFinalArgumentList(argumentsFromUserType, argumentsForOuterClass, parameters2);
        boolean $i$a$-assert-TypeResolver$resolveTypeForClass$32 = arguments2.size() == parameters2.size();
        boolean bl3 = false;
        if (_Assertions.ENABLED && !$i$a$-assert-TypeResolver$resolveTypeForClass$32) {
            boolean bl4 = false;
            String string2 = "Collected arguments count should be equal to parameters count, but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + element.getText();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        SimpleType resultingType = KotlinTypeFactory.simpleNotNullType(annotations2, classDescriptor2, arguments2);
        Object object = this.typeTransformerForTests.transformType(resultingType);
        if (object != null) {
            KotlinType kotlinType = object;
            boolean bl5 = false;
            boolean bl6 = false;
            KotlinType it = kotlinType;
            boolean bl7 = false;
            PossiblyBareType possiblyBareType = PossiblyBareType.type(it);
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(it)");
            return possiblyBareType;
        }
        if (this.shouldCheckBounds(c, resultingType)) {
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(resultingType);
            Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(resultingType)");
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            int n = 0;
            int n2 = parameters2.size() + -1;
            if (n <= n2) {
                do {
                    KtTypeReference typeReference;
                    int i = n++;
                    TypeParameterDescriptor parameter = parameters2.get(i);
                    KotlinType kotlinType = arguments2.get(i).getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "arguments[i].type");
                    KotlinType argument = kotlinType;
                    KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(collectedArgumentAsTypeProjections, i);
                    KtTypeReference ktTypeReference = typeReference = ktTypeProjection == null ? null : ktTypeProjection.getTypeReference();
                    if (typeReference == null) continue;
                    DescriptorResolver.checkBounds(typeReference, argument, parameter, substitutor2, c.trace);
                } while (n <= n2);
            }
        }
        if (TypeUtilsKt.isArrayOfNothing(resultingType)) {
            c.trace.report(Errors.UNSUPPORTED.on(element, "Array<Nothing> is illegal"));
        }
        object = PossiblyBareType.type(resultingType);
        Intrinsics.checkNotNullExpressionValue(object, "type(resultingType)");
        return object;
    }

    private final List<TypeProjection> buildFinalArgumentList(List<? extends TypeProjection> argumentsFromUserType, List<? extends TypeProjection> argumentsForOuterClass, List<? extends TypeParameterDescriptor> parameters2) {
        List<? extends TypeProjection> list2 = argumentsForOuterClass;
        return CollectionsKt.plus((Collection)argumentsFromUserType, (Iterable)(list2 == null ? this.appendDefaultArgumentsForLocalClassifier(argumentsFromUserType.size(), parameters2) : list2));
    }

    private final boolean shouldCheckBounds(TypeResolutionContext c, KotlinType inType) {
        if (!c.checkBounds) {
            return false;
        }
        if (TypeUtilsKt.containsTypeAliasParameters(inType)) {
            return false;
        }
        return !c.abbreviated || !TypeUtilsKt.containsTypeAliases(inType);
    }

    private final PossiblyBareType resolveTypeForTypeAlias(TypeResolutionContext c, Annotations annotations2, TypeAliasDescriptor descriptor2, KtElement type2, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        Object object;
        ClassDescriptor classDescriptor2;
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "descriptor.typeConstructor");
        TypeConstructor typeConstructor3 = typeConstructor2;
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        if (ErrorUtils.isError(descriptor2)) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            c.trace.report(Errors.UNSUPPORTED_FEATURE.on(type2, TuplesKt.to(LanguageFeature.TypeAliases, this.languageVersionSettings)));
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        List<TypeParameterDescriptor> list2 = typeConstructor3.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "typeConstructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list2;
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(descriptor2) && (classDescriptor2 = descriptor2.getClassDescriptor()) != null && this.canBeUsedAsBareType(descriptor2)) {
            ClassDescriptor classDescriptor3 = descriptor2.getClassDescriptor();
            Intrinsics.checkNotNull(classDescriptor3);
            PossiblyBareType possiblyBareType = PossiblyBareType.bare(classDescriptor3.getTypeConstructor(), TypeUtils.isNullableType(descriptor2.getExpandedType()));
            Intrinsics.checkNotNullExpressionValue(possiblyBareType, "bare(descriptor.classDescriptor!!.typeConstructor, TypeUtils.isNullableType(descriptor.expandedType))");
            return possiblyBareType;
        }
        Object object2 = CollectionsKt.lastOrNull(qualifierResolutionResult.getQualifierParts());
        if (object2 == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        QualifiedExpressionResolver.ExpressionQualifierPart typeAliasQualifierPart = object2;
        Pair<List<KtTypeProjection>, List<TypeProjection>> pair = this.collectArgumentsForClassifierTypeConstructor(c, descriptor2, qualifierResolutionResult.getQualifierParts());
        if (pair == null) {
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        object2 = pair;
        List argumentElementsFromUserType = (List)((Pair)object2).component1();
        List argumentsForOuterClass = (List)((Pair)object2).component2();
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, argumentElementsFromUserType);
        List<TypeProjection> arguments2 = this.buildFinalArgumentList(argumentsFromUserType, argumentsForOuterClass, parameters2);
        Object object3 = c.trace;
        Intrinsics.checkNotNullExpressionValue(object3, "c.trace");
        BindingTrace bindingTrace = object3;
        object3 = typeAliasQualifierPart.getTypeArguments();
        KtElement ktElement = object3 == null ? (KtElement)typeAliasQualifierPart.getExpression() : (KtElement)object3;
        object3 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(object3, "descriptor.declaredTypeParameters");
        TracingTypeAliasExpansionReportStrategy reportStrategy = new TracingTypeAliasExpansionReportStrategy(bindingTrace, type2, ktElement, descriptor2, (List<? extends TypeParameterDescriptor>)object3, argumentElementsFromUserType);
        if (parameters2.size() != arguments2.size()) {
            reportStrategy.wrongNumberOfTypeArguments(descriptor2, parameters2.size());
            return this.createErrorTypeForTypeConstructor(c, projectionFromAllQualifierParts, typeConstructor3);
        }
        if (c.abbreviated) {
            TypeConstructor typeConstructor4 = descriptor2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor4, "descriptor.typeConstructor");
            SimpleType abbreviatedType = KotlinTypeFactory.simpleType$default(annotations2, typeConstructor4, arguments2, false, null, 16, null);
            object3 = PossiblyBareType.type(abbreviatedType);
            Intrinsics.checkNotNullExpressionValue(object3, "{\n            val abbreviatedType = KotlinTypeFactory.simpleType(annotations, descriptor.typeConstructor, arguments, false)\n            type(abbreviatedType)\n        }");
            object = object3;
        } else {
            TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.create(null, descriptor2, arguments2);
            SimpleType expandedType2 = new TypeAliasExpander(reportStrategy, c.checkBounds).expand(typeAliasExpansion, annotations2);
            object3 = PossiblyBareType.type(expandedType2);
            Intrinsics.checkNotNullExpressionValue(object3, "{\n            val typeAliasExpansion = TypeAliasExpansion.create(null, descriptor, arguments)\n            val expandedType = TypeAliasExpander(reportStrategy, c.checkBounds).expand(typeAliasExpansion, annotations)\n            type(expandedType)\n        }");
            object = object3;
        }
        return object;
    }

    private final boolean canBeUsedAsBareType(TypeAliasDescriptor descriptor2) {
        SimpleType expandedType2 = descriptor2.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return false;
        }
        ClassDescriptor classDescriptor2 = descriptor2.getClassDescriptor();
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        if (!this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor3)) {
            return false;
        }
        boolean bl = false;
        LinkedHashSet<TypeParameterDescriptor> usedTypeParameters = new LinkedHashSet<TypeParameterDescriptor>();
        for (TypeProjection argument : expandedType2.getArguments()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (argument.isStarProjection()) continue;
            if (argument.getProjectionKind() != Variance.INVARIANT) {
                return false;
            }
            ClassifierDescriptor classifierDescriptor = argument.getType().getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
            if (typeParameterDescriptor == null) {
                return false;
            }
            TypeParameterDescriptor argumentTypeDescriptor = typeParameterDescriptor;
            if (!Intrinsics.areEqual(argumentTypeDescriptor.getContainingDeclaration(), descriptor2)) {
                return false;
            }
            if (usedTypeParameters.contains(argumentTypeDescriptor)) {
                return false;
            }
            usedTypeParameters.add(argumentTypeDescriptor);
        }
        return true;
    }

    private final PossiblyBareType createErrorTypeForTypeConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> arguments2, TypeConstructor typeConstructor2) {
        Name name;
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        String string2 = classifierDescriptor == null ? null : ((name = classifierDescriptor.getName()) == null ? null : name.asString());
        PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(string2 == null ? typeConstructor2.toString() : string2, TypeResolver.resolveTypeProjectionsWithErrorConstructor$default(this, c, arguments2, null, 4, null)));
        Intrinsics.checkNotNullExpressionValue(possiblyBareType, "type(\n            ErrorUtils.createErrorTypeWithArguments(\n                typeConstructor.declarationDescriptor?.name?.asString() ?: typeConstructor.toString(),\n                resolveTypeProjectionsWithErrorConstructor(c, arguments)\n            )\n        )");
        return possiblyBareType;
    }

    private final boolean isPossibleToSpecifyTypeArgumentsFor(ClassifierDescriptorWithTypeParameters classifierDescriptor) {
        List<TypeParameterDescriptor> list2 = classifierDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "classifierDescriptor.typeConstructor.parameters");
        TypeParameterDescriptor typeParameterDescriptor = CollectionsKt.firstOrNull(list2);
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor firstTypeParameter = typeParameterDescriptor;
        return firstTypeParameter.getOriginal().getContainingDeclaration() instanceof ClassifierDescriptorWithTypeParameters;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<KtTypeProjection>, List<TypeProjection>> collectArgumentsForClassifierTypeConstructor(TypeResolutionContext c, ClassifierDescriptorWithTypeParameters classifierDescriptor, List<QualifiedExpressionResolver.ExpressionQualifierPart> qualifierParts) {
        boolean bl;
        Object declaredTypeParameters;
        int index2;
        List<ClassifierDescriptorWithTypeParameters> classifierDescriptorChain = this.classifierDescriptorsFromInnerToOuter(classifierDescriptor);
        List<QualifiedExpressionResolver.ExpressionQualifierPart> reversedQualifierParts = CollectionsKt.asReversed(qualifierParts);
        boolean wasStatic = false;
        SmartList result2 = new SmartList();
        int n = classifierDescriptorChain.size();
        int n2 = reversedQualifierParts.size();
        boolean bl2 = false;
        n = 0;
        int classifierChainLastIndex = Math.min(n, n2) - 1;
        if (n <= classifierChainLastIndex) {
            do {
                Object object;
                List<Object> currentParameters;
                QualifiedExpressionResolver.ExpressionQualifierPart qualifierPart2;
                List list2;
                list2 = (list2 = (qualifierPart2 = reversedQualifierParts.get(index2 = n++)).getTypeArguments()) == null ? null : ((KtTypeArgumentList)((Object)list2)).getArguments();
                boolean bl3 = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List currentArguments = list3;
                List<TypeParameterDescriptor> list4 = classifierDescriptorChain.get(index2).getDeclaredTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list4, "classifierDescriptorChain[index].declaredTypeParameters");
                declaredTypeParameters = list4;
                List<Object> list5 = currentParameters = wasStatic ? CollectionsKt.emptyList() : declaredTypeParameters;
                if (wasStatic) {
                    object = currentArguments;
                    bl = false;
                    if (!object.isEmpty()) {
                        object = (Collection)declaredTypeParameters;
                        bl = false;
                        if (!object.isEmpty()) {
                            BindingTrace bindingTrace = c.trace;
                            object = qualifierPart2.getTypeArguments();
                            Intrinsics.checkNotNull(object);
                            bindingTrace.report(Errors.TYPE_ARGUMENTS_FOR_OUTER_CLASS_WHEN_NESTED_REFERENCED.on((KtTypeArgumentList)((PsiElement)object)));
                            return null;
                        }
                    }
                }
                if (currentArguments.size() != currentParameters.size()) {
                    object = qualifierPart2.getTypeArguments();
                    c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)(object == null ? (KtElement)qualifierPart2.getExpression() : (KtElement)object)), currentParameters.size(), classifierDescriptorChain.get(index2)));
                    return null;
                }
                result2.addAll(currentArguments);
                boolean bl4 = wasStatic = wasStatic || !classifierDescriptorChain.get(index2).isInner();
            } while (index2 != classifierChainLastIndex);
        }
        index2 = classifierChainLastIndex + 1;
        int qualifierPart2 = reversedQualifierParts.size();
        boolean currentArguments = false;
        List<QualifiedExpressionResolver.ExpressionQualifierPart> nonClassQualifierParts = reversedQualifierParts.subList(Math.min(index2, qualifierPart2), reversedQualifierParts.size());
        for (QualifiedExpressionResolver.ExpressionQualifierPart qualifierPart2 : nonClassQualifierParts) {
            KtTypeArgumentList typeArguments2 = qualifierPart2.component3();
            if (typeArguments2 == null) continue;
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)typeArguments2), "here"));
            return null;
        }
        List<TypeParameterDescriptor> qualifierPart2 = classifierDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(qualifierPart2, "classifierDescriptor.typeConstructor.parameters");
        List<TypeParameterDescriptor> parameters2 = qualifierPart2;
        if (result2.size() < parameters2.size()) {
            ClassDescriptor typeArguments2;
            declaredTypeParameters = parameters2.get(result2.size()).getOriginal().getContainingDeclaration();
            ClassDescriptor classDescriptor2 = typeArguments2 = declaredTypeParameters instanceof ClassDescriptor ? (ClassDescriptor)declaredTypeParameters : null;
            if (typeArguments2 == null) {
                return new Pair(result2, null);
            }
            ClassDescriptor nextParameterOwner = typeArguments2;
            declaredTypeParameters = c.scope;
            Intrinsics.checkNotNullExpressionValue(declaredTypeParameters, "c.scope");
            List<TypeProjection> restArguments = this.findImplicitOuterClassArguments((LexicalScope)declaredTypeParameters, nextParameterOwner);
            List<TypeParameterDescriptor> restParameters = parameters2.subList(result2.size(), parameters2.size());
            Iterable $this$sumBy$iv = this.classifierDescriptorsFromInnerToOuter(classifierDescriptor);
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)element$iv;
                int n3 = sum$iv;
                boolean bl5 = false;
                int n4 = it.getDeclaredTypeParameters().size();
                sum$iv = n3 + n4;
            }
            int typeArgumentsCanBeSpecifiedCount = sum$iv;
            if (restArguments == null && typeArgumentsCanBeSpecifiedCount > result2.size()) {
                c.trace.report(Errors.OUTER_CLASS_ARGUMENTS_REQUIRED.on((KtElement)((PsiElement)CollectionsKt.first(qualifierParts).getExpression()), nextParameterOwner));
                return null;
            }
            if (restArguments == null) {
                boolean bl6 = typeArgumentsCanBeSpecifiedCount == result2.size();
                bl = false;
                if (_Assertions.ENABLED && !bl6) {
                    boolean $i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$32 = false;
                    String $i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$32 = "Number of type arguments that can be specified (" + typeArgumentsCanBeSpecifiedCount + ") should be equal to actual arguments number " + result2.size() + ", (classifier: " + classifierDescriptor + ')';
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypeResolver$collectArgumentsForClassifierTypeConstructor$32));
                }
                return new Pair(result2, null);
            }
            boolean bl7 = restParameters.size() == restArguments.size();
            bl = false;
            if (_Assertions.ENABLED && !bl7) {
                boolean bl8 = false;
                String string2 = "Number of type of restParameters should be equal to " + restParameters.size() + ", but " + restArguments.size() + " were found for " + classifierDescriptor + '/' + nextParameterOwner;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return new Pair<List<KtTypeProjection>, List<TypeProjection>>(result2, restArguments);
        }
        return new Pair(result2, null);
    }

    private final List<ClassifierDescriptorWithTypeParameters> classifierDescriptorsFromInnerToOuter(ClassifierDescriptor $this$classifierDescriptorsFromInnerToOuter) {
        return SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<ClassifierDescriptorWithTypeParameters>($this$classifierDescriptorsFromInnerToOuter){
            final /* synthetic */ ClassifierDescriptor $this_classifierDescriptorsFromInnerToOuter;
            {
                this.$this_classifierDescriptorsFromInnerToOuter = $receiver;
                super(0);
            }

            @Nullable
            public final ClassifierDescriptorWithTypeParameters invoke() {
                ClassifierDescriptor classifierDescriptor = this.$this_classifierDescriptorsFromInnerToOuter;
                return classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            }
        }, (Function1)classifierDescriptorsFromInnerToOuter.2.INSTANCE));
    }

    private final List<TypeProjection> resolveTypeProjectionsWithErrorConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message2) {
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor(message2);
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "createErrorTypeConstructor(message)");
        return this.resolveTypeProjections(c, typeConstructor2, argumentElements);
    }

    static /* synthetic */ List resolveTypeProjectionsWithErrorConstructor$default(TypeResolver typeResolver, TypeResolutionContext typeResolutionContext, List list2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "Error type for resolving type projections";
        }
        return typeResolver.resolveTypeProjectionsWithErrorConstructor(typeResolutionContext, list2, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjectionImpl> appendDefaultArgumentsForLocalClassifier(int fromIndex, List<? extends TypeParameterDescriptor> constructorParameters) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = constructorParameters.subList(fromIndex, constructorParameters.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it.getOriginal().getDefaultType());
            collection.add(typeProjectionImpl);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeProjection> resolveTypeProjections(@NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor2, @NotNull List<? extends KtTypeProjection> argumentElements) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(argumentElements, "argumentElements");
        Iterable $this$mapIndexed$iv = argumentElements;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            TypeProjection typeProjection;
            Object parameterDescriptor;
            void i;
            void argumentElement;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object object = argumentElement.getProjectionKind();
            Intrinsics.checkNotNullExpressionValue(object, "argumentElement.projectionKind");
            KtProjectionKind projectionKind = object;
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)argumentElement;
            object = c.trace;
            Intrinsics.checkNotNullExpressionValue(object, "c.trace");
            ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, (BindingTrace)object, null, this.languageVersionSettings);
            if (projectionKind == KtProjectionKind.STAR) {
                List<TypeParameterDescriptor> list2 = constructor2.getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "constructor.parameters");
                List<TypeParameterDescriptor> parameters2 = list2;
                if (parameters2.size() > i) {
                    parameterDescriptor = parameters2.get((int)i);
                    typeProjection = TypeUtils.makeStarProjection((TypeParameterDescriptor)parameterDescriptor);
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*"));
                }
            } else {
                parameterDescriptor = c.noBareTypes();
                Intrinsics.checkNotNullExpressionValue(parameterDescriptor, "c.noBareTypes()");
                TypeResolutionContext typeResolutionContext = parameterDescriptor;
                KtTypeReference ktTypeReference = argumentElement.getTypeReference();
                Intrinsics.checkNotNull(ktTypeReference);
                parameterDescriptor = ktTypeReference;
                KotlinType type2 = this.resolveType(typeResolutionContext, (KtTypeReference)parameterDescriptor);
                Variance kind = Companion.resolveProjectionKind(projectionKind);
                if (constructor2.getParameters().size() > i) {
                    TypeParameterDescriptor parameterDescriptor2 = constructor2.getParameters().get((int)i);
                    if (kind != Variance.INVARIANT && parameterDescriptor2.getVariance() != Variance.INVARIANT) {
                        ClassifierDescriptor classifierDescriptor;
                        if (kind == parameterDescriptor2.getVariance()) {
                            BindingTrace bindingTrace = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            classifierDescriptor = constructor2.getDeclarationDescriptor();
                            Intrinsics.checkNotNull(classifierDescriptor);
                            bindingTrace.report(Errors.REDUNDANT_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        } else {
                            BindingTrace bindingTrace = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            classifierDescriptor = constructor2.getDeclarationDescriptor();
                            Intrinsics.checkNotNull(classifierDescriptor);
                            bindingTrace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind, type2);
            }
            TypeProjection typeProjection2 = typeProjection;
            collection.add(typeProjection2);
        }
        return (List)destination$iv$iv;
    }

    private final List<TypeProjection> findImplicitOuterClassArguments(LexicalScope $this$findImplicitOuterClassArguments, ClassDescriptor outerClass2) {
        ClassDescriptor classDescriptor2;
        block3: {
            ClassDescriptor classDescriptor3;
            HierarchicalScope $this$findFirstFromMeAndParent$iv = $this$findImplicitOuterClassArguments;
            boolean $i$f$findFirstFromMeAndParent = false;
            HierarchicalScope $this$processForMeAndParent$iv$iv = $this$findFirstFromMeAndParent$iv;
            boolean $i$f$processForMeAndParent = false;
            HierarchicalScope currentScope$iv$iv = $this$processForMeAndParent$iv$iv;
            while (true) {
                HierarchicalScope it$iv = currentScope$iv$iv;
                boolean bl = false;
                HierarchicalScope scope2 = it$iv;
                boolean bl2 = false;
                ClassDescriptor classDescriptor4 = scope2 instanceof LexicalScope && ((LexicalScope)scope2).getKind() == LexicalScopeKind.CLASS_MEMBER_SCOPE ? (ClassDescriptor)((LexicalScope)scope2).getOwnerDescriptor() : null;
                if (classDescriptor4 != null) {
                    ClassDescriptor classDescriptor5 = classDescriptor4;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ClassDescriptor it$iv2 = classDescriptor5;
                    boolean bl5 = false;
                    classDescriptor3 = it$iv2;
                    break block3;
                }
                HierarchicalScope hierarchicalScope = currentScope$iv$iv.getParent();
                if (hierarchicalScope == null) break;
                currentScope$iv$iv = hierarchicalScope;
            }
            classDescriptor3 = classDescriptor2 = null;
        }
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor enclosingClass = classDescriptor2;
        return DescriptorUtilsKt.findImplicitOuterClassArguments(enclosingClass, outerClass2);
    }

    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(userType, "userType");
        Intrinsics.checkNotNullParameter(trace, "trace");
        return this.resolveDescriptorForType(scope2, userType, trace, isDebuggerContext).getClassifierDescriptor();
    }

    @NotNull
    public final QualifiedExpressionResolver.TypeQualifierResolutionResult resolveDescriptorForType(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(userType, "userType");
        Intrinsics.checkNotNullParameter(trace, "trace");
        if (userType.getQualifier() != null) {
            KtUserType ktUserType = userType.getQualifier();
            Intrinsics.checkNotNull(ktUserType);
            for (KtTypeProjection typeArgument : ktUserType.getTypeArguments()) {
                KtTypeReference ktTypeReference = typeArgument.getTypeReference();
                if (ktTypeReference == null) continue;
                KtTypeReference ktTypeReference2 = ktTypeReference;
                boolean bl = false;
                boolean bl2 = false;
                KtTypeReference it = ktTypeReference2;
                boolean bl3 = false;
                this.forceResolveTypeContents(this.resolveType(scope2, it, trace, false));
            }
        }
        QualifiedExpressionResolver.TypeQualifierResolutionResult typeQualifierResolutionResult = this.qualifiedExpressionResolver.resolveDescriptorForType(userType, scope2, trace, isDebuggerContext);
        boolean bl = false;
        boolean bl4 = false;
        Object $this$resolveDescriptorForType_u24lambda_u2d14 = typeQualifierResolutionResult;
        boolean bl5 = false;
        if (((QualifiedExpressionResolver.TypeQualifierResolutionResult)$this$resolveDescriptorForType_u24lambda_u2d14).getClassifierDescriptor() != null) {
            PlatformClassesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.platformToKotlinClassMapper, trace, userType, ((QualifiedExpressionResolver.TypeQualifierResolutionResult)$this$resolveDescriptorForType_u24lambda_u2d14).getClassifierDescriptor());
        }
        return typeQualifierResolutionResult;
    }

    private static final PsiElement resolveTypeElement$lambda-2(Lazy<? extends PsiElement> $suspendModifier$delegate) {
        Lazy<? extends PsiElement> lazy = $suspendModifier$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
        return Companion.resolveProjectionKind(projectionKind);
    }

    public static final /* synthetic */ Annotations access$resolveTypeAnnotations(TypeResolver $this, TypeResolutionContext c, KtElementImplStub modifierListsOwner) {
        return $this.resolveTypeAnnotations(c, modifierListsOwner);
    }

    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement(TypeResolver $this, TypeResolutionContext c, Annotations annotations2, KtModifierList outerModifierList, KtTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, outerModifierList, typeElement);
    }

    public static final /* synthetic */ KotlinType access$resolveType(TypeResolver $this, TypeResolutionContext c, KtTypeReference typeReference) {
        return $this.resolveType(c, typeReference);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(TypeResolver $this) {
        return $this.languageVersionSettings;
    }

    public static final /* synthetic */ DynamicCallableDescriptors access$getDynamicCallableDescriptors$p(TypeResolver $this) {
        return $this.dynamicCallableDescriptors;
    }

    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$p(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(TypeResolver $this) {
        return $this.identifierChecker;
    }

    public static final /* synthetic */ AnnotationResolver access$getAnnotationResolver$p(TypeResolver $this) {
        return $this.annotationResolver;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "", "()V", "transformType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlinType", "frontend"})
    public static class TypeTransformerForTests {
        @Nullable
        public KotlinType transformType(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
            return null;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\"\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$TracingTypeAliasExpansionReportStrategy;", "Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "type", "Lorg/jetbrains/kotlin/psi/KtElement;", "typeArgumentsOrTypeName", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "typeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Ljava/util/List;Ljava/util/List;)V", "mappedArguments", "", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getType", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getTypeAliasDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getTypeArgumentsOrTypeName", "boundsViolationInSubstitution", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "unsubstitutedArgument", "argument", "typeParameter", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    private static final class TracingTypeAliasExpansionReportStrategy
    implements TypeAliasExpansionReportStrategy {
        @NotNull
        private final BindingTrace trace;
        @Nullable
        private final KtElement type;
        @Nullable
        private final KtElement typeArgumentsOrTypeName;
        @NotNull
        private final TypeAliasDescriptor typeAliasDescriptor;
        @NotNull
        private final Map<TypeParameterDescriptor, KtTypeProjection> mappedArguments;

        public TracingTypeAliasExpansionReportStrategy(@NotNull BindingTrace trace, @Nullable KtElement type2, @Nullable KtElement typeArgumentsOrTypeName, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull List<? extends TypeParameterDescriptor> typeParameters2, @NotNull List<? extends KtTypeProjection> typeArguments2) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
            Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
            Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
            this.trace = trace;
            this.type = type2;
            this.typeArgumentsOrTypeName = typeArgumentsOrTypeName;
            this.typeAliasDescriptor = typeAliasDescriptor;
            this.mappedArguments = MapsKt.toMap(CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments2));
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @Nullable
        public final KtElement getType() {
            return this.type;
        }

        @Nullable
        public final KtElement getTypeArgumentsOrTypeName() {
            return this.typeArgumentsOrTypeName;
        }

        @NotNull
        public final TypeAliasDescriptor getTypeAliasDescriptor() {
            return this.typeAliasDescriptor;
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            if (this.typeArgumentsOrTypeName != null) {
                this.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)this.typeArgumentsOrTypeName), numberOfParameters, this.typeAliasDescriptor));
            }
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            KtTypeProjection ktTypeProjection;
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(substitutedArgument, "substitutedArgument");
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            if (typeParameterDescriptor == null) {
                ktTypeProjection = null;
            } else {
                TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                TypeParameterDescriptor it = typeParameterDescriptor2;
                boolean bl3 = false;
                ktTypeProjection = this.mappedArguments.get(it);
            }
            KtTypeProjection argumentElement = ktTypeProjection;
            if (argumentElement != null) {
                this.trace.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)((PsiElement)argumentElement), typeParameter));
            } else if (this.type != null) {
                this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), this.typeAliasDescriptor.getUnderlyingType()));
            }
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            if (this.type != null) {
                this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), typeAlias));
            }
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull KotlinType bound, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument, @NotNull TypeParameterDescriptor typeParameter) {
            KtTypeReference argumentTypeReferenceElement;
            KtTypeProjection argumentElement;
            Intrinsics.checkNotNullParameter(bound, "bound");
            Intrinsics.checkNotNullParameter(unsubstitutedArgument, "unsubstitutedArgument");
            Intrinsics.checkNotNullParameter(argument, "argument");
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            ClassifierDescriptor descriptorForUnsubstitutedArgument = unsubstitutedArgument.getConstructor().getDeclarationDescriptor();
            Map<TypeParameterDescriptor, KtTypeProjection> map = this.mappedArguments;
            boolean bl = false;
            KtTypeProjection ktTypeProjection = argumentElement = map.get(descriptorForUnsubstitutedArgument);
            KtTypeReference ktTypeReference = argumentTypeReferenceElement = ktTypeProjection == null ? null : ktTypeProjection.getTypeReference();
            if (argumentTypeReferenceElement != null) {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED.on((KtTypeReference)((PsiElement)argumentTypeReferenceElement), bound, argument));
            } else if (this.type != null) {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.type), bound, argument, typeParameter));
            }
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            KtAnnotationEntry ktAnnotationEntry;
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            SourceElement sourceElement = annotation2.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement == null ? null : kotlinSourceElement.getPsi();
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$Companion;", "", "()V", "resolveProjectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "projectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
            Variance variance;
            Intrinsics.checkNotNullParameter((Object)projectionKind, "projectionKind");
            KtProjectionKind ktProjectionKind = projectionKind;
            int n = WhenMappings.$EnumSwitchMapping$0[ktProjectionKind.ordinal()];
            switch (n) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus("Illegal projection kind:", (Object)projectionKind));
                }
            }
            return variance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KtProjectionKind.values().length];
                nArray[KtProjectionKind.IN.ordinal()] = 1;
                nArray[KtProjectionKind.OUT.ordinal()] = 2;
                nArray[KtProjectionKind.NONE.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

