/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.SecureJarLoader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassPath {
    private static final ResourceStringLoaderIterator ourResourceIterator = new ResourceStringLoaderIterator();
    private static final LoaderCollector ourLoaderCollector = new LoaderCollector();
    private final List<URL> myUrls;
    private final List<Loader> myLoaders;
    private volatile boolean myAllUrlsWereProcessed;
    private final AtomicInteger myLastLoaderProcessed;
    private final Map<URL, Loader> myLoadersMap;
    private final ClasspathCache myCache;
    private final Set<URL> myURLsWithProtectionDomain;
    final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private final boolean myAcceptUnescapedUrls;
    final boolean myPreloadJarContents;
    final boolean myCanHavePersistentIndex;
    final boolean myLazyClassloadingCaches;
    @Nullable
    private final CachePoolImpl myCachePool;
    @Nullable
    private final UrlClassLoader.CachingCondition myCachingCondition;
    final boolean myLogErrorOnMissingJar;
    @Nullable
    private final LinkedHashSet<String> myJarAccessLog;
    private static final ResourceLoadingLogger ourResourceLoadingLogger;
    static final boolean ourClassLoadingInfo;
    private static final Set<String> ourLoadedClasses;
    private static final AtomicLong ourTotalTime;
    private static final AtomicInteger ourTotalRequests;
    private static final ThreadLocal<Boolean> ourDoingTiming;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(List<URL> urls) {
        if (!urls.isEmpty()) {
            List<URL> list2 = this.myUrls;
            synchronized (list2) {
                for (int i = urls.size() - 1; i >= 0; --i) {
                    this.myUrls.add(urls.get(i));
                }
                this.myAllUrlsWereProcessed = false;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Resource getResource(@NotNull String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Enumeration<URL> getResources(String name) {
        return new MyEnumeration(name);
    }

    @Nullable
    private Loader getLoader(int i) {
        if (i < this.myLastLoaderProcessed.get()) {
            return this.myLoaders.get(i);
        }
        return this.getLoaderSlowPath(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoaderSlowPath(int i) {
        while (this.myLoaders.size() < i + 1) {
            URL url;
            List<URL> list2 = this.myUrls;
            synchronized (list2) {
                int size = this.myUrls.size();
                if (size == 0) {
                    if (this.myCanUseCache) {
                        this.myAllUrlsWereProcessed = true;
                    }
                    return null;
                }
                url = this.myUrls.remove(size - 1);
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                this.initLoaders(url, this.myLoaders.size());
            }
            catch (IOException e) {
                LoggerRt.getInstance(ClassPath.class).info("url: " + url, e);
            }
        }
        return this.myLoaders.get(i);
    }

    private void initLoaders(@NotNull URL url, int index2) throws IOException {
        File file2;
        Loader loader;
        String path2;
        if (url == null) {
            ClassPath.$$$reportNull$$$0(5);
        }
        if (this.myAcceptUnescapedUrls) {
            path2 = url.getFile();
        } else {
            try {
                path2 = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                LoggerRt.getInstance(ClassPath.class).error("url: " + url, e);
                path2 = url.getFile();
            }
        }
        if (path2 != null && "file".equals(url.getProtocol()) && (loader = this.createLoader(url, index2, file2 = new File(path2), file2.getName().startsWith("classpath"))) != null) {
            this.initLoader(url, loader);
        }
    }

    private Loader createLoader(@NotNull URL url, int index2, @NotNull File file2, boolean processRecursively) throws IOException {
        if (url == null) {
            ClassPath.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            ClassPath.$$$reportNull$$$0(7);
        }
        if (file2.isDirectory()) {
            return new FileLoader(url, index2, this);
        }
        if (file2.isFile()) {
            String[] referencedJars;
            JarLoader loader;
            boolean isSigned = this.myURLsWithProtectionDomain.contains(url);
            JarLoader jarLoader = loader = isSigned ? new SecureJarLoader(url, file2.getPath(), index2, this) : new JarLoader(url, file2.getPath(), index2, this);
            if (processRecursively && (referencedJars = ClassPath.loadManifestClasspath(loader)) != null) {
                long s2 = ourClassLoadingInfo ? System.nanoTime() : 0L;
                ArrayList<URL> urls = new ArrayList<URL>(referencedJars.length);
                for (String referencedJar : referencedJars) {
                    try {
                        urls.add(UrlClassLoader.internProtocol(new URI(referencedJar).toURL()));
                    }
                    catch (Exception e) {
                        LoggerRt.getInstance(ClassPath.class).warn("url: " + url + " / " + referencedJar, e);
                    }
                }
                this.push(urls);
                if (ourClassLoadingInfo) {
                    System.out.println("Loaded all " + referencedJars.length + " urls " + (System.nanoTime() - s2) / 1000000L + "ms");
                }
            }
            return loader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoader(@NotNull URL url, @NotNull Loader loader) throws IOException {
        if (url == null) {
            ClassPath.$$$reportNull$$$0(8);
        }
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(9);
        }
        if (this.myCanUseCache) {
            boolean lastOne;
            ClasspathCache.LoaderData data2;
            ClasspathCache.LoaderData loaderData = data2 = this.myCachePool == null ? null : this.myCachePool.getCachedData(url);
            if (data2 == null) {
                data2 = loader.buildData();
                if (this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
                    this.myCachePool.cacheData(url, data2);
                }
            }
            this.myCache.applyLoaderData(data2, loader);
            List<URL> list2 = this.myUrls;
            synchronized (list2) {
                lastOne = this.myUrls.isEmpty();
            }
            if (lastOne) {
                this.myAllUrlsWereProcessed = true;
            }
        }
        this.myLoaders.add(loader);
        this.myLoadersMap.put(url, loader);
        this.myLastLoaderProcessed.incrementAndGet();
    }

    Attributes getManifestData(@NotNull URL url) {
        if (url == null) {
            ClassPath.$$$reportNull$$$0(10);
        }
        return this.myCanUseCache && this.myCachePool != null ? this.myCachePool.getManifestData(url) : null;
    }

    void cacheManifestData(@NotNull URL url, @NotNull Attributes manifestAttributes) {
        if (url == null) {
            ClassPath.$$$reportNull$$$0(11);
        }
        if (manifestAttributes == null) {
            ClassPath.$$$reportNull$$$0(12);
        }
        if (this.myCanUseCache && this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
            this.myCachePool.cacheManifestData(url, manifestAttributes);
        }
    }

    private static long startTiming() {
        if (!ourClassLoadingInfo) {
            return 0L;
        }
        if (ourDoingTiming.get() != null) {
            return 0L;
        }
        ourDoingTiming.set(Boolean.TRUE);
        return System.nanoTime();
    }

    private static void logInfo(ClassPath path2, long started, String resourceName, Resource resource) {
        if (!ourClassLoadingInfo) {
            return;
        }
        if (resource != null) {
            String urlPath = resource.getURL().getPath();
            if (urlPath.endsWith(resourceName)) {
                String modulePath = urlPath.substring(0, urlPath.length() - resourceName.length());
                if (modulePath.startsWith("file:")) {
                    modulePath = modulePath.substring("file:".length());
                }
                if (modulePath.endsWith("/")) {
                    modulePath = modulePath.substring(0, modulePath.length() - 1);
                }
                if (modulePath.endsWith("!")) {
                    modulePath = modulePath.substring(0, modulePath.length() - 1);
                }
                urlPath = resourceName + ":" + modulePath;
            }
            ourLoadedClasses.add(urlPath);
        }
        if (started == 0L) {
            return;
        }
        ourDoingTiming.set(null);
        long time = System.nanoTime() - started;
        long totalTime = ourTotalTime.addAndGet(time);
        int totalRequests = ourTotalRequests.incrementAndGet();
        if (time > 3000000L) {
            System.out.println(time / 1000000L + " ms for " + resourceName);
        }
        if (totalRequests % 10000 == 0) {
            System.out.println(path2.getClass().getClassLoader() + ", requests:" + ourTotalRequests + ", time:" + totalTime / 1000000L + "ms");
        }
    }

    private static String[] loadManifestClasspath(JarLoader loader) {
        try {
            String[] urls;
            String classPath2 = loader.getClassPathManifestAttribute();
            if (classPath2 != null && (urls = classPath2.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        String className2 = System.getProperty("intellij.class.resources.loading.logger");
        ResourceLoadingLogger resourceLoadingLogger = null;
        if (className2 != null) {
            try {
                resourceLoadingLogger = (ResourceLoadingLogger)Class.forName(className2).newInstance();
            }
            catch (Throwable e) {
                LoggerRt.getInstance(ClassPath.class).error("Failed to instantiate resource loading logger " + className2, e);
            }
        }
        ourResourceLoadingLogger = resourceLoadingLogger;
        ourClassLoadingInfo = Boolean.getBoolean("idea.log.classpath.info");
        ourLoadedClasses = ourClassLoadingInfo ? Collections.synchronizedSet(new LinkedHashSet()) : null;
        ourTotalTime = new AtomicLong();
        ourTotalRequests = new AtomicInteger();
        ourDoingTiming = new ThreadLocal();
        if (ourClassLoadingInfo) {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook for tracing classloading information"){

                @Override
                public void run() {
                    System.out.println("Classloading requests:" + ClassPath.class.getClassLoader() + "," + ourTotalRequests + ", time:" + ourTotalTime.get() / 1000000L + "ms");
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsWithProtectionDomain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ClassPath";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarAccessLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initLoaders";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initLoader";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getManifestData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cacheManifestData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResourceLoadingLogger {
        public void logResource(String var1, URL var2, long var3);
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, Collection<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(@NotNull Loader loader, @NotNull Collection<Loader> parameter, @NotNull Object parameter2, @NotNull String shortName) {
            if (loader == null) {
                LoaderCollector.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                LoaderCollector.$$$reportNull$$$0(1);
            }
            if (parameter2 == null) {
                LoaderCollector.$$$reportNull$$$0(2);
            }
            if (shortName == null) {
                LoaderCollector.$$$reportNull$$$0(3);
            }
            parameter.add(loader);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shortName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ClassPath$LoaderCollector";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private ResourceStringLoaderIterator() {
        }

        @Override
        Resource process(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath2, @NotNull String shortName) {
            if (loader == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(0);
            }
            if (s == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(1);
            }
            if (classPath2 == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(2);
            }
            if (shortName == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(3);
            }
            return loader.containsName(s, shortName) ? ResourceStringLoaderIterator.findInLoader(loader, s, classPath2) : null;
        }

        @Nullable
        private static Resource findInLoader(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath2) {
            Resource resource;
            if (loader == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(4);
            }
            if (s == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(5);
            }
            if (classPath2 == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(6);
            }
            if ((resource = loader.getResource(s)) != null) {
                ResourceStringLoaderIterator.logFoundResource(loader, s, classPath2, resource);
            }
            return resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void logFoundResource(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath2, @NotNull Resource resource) {
            if (loader == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(7);
            }
            if (s == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(8);
            }
            if (classPath2 == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(9);
            }
            if (resource == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(10);
            }
            if (classPath2.myJarAccessLog != null) {
                LinkedHashSet linkedHashSet = classPath2.myJarAccessLog;
                synchronized (linkedHashSet) {
                    classPath2.myJarAccessLog.add(loader.getBaseURL().toString());
                }
            }
            if (ourResourceLoadingLogger != null) {
                long resourceSize;
                try {
                    resourceSize = resource instanceof MemoryResource ? (long)resource.getBytes().length : -1L;
                }
                catch (IOException e) {
                    resourceSize = -1L;
                }
                ourResourceLoadingLogger.logResource(s, loader.getBaseURL(), resourceSize);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loader";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortName";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resource";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/lang/ClassPath$ResourceStringLoaderIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findInLoader";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logFoundResource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex;
        private Resource myRes;
        @NotNull
        private final String myName;
        private final String myShortName;
        private final List<Loader> myLoaders;

        MyEnumeration(String name) {
            if (name == null) {
                MyEnumeration.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myShortName = ClasspathCache.transformName(name);
            ArrayList loaders = null;
            if (ClassPath.this.myCanUseCache && ClassPath.this.myAllUrlsWereProcessed) {
                LinkedHashSet loadersSet = new LinkedHashSet();
                ClassPath.this.myCache.iterateLoaders(name, ourLoaderCollector, loadersSet, this, this.myShortName);
                if (name.endsWith("/")) {
                    ClassPath.this.myCache.iterateLoaders(name.substring(0, name.length() - 1), ourLoaderCollector, loadersSet, this, this.myShortName);
                } else {
                    ClassPath.this.myCache.iterateLoaders(name + "/", ourLoaderCollector, loadersSet, this, this.myShortName);
                }
                loaders = new ArrayList(loadersSet);
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.myRes != null) {
                return true;
            }
            long started = ClassPath.startTiming();
            try {
                if (this.myLoaders != null) {
                    while (this.myIndex < this.myLoaders.size()) {
                        Loader loader;
                        if (!(loader = this.myLoaders.get(this.myIndex++)).containsName(this.myName, this.myShortName)) {
                            this.myRes = null;
                            continue;
                        }
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Loader loader;
                    while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                        if (ClassPath.this.myCanUseCache && !loader.containsName(this.myName, this.myShortName)) continue;
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ClassPath.logInfo(ClassPath.this, started, this.myName, null);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/ClassPath$MyEnumeration", "<init>"));
        }
    }
}

