/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.VarArgsChecker;
import com.sun.jna.WString;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 256;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 63;
    private static final int MASK_CC = 63;
    public static final int THROW_LAST_ERROR = 64;
    public static final int USE_VARARGS = 384;
    static final Integer INTEGER_TRUE = -1;
    static final Integer INTEGER_FALSE = 0;
    private NativeLibrary library;
    private final String functionName;
    final String encoding;
    final int callFlags;
    final Map<String, ?> options;
    static final String OPTION_INVOKING_METHOD = "invoking-method";
    private static final VarArgsChecker IS_VARARGS = VarArgsChecker.create();

    public static Function getFunction(String libraryName2, String functionName) {
        return NativeLibrary.getInstance(libraryName2).getFunction(functionName);
    }

    public static Function getFunction(String libraryName2, String functionName, int callFlags) {
        return NativeLibrary.getInstance(libraryName2).getFunction(functionName, callFlags, null);
    }

    public static Function getFunction(String libraryName2, String functionName, int callFlags, String encoding) {
        return NativeLibrary.getInstance(libraryName2).getFunction(functionName, callFlags, encoding);
    }

    public static Function getFunction(Pointer p) {
        return Function.getFunction(p, 0, null);
    }

    public static Function getFunction(Pointer p, int callFlags) {
        return Function.getFunction(p, callFlags, null);
    }

    public static Function getFunction(Pointer p, int callFlags, String encoding) {
        return new Function(p, callFlags, encoding);
    }

    Function(NativeLibrary library, String functionName, int callFlags, String encoding) {
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionName == null) {
            throw new NullPointerException("Function name must not be null");
        }
        this.library = library;
        this.functionName = functionName;
        this.callFlags = callFlags;
        this.options = library.options;
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
        try {
            this.peer = library.getSymbolAddress(functionName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsatisfiedLinkError("Error looking up function '" + functionName + "': " + e.getMessage());
        }
    }

    Function(Pointer functionAddress, int callFlags, String encoding) {
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionAddress == null || functionAddress.peer == 0L) {
            throw new NullPointerException("Function address may not be null");
        }
        this.functionName = functionAddress.toString();
        this.callFlags = callFlags;
        this.peer = functionAddress.peer;
        this.options = Collections.EMPTY_MAP;
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
    }

    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        if ((convention & 0x3F) != convention) {
            throw new IllegalArgumentException("Unrecognized calling convention: " + convention);
        }
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callFlags & 0x3F;
    }

    public Object invoke(Class<?> returnType2, Object[] inArgs) {
        return this.invoke(returnType2, inArgs, this.options);
    }

    public Object invoke(Class<?> returnType2, Object[] inArgs, Map<String, ?> options) {
        Method invokingMethod = (Method)options.get(OPTION_INVOKING_METHOD);
        Class<?>[] paramTypes = invokingMethod != null ? invokingMethod.getParameterTypes() : null;
        return this.invoke(invokingMethod, paramTypes, returnType2, inArgs, options);
    }

    Object invoke(Method invokingMethod, Class<?>[] paramTypes, Class<?> returnType2, Object[] inArgs, Map<String, ?> options) {
        Object[] args2 = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 256) {
                throw new UnsupportedOperationException("Maximum argument count is 256");
            }
            args2 = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args2, 0, args2.length);
        }
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        boolean allowObjects = Boolean.TRUE.equals(options.get("allow-objects"));
        boolean isVarArgs = args2.length > 0 && invokingMethod != null ? Function.isVarArgs(invokingMethod) : false;
        int fixedArgs = args2.length > 0 && invokingMethod != null ? Function.fixedArgs(invokingMethod) : 0;
        for (int i = 0; i < args2.length; ++i) {
            Class<?> paramType = invokingMethod != null ? (isVarArgs && i >= paramTypes.length - 1 ? paramTypes[paramTypes.length - 1].getComponentType() : paramTypes[i]) : null;
            args2[i] = this.convertArgument(args2, i, invokingMethod, mapper, allowObjects, paramType);
        }
        Class<?> nativeReturnType = returnType2;
        FromNativeConverter resultConverter = null;
        if (NativeMapped.class.isAssignableFrom(returnType2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(returnType2);
            resultConverter = tc;
            nativeReturnType = tc.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType2)) != null) {
            nativeReturnType = resultConverter.nativeType();
        }
        Object result2 = this.invoke(args2, nativeReturnType, allowObjects, fixedArgs);
        if (resultConverter != null) {
            FunctionResultContext context2 = invokingMethod != null ? new MethodResultContext(returnType2, this, inArgs, invokingMethod) : new FunctionResultContext(returnType2, this, inArgs);
            result2 = resultConverter.fromNative(result2, context2);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                Object inArg = inArgs[i];
                if (inArg == null) continue;
                if (inArg instanceof Structure) {
                    if (inArg instanceof Structure.ByValue) continue;
                    ((Structure)inArg).autoRead();
                    continue;
                }
                if (args2[i] instanceof PostCallRead) {
                    ((PostCallRead)args2[i]).read();
                    if (!(args2[i] instanceof PointerArray)) continue;
                    PointerArray array = (PointerArray)args2[i];
                    if (!Structure.ByReference[].class.isAssignableFrom(inArg.getClass())) continue;
                    Class<?> type2 = inArg.getClass().getComponentType();
                    Structure[] ss = (Structure[])inArg;
                    for (int si = 0; si < ss.length; ++si) {
                        Pointer p = array.getPointer(Native.POINTER_SIZE * si);
                        ss[si] = Structure.updateStructureByReference(type2, ss[si], p);
                    }
                    continue;
                }
                if (!Structure[].class.isAssignableFrom(inArg.getClass())) continue;
                Structure.autoRead((Structure[])inArg);
            }
        }
        return result2;
    }

    Object invoke(Object[] args2, Class<?> returnType2, boolean allowObjects) {
        return this.invoke(args2, returnType2, allowObjects, 0);
    }

    Object invoke(Object[] args2, Class<?> returnType2, boolean allowObjects, int fixedArgs) {
        Object result2 = null;
        int callFlags = this.callFlags | (fixedArgs & 3) << 7;
        if (returnType2 == null || returnType2 == Void.TYPE || returnType2 == Void.class) {
            Native.invokeVoid(this, this.peer, callFlags, args2);
            result2 = null;
        } else if (returnType2 == Boolean.TYPE || returnType2 == Boolean.class) {
            result2 = Function.valueOf(Native.invokeInt(this, this.peer, callFlags, args2) != 0);
        } else if (returnType2 == Byte.TYPE || returnType2 == Byte.class) {
            result2 = (byte)Native.invokeInt(this, this.peer, callFlags, args2);
        } else if (returnType2 == Short.TYPE || returnType2 == Short.class) {
            result2 = (short)Native.invokeInt(this, this.peer, callFlags, args2);
        } else if (returnType2 == Character.TYPE || returnType2 == Character.class) {
            result2 = Character.valueOf((char)Native.invokeInt(this, this.peer, callFlags, args2));
        } else if (returnType2 == Integer.TYPE || returnType2 == Integer.class) {
            result2 = Native.invokeInt(this, this.peer, callFlags, args2);
        } else if (returnType2 == Long.TYPE || returnType2 == Long.class) {
            result2 = Native.invokeLong(this, this.peer, callFlags, args2);
        } else if (returnType2 == Float.TYPE || returnType2 == Float.class) {
            result2 = Float.valueOf(Native.invokeFloat(this, this.peer, callFlags, args2));
        } else if (returnType2 == Double.TYPE || returnType2 == Double.class) {
            result2 = Native.invokeDouble(this, this.peer, callFlags, args2);
        } else if (returnType2 == String.class) {
            result2 = this.invokeString(callFlags, args2, false);
        } else if (returnType2 == WString.class) {
            String s = this.invokeString(callFlags, args2, true);
            if (s != null) {
                result2 = new WString(s);
            }
        } else {
            if (Pointer.class.isAssignableFrom(returnType2)) {
                return this.invokePointer(callFlags, args2);
            }
            if (Structure.class.isAssignableFrom(returnType2)) {
                if (Structure.ByValue.class.isAssignableFrom(returnType2)) {
                    Structure s = Native.invokeStructure(this, this.peer, callFlags, args2, Structure.newInstance(returnType2));
                    s.autoRead();
                    result2 = s;
                } else {
                    result2 = this.invokePointer(callFlags, args2);
                    if (result2 != null) {
                        Object s = Structure.newInstance(returnType2, (Pointer)result2);
                        ((Structure)s).conditionalAutoRead();
                        result2 = s;
                    }
                }
            } else if (Callback.class.isAssignableFrom(returnType2)) {
                result2 = this.invokePointer(callFlags, args2);
                if (result2 != null) {
                    result2 = CallbackReference.getCallback(returnType2, (Pointer)result2);
                }
            } else if (returnType2 == String[].class) {
                Pointer p = this.invokePointer(callFlags, args2);
                if (p != null) {
                    result2 = p.getStringArray(0L, this.encoding);
                }
            } else if (returnType2 == WString[].class) {
                Pointer p = this.invokePointer(callFlags, args2);
                if (p != null) {
                    String[] arr = p.getWideStringArray(0L);
                    WString[] warr = new WString[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        warr[i] = new WString(arr[i]);
                    }
                    result2 = warr;
                }
            } else if (returnType2 == Pointer[].class) {
                Pointer p = this.invokePointer(callFlags, args2);
                if (p != null) {
                    result2 = p.getPointerArray(0L);
                }
            } else if (allowObjects) {
                result2 = Native.invokeObject(this, this.peer, callFlags, args2);
                if (result2 != null && !returnType2.isAssignableFrom(result2.getClass())) {
                    throw new ClassCastException("Return type " + returnType2 + " does not match result " + result2.getClass());
                }
            } else {
                throw new IllegalArgumentException("Unsupported return type " + returnType2 + " in function " + this.getName());
            }
        }
        return result2;
    }

    private Pointer invokePointer(int callFlags, Object[] args2) {
        long ptr = Native.invokePointer(this, this.peer, callFlags, args2);
        return ptr == 0L ? null : new Pointer(ptr);
    }

    private Object convertArgument(Object[] args2, int index2, Method invokingMethod, TypeMapper mapper, boolean allowObjects, Class<?> expectedType2) {
        Object arg = args2[index2];
        if (arg != null) {
            Class<?> type2 = arg.getClass();
            ToNativeConverter converter = null;
            if (NativeMapped.class.isAssignableFrom(type2)) {
                converter = NativeMappedConverter.getInstance(type2);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type2);
            }
            if (converter != null) {
                FunctionParameterContext context2 = invokingMethod != null ? new MethodParameterContext(this, args2, index2, invokingMethod) : new FunctionParameterContext(this, args2, index2);
                arg = converter.toNative(arg, context2);
            }
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.autoWrite();
            if (struct instanceof Structure.ByValue) {
                Class<?> ptype = struct.getClass();
                if (invokingMethod != null) {
                    Class<?>[] ptypes = invokingMethod.getParameterTypes();
                    if (IS_VARARGS.isVarArgs(invokingMethod)) {
                        if (index2 < ptypes.length - 1) {
                            ptype = ptypes[index2];
                        } else {
                            Class<?> etype = ptypes[ptypes.length - 1].getComponentType();
                            if (etype != Object.class) {
                                ptype = etype;
                            }
                        }
                    } else {
                        ptype = ptypes[index2];
                    }
                }
                if (Structure.ByValue.class.isAssignableFrom(ptype)) {
                    return struct;
                }
            }
            return struct.getPointer();
        }
        if (arg instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg);
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, false).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof Boolean) {
            return Boolean.TRUE.equals(arg) ? INTEGER_TRUE : INTEGER_FALSE;
        }
        if (String[].class == argClass) {
            return new StringArray((String[])arg, this.encoding);
        }
        if (WString[].class == argClass) {
            return new StringArray((WString[])arg);
        }
        if (Pointer[].class == argClass) {
            return new PointerArray((Pointer[])arg);
        }
        if (NativeMapped[].class.isAssignableFrom(argClass)) {
            return new NativeMappedArray((NativeMapped[])arg);
        }
        if (Structure[].class.isAssignableFrom(argClass)) {
            Structure[] ss = (Structure[])arg;
            Class<?> type3 = argClass.getComponentType();
            boolean byRef = Structure.ByReference.class.isAssignableFrom(type3);
            if (expectedType2 != null && !Structure.ByReference[].class.isAssignableFrom(expectedType2)) {
                if (byRef) {
                    throw new IllegalArgumentException("Function " + this.getName() + " declared Structure[] at parameter " + index2 + " but array of " + type3 + " was passed");
                }
                for (int i = 0; i < ss.length; ++i) {
                    if (!(ss[i] instanceof Structure.ByReference)) continue;
                    throw new IllegalArgumentException("Function " + this.getName() + " declared Structure[] at parameter " + index2 + " but element " + i + " is of Structure.ByReference type");
                }
            }
            if (byRef) {
                Structure.autoWrite(ss);
                Pointer[] pointers = new Pointer[ss.length + 1];
                for (int i = 0; i < ss.length; ++i) {
                    pointers[i] = ss[i] != null ? ss[i].getPointer() : null;
                }
                return new PointerArray(pointers);
            }
            if (ss.length == 0) {
                throw new IllegalArgumentException("Structure array must have non-zero length");
            }
            if (ss[0] == null) {
                ((Structure)Structure.newInstance(type3)).toArray(ss);
                return ss[0].getPointer();
            }
            Structure.autoWrite(ss);
            return ss[0].getPointer();
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + argClass.getComponentType());
        }
        if (allowObjects) {
            return arg;
        }
        if (!Native.isSupportedNativeType(arg.getClass())) {
            throw new IllegalArgumentException("Unsupported argument type " + arg.getClass().getName() + " at parameter " + index2 + " of function " + this.getName());
        }
        return arg;
    }

    private boolean isPrimitiveArray(Class<?> argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    public void invoke(Object[] args2) {
        this.invoke(Void.class, args2);
    }

    private String invokeString(int callFlags, Object[] args2, boolean wide) {
        Pointer ptr = this.invokePointer(callFlags, args2);
        String s = null;
        if (ptr != null) {
            s = wide ? ptr.getWideString(0L) : ptr.getString(0L, this.encoding);
        }
        return s;
    }

    @Override
    public String toString() {
        if (this.library != null) {
            return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
        }
        return "native function@0x" + Long.toHexString(this.peer);
    }

    public Object invokeObject(Object[] args2) {
        return this.invoke(Object.class, args2);
    }

    public Pointer invokePointer(Object[] args2) {
        return (Pointer)this.invoke(Pointer.class, args2);
    }

    public String invokeString(Object[] args2, boolean wide) {
        Object o = this.invoke(wide ? WString.class : String.class, args2);
        return o != null ? o.toString() : null;
    }

    public int invokeInt(Object[] args2) {
        return (Integer)this.invoke(Integer.class, args2);
    }

    public long invokeLong(Object[] args2) {
        return (Long)this.invoke(Long.class, args2);
    }

    public float invokeFloat(Object[] args2) {
        return ((Float)this.invoke(Float.class, args2)).floatValue();
    }

    public double invokeDouble(Object[] args2) {
        return (Double)this.invoke(Double.class, args2);
    }

    public void invokeVoid(Object[] args2) {
        this.invoke(Void.class, args2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Function other = (Function)o;
            return other.callFlags == this.callFlags && other.options.equals(this.options) && other.peer == this.peer;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.callFlags + this.options.hashCode() + super.hashCode();
    }

    static Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray()) {
                Object[] varArgs = (Object[])lastArg;
                for (int i = 0; i < varArgs.length; ++i) {
                    if (!(varArgs[i] instanceof Float)) continue;
                    varArgs[i] = (double)((Float)varArgs[i]).floatValue();
                }
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    static boolean isVarArgs(Method m) {
        return IS_VARARGS.isVarArgs(m);
    }

    static int fixedArgs(Method m) {
        return IS_VARARGS.fixedArgs(m);
    }

    static Boolean valueOf(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private final Pointer[] original;

        public PointerArray(Pointer[] arg) {
            super(Native.POINTER_SIZE * (arg.length + 1));
            this.original = arg;
            for (int i = 0; i < arg.length; ++i) {
                this.setPointer(i * Native.POINTER_SIZE, arg[i]);
            }
            this.setPointer(Native.POINTER_SIZE * arg.length, null);
        }

        @Override
        public void read() {
            this.read(0L, this.original, 0, this.original.length);
        }
    }

    private static class NativeMappedArray
    extends Memory
    implements PostCallRead {
        private final NativeMapped[] original;

        public NativeMappedArray(NativeMapped[] arg) {
            super(Native.getNativeSize(arg.getClass(), arg));
            this.original = arg;
            this.setValue(0L, this.original, this.original.getClass());
        }

        @Override
        public void read() {
            this.getValue(0L, this.original.getClass(), this.original);
        }
    }

    public static interface PostCallRead {
        public void read();
    }
}

