/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "className", "Lorg/jetbrains/kotlin/name/ClassId;", "classVersion", "", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "innerClasses", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;ILorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "location", "", "getLocation", "()Ljava/lang/String;", "equals", "", "other", "", "getFileContents", "", "hashCode", "toString", "Factory", "frontend.java"})
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final PerformanceCounter perfCounter;

    private VirtualFileKotlinClass(VirtualFile file2, ClassId className2, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses2) {
        super(className2, classVersion, classHeader, innerClasses2);
        this.file = file2;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getLocation() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "file.path");
        return string2;
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "file.contentsToByteArray()");
            return byArray;
        }
        catch (IOException e) {
            LOG.error(VirtualFileKotlinClass.Factory.renderFileReadingErrorMessage(this.file), e);
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual(((VirtualFileKotlinClass)other).file, this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    public /* synthetic */ VirtualFileKotlinClass(VirtualFile file2, ClassId className2, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses2, DefaultConstructorMarker $constructor_marker) {
        this(file2, className2, classVersion, classHeader, innerClasses2);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(VirtualFileKotlinClass.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(VirtualFileKotlinClass::class.java)");
        LOG = logger;
        perfCounter = PerformanceCounter.Companion.create$default(PerformanceCounter.Companion, "Binary class from Kotlin file", false, 2, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "perfCounter", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "create", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "renderFileReadingErrorMessage", "", "frontend.java"})
    public static final class Factory {
        private Factory() {
        }

        @Deprecated(message="Use KotlinBinaryClassCache")
        @Nullable
        public final KotlinClassFinder.Result create(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
            Intrinsics.checkNotNullParameter(file2, "file");
            return (KotlinClassFinder.Result)perfCounter.time((Function0)new Function0<KotlinClassFinder.Result>(file2, fileContent, this){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ byte[] $fileContent;
                final /* synthetic */ Factory this$0;
                {
                    this.$file = $file;
                    this.$fileContent = $fileContent;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final KotlinClassFinder.Result invoke() {
                    boolean bl = Intrinsics.areEqual(this.$file.getFileType(), JavaClassFileType.INSTANCE);
                    Object object = this.$file;
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = Intrinsics.stringPlus("Trying to read binary data from a non-class file ", object);
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    try {
                        object = this.$fileContent;
                        Object byteContent = object == null ? (Object)this.$file.contentsToByteArray(false) : object;
                        Intrinsics.checkNotNullExpressionValue(byteContent, "byteContent");
                        object = byteContent;
                        bl2 = false;
                        if (!(((Object)object).length == 0)) {
                            KotlinClassFinder.Result.KotlinClass kotlinClass2;
                            VirtualFileKotlinClass kotlinJvmBinaryClass2 = (VirtualFileKotlinClass)FileBasedKotlinClass.create((byte[])byteContent, (Function4)new Function4<ClassId, Integer, KotlinClassHeader, FileBasedKotlinClass.InnerClassesInfo, VirtualFileKotlinClass>(this.$file){
                                final /* synthetic */ VirtualFile $file;
                                {
                                    this.$file = $file;
                                    super(4);
                                }

                                public final VirtualFileKotlinClass invoke(ClassId name, Integer classVersion, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses2) {
                                    Intrinsics.checkNotNullExpressionValue(name, "name");
                                    Intrinsics.checkNotNullExpressionValue(classVersion, "classVersion");
                                    int n = classVersion;
                                    Intrinsics.checkNotNullExpressionValue(header, "header");
                                    Intrinsics.checkNotNullExpressionValue(innerClasses2, "innerClasses");
                                    return new VirtualFileKotlinClass(this.$file, name, n, header, innerClasses2, null);
                                }
                            });
                            VirtualFileKotlinClass virtualFileKotlinClass = kotlinJvmBinaryClass2;
                            if (virtualFileKotlinClass == null) {
                                kotlinClass2 = null;
                            } else {
                                VirtualFileKotlinClass virtualFileKotlinClass2 = virtualFileKotlinClass;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                VirtualFileKotlinClass it = virtualFileKotlinClass2;
                                boolean bl6 = false;
                                kotlinClass2 = new KotlinClassFinder.Result.KotlinClass(it, (byte[])byteContent);
                            }
                            KotlinClassFinder.Result.KotlinClass kotlinClass3 = kotlinClass2;
                            return kotlinClass3 == null ? (KotlinClassFinder.Result)new KotlinClassFinder.Result.ClassFileContent((byte[])byteContent) : (KotlinClassFinder.Result)kotlinClass3;
                        }
                    }
                    catch (FileNotFoundException byteContent) {
                    }
                    catch (Throwable e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        VirtualFileKotlinClass.access$getLOG$cp().warn(org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.access$renderFileReadingErrorMessage(this.this$0, this.$file), e);
                    }
                    return null;
                }
            });
        }

        private final String renderFileReadingErrorMessage(VirtualFile file2) {
            return "Could not read file: " + file2.getPath() + "; size in bytes: " + file2.getLength() + "; file type: " + file2.getFileType().getName();
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

