/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u00b8\u0001\u0010\"\u001aN\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0$\u00128\u00126\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020'\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'0#0#\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0\u00012\u0006\u0010+\u001a\u00020\u00102\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u00020'2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'H\u0000\u001a \u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u000202H\u0002\u001a \u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u000202H\u0002\u001a0\u00104\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0002\u001aJ\u0010:\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u00102\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u00107\u001a\u00020\u00022\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u00109\u001a\u00020\u00022\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002\u001a \u0010@\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u0002\u001a6\u0010C\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u00102\n\u0010D\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010B\u001a\u00020\u00022\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002\u001a\u0016\u0010E\u001a\u0004\u0018\u00010F2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030HH\u0002\u001a\u0010\u0010I\u001a\u00020\u00062\b\u0010B\u001a\u0004\u0018\u00010\u0002\u001a\u0012\u0010J\u001a\u00020\u00062\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0018\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u0006\u0010L\u001a\u00020\u0010H\u0002\u001a\u0084\u0001\u0010M\u001a:\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0N\u0012*\u0012(\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020O\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0O0#0#\"\u0004\b\u0000\u0010%2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H%0\u00012\u0006\u0010+\u001a\u00020\u00102\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u00020O2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0OH\u0000\u001a\u000e\u0010P\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030Q\u001a\u000e\u0010P\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030/\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\"\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\"\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0004\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0004\"\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0004\"\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0004\"\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0004\"\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0004\"\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0004\u00a8\u0006R"}, d2={"ANY", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "", "getANY", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "BOOLEAN", "", "getBOOLEAN", "BYTE", "", "getBYTE", "CHAR", "", "getCHAR", "DIVISION_OPERATION_NAMES", "", "", "DOUBLE", "", "getDOUBLE", "FLOAT", "", "getFLOAT", "INT", "", "getINT", "LONG", "", "getLONG", "SHORT", "", "getSHORT", "STRING", "getSTRING", "binaryOperation", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/BinaryOperationKey;", "A", "B", "Lkotlin/Function2;", "Ljava/math/BigInteger;", "a", "b", "functionName", "operation", "checker", "createCompileTimeConstantForCompareTo", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstantForEquals", "evaluateBinary", "name", "receiverTypeStr", "receiverValue", "parameterTypeStr", "parameterValue", "evaluateBinaryAndCheck", "receiverType", "parameterType", "tracer", "Lkotlin/Function0;", "", "evaluateUnary", "typeStr", "value", "evaluateUnaryAndCheck", "type", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isIntegerType", "isZero", "typeStrToCompileTimeType", "str", "unaryOperation", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/UnaryOperationKey;", "Lkotlin/Function1;", "isStandaloneOnlyConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "frontend"})
public final class ConstantExpressionEvaluatorKt {
    @NotNull
    private static final Set<String> DIVISION_OPERATION_NAMES;
    @NotNull
    private static final CompileTimeType<Byte> BYTE;
    @NotNull
    private static final CompileTimeType<Short> SHORT;
    @NotNull
    private static final CompileTimeType<Integer> INT;
    @NotNull
    private static final CompileTimeType<Long> LONG;
    @NotNull
    private static final CompileTimeType<Double> DOUBLE;
    @NotNull
    private static final CompileTimeType<Float> FLOAT;
    @NotNull
    private static final CompileTimeType<Character> CHAR;
    @NotNull
    private static final CompileTimeType<Boolean> BOOLEAN;
    @NotNull
    private static final CompileTimeType<String> STRING;
    @NotNull
    private static final CompileTimeType<Object> ANY;

    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        if (result2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = operationReference instanceof KtSimpleNameExpression;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = "This method should be called only for equals operations";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER)) {
                boolean bl5 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.EQUALS);
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl7 = false;
                    String string3 = "This method should be called only for equals operations";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                bl = (Boolean)result2;
            } else {
                throw new IllegalStateException("Unknown equals operation token: " + operationToken + ' ' + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value2 = bl;
            return new BooleanValue(value2);
        }
        return null;
    }

    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        if (result2 instanceof Integer) {
            ConstantValue constantValue;
            boolean bl = operationReference instanceof KtSimpleNameExpression;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "This method should be called only for compareTo operations";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, KtTokens.LT)) {
                constantValue = new BooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.LTEQ)) {
                constantValue = new BooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.GT)) {
                constantValue = new BooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.GTEQ)) {
                constantValue = new BooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual(iElementType, KtTokens.IDENTIFIER)) {
                    boolean bl4 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.COMPARE_TO);
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean bl6 = false;
                        String string3 = "This method should be called only for compareTo operations";
                        throw (Throwable)((Object)new AssertionError((Object)string3));
                    }
                    return new IntValue(((Number)result2).intValue());
                }
                throw new IllegalStateException(Intrinsics.stringPlus("Unknown compareTo operation token: ", operationToken));
            }
            return constantValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value2) {
        return value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType;
        ExplicitReceiverKind explicitReceiverKind = resolvedCall2.getExplicitReceiverKind();
        int n = WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()];
        switch (n) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                Intrinsics.checkNotNull(receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
                Intrinsics.checkNotNull(receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 3: {
                kotlinType = null;
                break;
            }
            case 4: {
                kotlinType = null;
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>>> binaryOperation(@NotNull CompileTimeType<A> a, @NotNull CompileTimeType<B> b, @NotNull String functionName, @NotNull Function2<? super A, ? super B, ? extends Object> operation, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(functionName, "functionName");
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(checker, "checker");
        return TuplesKt.to(new BinaryOperationKey<A, B>(a, b, functionName), new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker));
    }

    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<Function1<Object, Object>, Function1<Long, Long>>> unaryOperation(@NotNull CompileTimeType<A> a, @NotNull String functionName, @NotNull Function1<? super A, ? extends Object> operation, @NotNull Function1<? super Long, Long> checker) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(functionName, "functionName");
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(checker, "checker");
        return TuplesKt.to(new UnaryOperationKey<A>(a, functionName), new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, Long>>(operation, checker));
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull ConstantValue<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, "<this>");
        return $this$isStandaloneOnlyConstant instanceof KClassValue || $this$isStandaloneOnlyConstant instanceof EnumValue || $this$isStandaloneOnlyConstant instanceof AnnotationValue || $this$isStandaloneOnlyConstant instanceof ArrayValue;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull CompileTimeConstant<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, "<this>");
        CompileTimeConstant<?> compileTimeConstant = $this$isStandaloneOnlyConstant;
        if (!(compileTimeConstant instanceof TypedCompileTimeConstant)) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(((TypedCompileTimeConstant)$this$isStandaloneOnlyConstant).getConstantValue());
    }

    private static final boolean isZero(Object value2) {
        boolean bl;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value2)) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            bl = ((Number)value2).longValue() == 0L;
        } else {
            bl = value2 instanceof Float || value2 instanceof Double ? ((Number)value2).doubleValue() == 0.0 : false;
        }
        return bl;
    }

    private static final CompileTimeType<? extends Object> typeStrToCompileTimeType(String str) {
        CompileTimeType<Object> compileTimeType;
        String string2 = str;
        if (Intrinsics.areEqual(string2, BYTE.getName())) {
            compileTimeType = BYTE;
        } else if (Intrinsics.areEqual(string2, SHORT.getName())) {
            compileTimeType = SHORT;
        } else if (Intrinsics.areEqual(string2, INT.getName())) {
            compileTimeType = INT;
        } else if (Intrinsics.areEqual(string2, LONG.getName())) {
            compileTimeType = LONG;
        } else if (Intrinsics.areEqual(string2, DOUBLE.getName())) {
            compileTimeType = DOUBLE;
        } else if (Intrinsics.areEqual(string2, FLOAT.getName())) {
            compileTimeType = FLOAT;
        } else if (Intrinsics.areEqual(string2, CHAR.getName())) {
            compileTimeType = CHAR;
        } else if (Intrinsics.areEqual(string2, BOOLEAN.getName())) {
            compileTimeType = BOOLEAN;
        } else if (Intrinsics.areEqual(string2, STRING.getName())) {
            compileTimeType = STRING;
        } else if (Intrinsics.areEqual(string2, ANY.getName())) {
            compileTimeType = ANY;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unsupported type: ", str));
        }
        return compileTimeType;
    }

    @Nullable
    public static final Object evaluateUnary(@NotNull String name, @NotNull String typeStr, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(typeStr, "typeStr");
        Intrinsics.checkNotNullParameter(value2, "value");
        return ConstantExpressionEvaluatorKt.evaluateUnaryAndCheck$default(name, ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(typeStr), value2, null, 8, null);
    }

    private static final Object evaluateUnaryAndCheck(String name, CompileTimeType<?> type2, Object value2, Function0<Unit> tracer) {
        Pair<Function1<Object, Object>, Function1<Long, Long>> pair;
        Pair<Function1<Object, Object>, Function1<Long, Long>> functions2;
        Pair<Function1<Object, Object>, Function1<Long, Long>> pair2 = OperationsMapGeneratedKt.getUnaryOperations().get(new UnaryOperationKey(type2, name));
        if (pair2 == null) {
            return null;
        }
        pair = functions2 = (pair = pair2);
        Function1<Object, Object> function2 = pair.component1();
        Function1<Long, Long> check2 = pair.component2();
        Object result2 = function2.invoke(value2);
        if (Intrinsics.areEqual(check2, OperationsMapGeneratedKt.getEmptyUnaryFun())) {
            return result2;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(value2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ConstantExpressionEvaluatorKt$evaluateUnaryAndCheck$42 = false;
            String $i$a$-assert-ConstantExpressionEvaluatorKt$evaluateUnaryAndCheck$42 = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ConstantExpressionEvaluatorKt$evaluateUnaryAndCheck$42));
        }
        bl = Intrinsics.areEqual(name, "minus") || Intrinsics.areEqual(name, "unaryMinus");
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Only negation should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (Intrinsics.areEqual(value2, result2) && !ConstantExpressionEvaluatorKt.isZero(value2)) {
            tracer.invoke();
        }
        return result2;
    }

    static /* synthetic */ Object evaluateUnaryAndCheck$default(String string2, CompileTimeType compileTimeType, Object object, Function0 function0, int n, Object object2) {
        if ((n & 8) != 0) {
            function0 = evaluateUnaryAndCheck.1.INSTANCE;
        }
        return ConstantExpressionEvaluatorKt.evaluateUnaryAndCheck(string2, compileTimeType, object, function0);
    }

    @Nullable
    public static final Object evaluateBinary(@NotNull String name, @NotNull String receiverTypeStr, @NotNull Object receiverValue, @NotNull String parameterTypeStr, @NotNull Object parameterValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(receiverTypeStr, "receiverTypeStr");
        Intrinsics.checkNotNullParameter(receiverValue, "receiverValue");
        Intrinsics.checkNotNullParameter(parameterTypeStr, "parameterTypeStr");
        Intrinsics.checkNotNullParameter(parameterValue, "parameterValue");
        CompileTimeType<? extends Object> receiverType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(receiverTypeStr);
        CompileTimeType<? extends Object> parameterType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(parameterTypeStr);
        return ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$default(name, receiverType, receiverValue, parameterType, parameterValue, null, 32, null);
    }

    private static final Object evaluateBinaryAndCheck(String name, CompileTimeType<?> receiverType, Object receiverValue, CompileTimeType<?> parameterType, Object parameterValue, Function0<Unit> tracer) {
        Function2 function2;
        Serializable serializable;
        Object object;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> pair;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> functions2;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> pair2 = OperationsMapGeneratedKt.getBinaryOperations().get(new BinaryOperationKey(receiverType, parameterType, name));
        if (pair2 == null) {
            return null;
        }
        pair = functions2 = (pair = pair2);
        Function2<Object, Object, Object> function3 = pair.component1();
        Function2 checker = pair.component2();
        try {
            object = function3.invoke(receiverValue, parameterValue);
        }
        catch (Exception e) {
            object = null;
        }
        Object actualResult = object;
        if (Intrinsics.areEqual(checker, OperationsMapGeneratedKt.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiverValue) && ConstantExpressionEvaluatorKt.isIntegerType(parameterValue);
        boolean e = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (Intrinsics.areEqual(name, OperatorNameConventions.MOD.asString())) {
            HashMap<BinaryOperationKey<?, ?>, Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>>> hashMap = OperationsMapGeneratedKt.getBinaryOperations();
            String string3 = OperatorNameConventions.REM.asString();
            Intrinsics.checkNotNullExpressionValue(string3, "REM.asString()");
            serializable = hashMap.get(new BinaryOperationKey(receiverType, parameterType, string3));
            Function2 function22 = e = serializable == null ? null : (Function2)((Pair)serializable).getSecond();
            if (e == null) {
                return null;
            }
            function2 = e;
        } else {
            function2 = checker;
        }
        Function2 refinedChecker = function2;
        serializable = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(receiverValue);
        Intrinsics.checkNotNullExpressionValue(serializable, "toBigInteger(receiverValue)");
        BigInteger bigInteger = serializable;
        serializable = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(parameterValue);
        Intrinsics.checkNotNullExpressionValue(serializable, "toBigInteger(parameterValue)");
        BigInteger resultInBigIntegers = refinedChecker.invoke((BigInteger)bigInteger, (BigInteger)serializable);
        if (!Intrinsics.areEqual(ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(actualResult), resultInBigIntegers)) {
            tracer.invoke();
        }
        return actualResult;
    }

    static /* synthetic */ Object evaluateBinaryAndCheck$default(String string2, CompileTimeType compileTimeType, Object object, CompileTimeType compileTimeType2, Object object2, Function0 function0, int n, Object object3) {
        if ((n & 0x20) != 0) {
            function0 = evaluateBinaryAndCheck.1.INSTANCE;
        }
        return ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck(string2, compileTimeType, object, compileTimeType2, object2, function0);
    }

    private static final BigInteger evaluateBinaryAndCheck$toBigInteger(Object value2) {
        if (value2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        return BigInteger.valueOf(((Number)value2).longValue());
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result2, operationReference);
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result2, operationReference);
    }

    public static final /* synthetic */ Object access$evaluateUnaryAndCheck(String name, CompileTimeType type2, Object value2, Function0 tracer) {
        return ConstantExpressionEvaluatorKt.evaluateUnaryAndCheck(name, type2, value2, tracer);
    }

    public static final /* synthetic */ Object access$evaluateBinaryAndCheck(String name, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0 tracer) {
        return ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck(name, receiverType, receiverValue, parameterType, parameterValue, tracer);
    }

    public static final /* synthetic */ Set access$getDIVISION_OPERATION_NAMES$p$s-587926820() {
        return DIVISION_OPERATION_NAMES;
    }

    public static final /* synthetic */ boolean access$isZero(Object value2) {
        return ConstantExpressionEvaluatorKt.isZero(value2);
    }

    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(ResolvedCall resolvedCall2) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Name[] nameArray = new Name[]{OperatorNameConventions.DIV, OperatorNameConventions.REM, OperatorNameConventions.MOD};
        Iterable $this$map$iv = CollectionsKt.listOf(nameArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Name name = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = p0.asString();
            collection.add(string2);
        }
        DIVISION_OPERATION_NAMES = CollectionsKt.toSet((List)var3_3);
        BYTE = new CompileTimeType("Byte");
        SHORT = new CompileTimeType("Short");
        INT = new CompileTimeType("Int");
        LONG = new CompileTimeType("Long");
        DOUBLE = new CompileTimeType("Double");
        FLOAT = new CompileTimeType("Float");
        CHAR = new CompileTimeType("Char");
        BOOLEAN = new CompileTimeType("Boolean");
        STRING = new CompileTimeType("String");
        ANY = new CompileTimeType("Any");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 3;
            nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

