/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeStorage;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u001aH\u0002J\u0006\u0010$\u001a\u00020\u001aJ\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020\u0003J\b\u0010)\u001a\u00020*H\u0016R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage;", "parent", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isOwnerDescriptorAccessibleByLabel", "", "redeclarationChecker", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "kind", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZLorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;)V", "canWrite", "implicitReceiver", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getImplicitReceiver", "()Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "()Z", "getKind", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "lastSnapshot", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope$Snapshot;", "getOwnerDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "addClassifierDescriptor", "", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "addFunctionDescriptor", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "addVariableDescriptor", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkMayWrite", "freeze", "printStructure", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "takeSnapshot", "toString", "", "Snapshot", "resolution"})
public final class LexicalWritableScope
extends LexicalScopeStorage {
    @NotNull
    private final DeclarationDescriptor ownerDescriptor;
    private final boolean isOwnerDescriptorAccessibleByLabel;
    @NotNull
    private final LexicalScopeKind kind;
    private boolean canWrite;
    @Nullable
    private Snapshot lastSnapshot;

    public LexicalWritableScope(@NotNull LexicalScope parent2, @NotNull DeclarationDescriptor ownerDescriptor, boolean isOwnerDescriptorAccessibleByLabel, @NotNull LocalRedeclarationChecker redeclarationChecker, @NotNull LexicalScopeKind kind) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(ownerDescriptor, "ownerDescriptor");
        Intrinsics.checkNotNullParameter(redeclarationChecker, "redeclarationChecker");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        super(parent2, redeclarationChecker);
        this.ownerDescriptor = ownerDescriptor;
        this.isOwnerDescriptorAccessibleByLabel = isOwnerDescriptorAccessibleByLabel;
        this.kind = kind;
        this.canWrite = true;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    @Override
    public boolean isOwnerDescriptorAccessibleByLabel() {
        return this.isOwnerDescriptorAccessibleByLabel;
    }

    @Override
    @NotNull
    public LexicalScopeKind getKind() {
        return this.kind;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getImplicitReceiver() {
        return null;
    }

    public final void freeze() {
        this.canWrite = false;
    }

    @NotNull
    public final LexicalScope takeSnapshot() {
        Snapshot snapshot;
        block3: {
            block2: {
                if (this.lastSnapshot == null) break block2;
                snapshot = this.lastSnapshot;
                Intrinsics.checkNotNull(snapshot);
                if (snapshot.getDescriptorLimit() == this.getAddedDescriptors().size()) break block3;
            }
            this.lastSnapshot = new Snapshot(this.getAddedDescriptors().size());
        }
        snapshot = this.lastSnapshot;
        Intrinsics.checkNotNull(snapshot);
        return snapshot;
    }

    public final void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        this.checkMayWrite();
        this.addVariableOrClassDescriptor(variableDescriptor);
    }

    public final void addFunctionDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        this.checkMayWrite();
        this.addFunctionDescriptorInternal(functionDescriptor);
    }

    public final void addClassifierDescriptor(@NotNull ClassifierDescriptor classifierDescriptor) {
        Intrinsics.checkNotNullParameter(classifierDescriptor, "classifierDescriptor");
        this.checkMayWrite();
        this.addVariableOrClassDescriptor(classifierDescriptor);
    }

    private final void checkMayWrite() {
        if (!this.canWrite) {
            throw new IllegalStateException(Intrinsics.stringPlus("Cannot write into freezed scope:", this));
        }
    }

    @NotNull
    public String toString() {
        return this.getKind().toString();
    }

    @Override
    public void printStructure(@NotNull Printer p) {
        ReceiverValue receiverValue;
        Intrinsics.checkNotNullParameter(p, "p");
        Object[] objectArray = new Object[8];
        objectArray[0] = this.getClass().getSimpleName();
        objectArray[1] = ": ";
        objectArray[2] = this.getKind();
        objectArray[3] = "; for descriptor: ";
        objectArray[4] = this.getOwnerDescriptor().getName();
        objectArray[5] = " with implicitReceiver: ";
        ReceiverParameterDescriptor receiverParameterDescriptor = this.getImplicitReceiver();
        objectArray[6] = receiverParameterDescriptor == null ? "NONE" : ((receiverValue = receiverParameterDescriptor.getValue()) == null ? "NONE" : receiverValue);
        objectArray[7] = " {";
        p.println(objectArray);
        p.pushIndent();
        objectArray = new Object[]{"parent = "};
        p.print(objectArray);
        HierarchicalScope hierarchicalScope = this.getParent();
        objectArray = p.withholdIndentOnce();
        Intrinsics.checkNotNullExpressionValue(objectArray, "p.withholdIndentOnce()");
        hierarchicalScope.printStructure((Printer)objectArray);
        p.popIndent();
        objectArray = new Object[]{"}"};
        p.println(objectArray);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J*\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\f0(H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0*2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0019\u00102\u001a\u00020/2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0096\u0001J\b\u00103\u001a\u000204H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope$Snapshot;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "descriptorLimit", "", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;I)V", "getDescriptorLimit", "()I", "implicitReceiver", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getImplicitReceiver", "()Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "isOwnerDescriptorAccessibleByLabel", "", "()Z", "kind", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getOwnerDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "parent", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "definitelyDoesNotContainName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getContributedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getContributedClassifierIncludeDeprecated", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithDeprecation;", "getContributedDescriptors", "", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "getContributedFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContributedVariables", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "printStructure", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "recordLookup", "toString", "", "resolution"})
    private final class Snapshot
    implements LexicalScope {
        private final int descriptorLimit;
        private final /* synthetic */ LexicalWritableScope $$delegate_0;

        public Snapshot(int descriptorLimit) {
            Intrinsics.checkNotNullParameter(LexicalWritableScope.this, "this$0");
            this.descriptorLimit = descriptorLimit;
            this.$$delegate_0 = LexicalWritableScope.this;
        }

        public final int getDescriptorLimit() {
            return this.descriptorLimit;
        }

        @Override
        public boolean definitelyDoesNotContainName(@NotNull Name name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.$$delegate_0.definitelyDoesNotContainName(name);
        }

        @Override
        public void recordLookup(@NotNull Name name, @NotNull LookupLocation location2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location2, "location");
            this.$$delegate_0.recordLookup(name, location2);
        }

        @Override
        @Nullable
        public ReceiverParameterDescriptor getImplicitReceiver() {
            return this.$$delegate_0.getImplicitReceiver();
        }

        @Override
        public boolean isOwnerDescriptorAccessibleByLabel() {
            return this.$$delegate_0.isOwnerDescriptorAccessibleByLabel();
        }

        @Override
        @NotNull
        public LexicalScopeKind getKind() {
            return this.$$delegate_0.getKind();
        }

        @Override
        @NotNull
        public DeclarationDescriptor getOwnerDescriptor() {
            return this.$$delegate_0.getOwnerDescriptor();
        }

        @Override
        @NotNull
        public HierarchicalScope getParent() {
            return this.$$delegate_0.getParent();
        }

        @NotNull
        public List<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
            Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
            Intrinsics.checkNotNullParameter(nameFilter2, "nameFilter");
            return LexicalWritableScope.this.getAddedDescriptors().subList(0, this.descriptorLimit);
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location2, "location");
            DeclarationDescriptor declarationDescriptor = LexicalWritableScope.this.variableOrClassDescriptorByName(name, this.descriptorLimit);
            return declarationDescriptor instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location2) {
            DescriptorWithDeprecation<DeclarationDescriptor> descriptorWithDeprecation;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location2, "location");
            DeclarationDescriptor declarationDescriptor = LexicalWritableScope.this.variableOrClassDescriptorByName(name, this.descriptorLimit);
            if (declarationDescriptor == null) {
                descriptorWithDeprecation = null;
            } else {
                ClassifierDescriptor classifierDescriptor;
                void $this$safeAs$iv;
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                boolean $i$f$safeAs = false;
                Object v1 = $this$safeAs$iv;
                if (!(v1 instanceof ClassifierDescriptor)) {
                    v1 = null;
                }
                if ((classifierDescriptor = (ClassifierDescriptor)v1) == null) {
                    descriptorWithDeprecation = null;
                } else {
                    declarationDescriptor2 = classifierDescriptor;
                    boolean bl = false;
                    boolean bl2 = false;
                    DeclarationDescriptor it = declarationDescriptor2;
                    boolean bl3 = false;
                    descriptorWithDeprecation = DescriptorWithDeprecation.Companion.createNonDeprecated(it);
                }
            }
            return descriptorWithDeprecation;
        }

        @NotNull
        public List<VariableDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location2, "location");
            DeclarationDescriptor declarationDescriptor = LexicalWritableScope.this.variableOrClassDescriptorByName(name, this.descriptorLimit);
            return CollectionsKt.listOfNotNull(declarationDescriptor instanceof VariableDescriptor ? (VariableDescriptor)declarationDescriptor : null);
        }

        @NotNull
        public List<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location2, "location");
            return LexicalWritableScope.this.functionsByName(name, this.descriptorLimit);
        }

        @NotNull
        public String toString() {
            return "Snapshot(" + this.descriptorLimit + ") for " + (Object)((Object)this.getKind());
        }

        @Override
        public void printStructure(@NotNull Printer p) {
            Intrinsics.checkNotNullParameter(p, "p");
            Object[] objectArray = new Object[]{"Snapshot with descriptorLimit = " + this.descriptorLimit + " for scope:"};
            p.println(objectArray);
            LexicalWritableScope.this.printStructure(p);
        }
    }
}

