/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.JobQueue;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    private final List<MessageBusImpl> childBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor;

    protected CompositeMessageBus(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            CompositeMessageBus.$$$reportNull$$$0(2);
        }
        super(owner);
        this.childBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.topicClassToListenerDescriptor = Collections.emptyMap();
    }

    @Override
    protected final boolean hasChildren() {
        return !this.childBuses.isEmpty();
    }

    final void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        if (childBus == null) {
            CompositeMessageBus.$$$reportNull$$$0(6);
        }
        boolean removed2 = this.childBuses.remove(childBus);
        this.myRootBus.myWaitingBuses.get().remove(childBus);
        CompositeMessageBus parentBus = this;
        do {
            parentBus.subscriberCache.clear();
        } while ((parentBus = parentBus.myParentBus) != null);
        LOG.assertTrue(removed2);
    }

    @Override
    @NotNull
    protected final MessageBusImpl.MessagePublisher createPublisher(@NotNull Topic<?> topic, Topic.BroadcastDirection direction) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(7);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new MessageBusImpl.ToParentMessagePublisher(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            if (this.myParentBus != null) {
                throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
            }
            return new ToDirectChildrenMessagePublisher(topic, this);
        }
        return new MessageBusImpl.MessagePublisher(topic, this);
    }

    @Override
    @NotNull
    protected final List<Object> computeSubscribers(@NotNull Topic<?> topic) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(8);
        }
        if (this.owner.isDisposed()) {
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                CompositeMessageBus.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<Object> list3 = super.computeSubscribers(topic);
        if (list3 == null) {
            CompositeMessageBus.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @Override
    protected final void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result2, boolean subscribeLazyListeners) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            CompositeMessageBus.$$$reportNull$$$0(12);
        }
        if (subscribeLazyListeners) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers(topic, result2, subscribeLazyListeners);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers(topic, result2, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private void subscribeLazyListeners(@NotNull Topic<?> topic) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(13);
        }
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        List<ListenerDescriptor> listenerDescriptors = this.topicClassToListenerDescriptor.remove(topic.getListenerClass().getName());
        if (listenerDescriptors == null) {
            return;
        }
        LinkedHashMap<PluginId, List> listenerMap = new LinkedHashMap<PluginId, List>();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor.getPluginId(), __ -> new ArrayList()).add(this.owner.createListener(listenerDescriptor));
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((key, listeners) -> this.mySubscribers.add(new DescriptorBasedMessageBusConnection((PluginId)key, topic, (List<Object>)listeners)));
    }

    @Override
    protected final void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(14);
        }
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    @Override
    final boolean notifyConnectionTerminated(Object[] topicAndHandlerPairs) {
        boolean isChildClearingNeeded = super.notifyConnectionTerminated(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCache(topicAndHandlerPairs));
        SortedSet<MessageBusImpl> waitingBuses = this.myRootBus.myWaitingBuses.get();
        if (!waitingBuses.isEmpty()) {
            waitingBuses.removeIf(bus -> {
                JobQueue jobQueue = bus.myMessageQueue.get();
                return !jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> MessageBusConnectionImpl.removeHandlersFromJob(job, topicAndHandlerPairs) && job.handlers.isEmpty()) && jobQueue.current == null && jobQueue.queue.isEmpty();
            });
        }
        return false;
    }

    @Override
    protected final void clearSubscriberCache(Object[] topicAndHandlerPairs) {
        super.clearSubscriberCache(topicAndHandlerPairs);
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCache(topicAndHandlerPairs));
    }

    @Override
    protected final void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        this.childBuses.forEach(MessageBusImpl::removeEmptyConnectionsRecursively);
    }

    @Override
    protected final void disposeChildren() {
        this.childBuses.forEach(Disposer::dispose);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/CompositeMessageBus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBus";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerDescriptors";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/CompositeMessageBus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addChild";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLazyListeners";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusDisposed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "subscribeLazyListeners";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeChildConnectionsRecursively";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unsubscribeLazyListeners";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ToDirectChildrenMessagePublisher
    extends MessageBusImpl.MessagePublisher
    implements InvocationHandler {
        ToDirectChildrenMessagePublisher(@NotNull Topic<?> topic, @NotNull CompositeMessageBus bus) {
            if (topic == null) {
                ToDirectChildrenMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToDirectChildrenMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        protected final boolean publish(@NotNull Method method, Object[] args2, @Nullable JobQueue jobQueue) {
            if (method == null) {
                ToDirectChildrenMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            boolean hasHandlers = false;
            List handlers2 = this.bus.subscriberCache.computeIfAbsent(this.topic, this.bus::computeSubscribers);
            if (!handlers2.isEmpty()) {
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args2, handlers2, jobQueue, this.bus.messageDeliveryListener, null);
                hasHandlers = true;
            }
            for (MessageBusImpl childBus : ((CompositeMessageBus)this.bus).childBuses) {
                if (childBus.owner.isDisposed() || (handlers2 = childBus.subscriberCache.computeIfAbsent(this.topic, topic1 -> {
                    ArrayList<Object> result2 = new ArrayList<Object>();
                    childBus.doComputeSubscribers((Topic<?>)topic1, (List<Object>)result2, !childBus.owner.isParentLazyListenersIgnored());
                    return result2.isEmpty() ? Collections.emptyList() : result2;
                })).isEmpty()) continue;
                hasHandlers = true;
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args2, handlers2, jobQueue, this.bus.messageDeliveryListener, exceptions);
            }
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/messages/impl/CompositeMessageBus$ToDirectChildrenMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

