/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaResolverCache;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDescriptorResolver {
    @NotNull
    private final LazyJavaPackageFragmentProvider packageFragmentProvider;
    @NotNull
    private final JavaResolverCache javaResolverCache;

    public JavaDescriptorResolver(@NotNull LazyJavaPackageFragmentProvider packageFragmentProvider, @NotNull JavaResolverCache javaResolverCache) {
        Intrinsics.checkNotNullParameter(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkNotNullParameter(javaResolverCache, "javaResolverCache");
        this.packageFragmentProvider = packageFragmentProvider;
        this.javaResolverCache = javaResolverCache;
    }

    @NotNull
    public final LazyJavaPackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    @Nullable
    public final ClassDescriptor resolveClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        FqName fqName2 = javaClass.getFqName();
        if (fqName2 != null && javaClass.getLightClassOriginKind() == LightClassOriginKind.SOURCE) {
            return this.javaResolverCache.getClassResolvedFromSource(fqName2);
        }
        Object object = javaClass.getOuterClass();
        if (object != null) {
            MemberScope outerClassScope;
            JavaClass javaClass2 = object;
            boolean bl = false;
            boolean bl2 = false;
            JavaClass outerClass2 = javaClass2;
            boolean bl3 = false;
            ClassDescriptor classDescriptor = this.resolveClass(outerClass2);
            MemberScope memberScope2 = outerClassScope = classDescriptor == null ? null : classDescriptor.getUnsubstitutedInnerClassesScope();
            classDescriptor = memberScope2 == null ? null : memberScope2.getContributedClassifier(javaClass.getName(), NoLookupLocation.FROM_JAVA_LOADER);
            return classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
        }
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        object = CollectionsKt.firstOrNull(this.packageFragmentProvider.getPackageFragments(fqName3));
        return object == null ? null : ((LazyJavaPackageFragment)object).findClassifierByJavaClass$descriptors_jvm(javaClass);
    }
}

