/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTypeCheckerContext {
    private int argumentsDepth;
    private boolean supertypesLocked;
    @Nullable
    private ArrayDeque<SimpleTypeMarker> supertypesDeque;
    @Nullable
    private Set<SimpleTypeMarker> supertypesSet;

    @NotNull
    public abstract TypeSystemContext getTypeSystemContext();

    @NotNull
    public abstract SupertypesPolicy substitutionSupertypePolicy(@NotNull SimpleTypeMarker var1);

    @NotNull
    public KotlinTypeMarker refineType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return type2;
    }

    @NotNull
    public KotlinTypeMarker prepareType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return type2;
    }

    public boolean customIsSubtypeOf(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2) {
        Intrinsics.checkNotNullParameter(subType, "subType");
        Intrinsics.checkNotNullParameter(superType2, "superType");
        return true;
    }

    public abstract boolean isErrorTypeEqualsToAnything();

    public abstract boolean isStubTypeEqualsToAnything();

    @NotNull
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(@NotNull SimpleTypeMarker subType, @NotNull CapturedTypeMarker superType2) {
        Intrinsics.checkNotNullParameter(subType, "subType");
        Intrinsics.checkNotNullParameter(superType2, "superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    @Nullable
    public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2, boolean isFromNullabilityConstraint) {
        Intrinsics.checkNotNullParameter(subType, "subType");
        Intrinsics.checkNotNullParameter(superType2, "superType");
        return null;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(AbstractTypeCheckerContext abstractTypeCheckerContext, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return abstractTypeCheckerContext.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
    }

    @Nullable
    public final ArrayDeque<SimpleTypeMarker> getSupertypesDeque() {
        return this.supertypesDeque;
    }

    @Nullable
    public final Set<SimpleTypeMarker> getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl = !this.supertypesLocked;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Supertypes were locked for ", Reflection.getOrCreateKotlinClass(this.getClass()));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    public final void clear() {
        ArrayDeque<SimpleTypeMarker> arrayDeque = this.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set<SimpleTypeMarker> set = this.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        this.supertypesLocked = false;
    }

    public abstract boolean isAllowedTypeVariable(@NotNull KotlinTypeMarker var1);

    @JvmName(name="isAllowedTypeVariableBridge")
    public final boolean isAllowedTypeVariableBridge(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.isAllowedTypeVariable(type2);
    }

    public static final /* synthetic */ int access$getArgumentsDepth(AbstractTypeCheckerContext $this) {
        return $this.argumentsDepth;
    }

    public static final /* synthetic */ void access$setArgumentsDepth(AbstractTypeCheckerContext $this, int n) {
        $this.argumentsDepth = n;
    }

    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER = new LowerCapturedTypePolicy();
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String value2) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, value2);
        }

        static {
            $VALUES = lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[]{LowerCapturedTypePolicy.CHECK_ONLY_LOWER, LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER, LowerCapturedTypePolicy.SKIP_LOWER};
        }
    }

    public static abstract class SupertypesPolicy {
        private SupertypesPolicy() {
        }

        @NotNull
        public abstract SimpleTypeMarker transformType(@NotNull AbstractTypeCheckerContext var1, @NotNull KotlinTypeMarker var2);

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class None
        extends SupertypesPolicy {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            @NotNull
            public Void transformType(@NotNull AbstractTypeCheckerContext context2, @NotNull KotlinTypeMarker type2) {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(type2, "type");
                throw new UnsupportedOperationException("Should not be called");
            }
        }

        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            @NotNull
            public static final UpperIfFlexible INSTANCE = new UpperIfFlexible();

            private UpperIfFlexible() {
                super(null);
            }

            @Override
            @NotNull
            public SimpleTypeMarker transformType(@NotNull AbstractTypeCheckerContext context2, @NotNull KotlinTypeMarker type2) {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(type2, "type");
                TypeSystemContext typeSystemContext = context2.getTypeSystemContext();
                boolean bl = false;
                boolean bl2 = false;
                TypeSystemContext $this$transformType_u24lambda_u2d0 = typeSystemContext;
                boolean bl3 = false;
                return $this$transformType_u24lambda_u2d0.upperBoundIfFlexible(type2);
            }
        }

        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            @NotNull
            public static final LowerIfFlexible INSTANCE = new LowerIfFlexible();

            private LowerIfFlexible() {
                super(null);
            }

            @Override
            @NotNull
            public SimpleTypeMarker transformType(@NotNull AbstractTypeCheckerContext context2, @NotNull KotlinTypeMarker type2) {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(type2, "type");
                TypeSystemContext typeSystemContext = context2.getTypeSystemContext();
                boolean bl = false;
                boolean bl2 = false;
                TypeSystemContext $this$transformType_u24lambda_u2d0 = typeSystemContext;
                boolean bl3 = false;
                return $this$transformType_u24lambda_u2d0.lowerBoundIfFlexible(type2);
            }
        }

        public static abstract class DoCustomTransform
        extends SupertypesPolicy {
            public DoCustomTransform() {
                super(null);
            }
        }
    }
}

