/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.expression.StringTemplateTranslator;
import org.jetbrains.kotlin.js.translate.expression.TryTranslator;
import org.jetbrains.kotlin.js.translate.expression.WhenTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.js.translate.utils.mutator.CoercionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    private static final FqName primitiveClassesFqName = new FqName("kotlin.reflect.js.internal.PrimitiveClasses");

    @Override
    protected JsNode emptyResult(@NotNull TranslationContext context2) {
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(0);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(0);
        }
        return new JsNullLiteral();
    }

    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull KtConstantExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(1);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(2);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(2);
        }
        JsNode jsNode = ExpressionVisitor.translateConstantExpression(expression2, context2).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(3);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(3);
        }
        return jsNode;
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull KtConstantExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(4);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(5);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(5);
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context2.bindingContext());
        assert (compileTimeValue != null) : ErrorReportingUtils.message(expression2, "Expression is not compile time value: " + expression2.getText() + " ");
        JsExpression result2 = Translation.translateConstant(compileTimeValue, expression2, context2);
        if (result2 == null) {
            throw new AssertionError((Object)ErrorReportingUtils.message(expression2, "Unsupported constant expression: " + expression2.getText() + " "));
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(6);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(6);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull KtBlockExpression jetBlock, @NotNull TranslationContext context2) {
        if (jetBlock == null) {
            ExpressionVisitor.$$$reportNull$$$1(7);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(8);
        }
        if (jetBlock == null) {
            ExpressionVisitor.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(8);
        }
        List<KtExpression> statements2 = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        for (KtExpression statement2 : statements2) {
            JsNode jsNode = Translation.translateExpression(statement2, context2, jsBlock);
            JsStatement jsStatement = JsAstUtils.convertToStatement(jsNode);
            if (JsAstUtils.isEmptyStatement(jsStatement)) continue;
            jsBlock.getStatements().add(jsStatement);
        }
        if (statements2.isEmpty()) {
            ClassDescriptor unitClass = context2.getCurrentModule().getBuiltIns().getUnit();
            jsBlock.getStatements().add(JsAstUtils.asSyntheticStatement(ReferenceTranslator.translateAsValueReference(unitClass, context2)));
        }
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(9);
        }
        if (jsBlock2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(9);
        }
        return jsBlock2;
    }

    @Override
    public JsNode visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull TranslationContext context2) {
        if (multiDeclaration == null) {
            ExpressionVisitor.$$$reportNull$$$1(10);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(11);
        }
        if (multiDeclaration == null) {
            ExpressionVisitor.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(11);
        }
        KtExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer2 = Translation.translateAsExpression(jetInitializer, context2);
        JsName parameterName = JsScope.declareTemporary();
        JsVars tempVarDeclaration = JsAstUtils.newVar(parameterName, initializer2);
        MetadataProperties.setSynthetic(tempVarDeclaration, true);
        context2.addStatementToCurrentBlock(tempVarDeclaration);
        return DestructuringDeclarationTranslator.translate(multiDeclaration, JsAstUtils.pureFqn(parameterName, null), context2);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull KtReturnExpression jetReturnExpression, @NotNull TranslationContext context2) {
        JsReturn jsReturn;
        if (jetReturnExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(12);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(13);
        }
        if (jetReturnExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(12);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(13);
        }
        KtExpression returned = jetReturnExpression.getReturnedExpression();
        KtDeclarationWithBody parent2 = PsiTreeUtil.getParentOfType((PsiElement)jetReturnExpression, KtDeclarationWithBody.class);
        if (parent2 instanceof KtSecondaryConstructor) {
            ClassDescriptor classDescriptor = context2.getClassDescriptor();
            assert (classDescriptor != null) : "Missing class descriptor in context while translating constructor: " + PsiUtilsKt.getTextWithLocation(jetReturnExpression);
            JsExpression ref = ReferenceTranslator.translateAsValueReference(classDescriptor.getThisAsReceiverParameter(), context2);
            return new JsReturn(ref.source(jetReturnExpression));
        }
        FunctionDescriptor returnTarget = ExpressionVisitor.getNonLocalReturnTarget(jetReturnExpression, context2);
        if (returned == null) {
            jsReturn = new JsReturn(null);
        } else {
            JsExpression jsReturnExpression = Translation.translateAsExpression(returned, context2);
            KotlinType returnedType = context2.bindingContext().getType(returned);
            assert (returnedType != null) : "Resolved return expression is expected to have type: " + PsiUtilsKt.getTextWithLocation(jetReturnExpression);
            CallableDescriptor returnTargetOrCurrentFunction = returnTarget;
            if (returnTargetOrCurrentFunction == null) {
                returnTargetOrCurrentFunction = (CallableDescriptor)context2.getDeclarationDescriptor();
            }
            if (returnTargetOrCurrentFunction != null) {
                jsReturnExpression = TranslationUtils.coerce(context2, jsReturnExpression, TranslationUtils.getReturnTypeForCoercion(returnTargetOrCurrentFunction));
            }
            jsReturn = new JsReturn(jsReturnExpression);
        }
        MetadataProperties.setReturnTarget(jsReturn, returnTarget);
        JsNode jsNode = jsReturn.source(jetReturnExpression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(14);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(14);
        }
        return jsNode;
    }

    @Nullable
    private static FunctionDescriptor getNonLocalReturnTarget(@NotNull KtReturnExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(15);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(16);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(16);
        }
        DeclarationDescriptor descriptor2 = context2.getDeclarationDescriptor();
        assert (descriptor2 instanceof CallableMemberDescriptor) : "Return expression can only be inside callable declaration: " + PsiUtilsKt.getTextWithLocation(expression2);
        KtSimpleNameExpression target = expression2.getTargetLabel();
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (target == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    return BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                }
            } else {
                PsiElement element = context2.bindingContext().get(BindingContext.LABEL_TARGET, target);
                descriptor2 = context2.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            }
        }
        assert (descriptor2 == null || descriptor2 instanceof FunctionDescriptor) : "Function descriptor expected to be target of return label: " + PsiUtilsKt.getTextWithLocation(expression2);
        return (FunctionDescriptor)descriptor2;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull TranslationContext context2) {
        KtExpression expressionInside;
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(17);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(18);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(18);
        }
        if ((expressionInside = expression2.getExpression()) != null) {
            JsNode jsNode = Translation.translateExpression(expressionInside, context2);
            if (jsNode == null) {
                ExpressionVisitor.$$$reportNull$$$0(19);
            }
            if (jsNode == null) {
                ExpressionVisitor.$$$reportNull$$$1(19);
            }
            return jsNode;
        }
        JsEmpty jsEmpty = JsEmpty.INSTANCE;
        if (jsEmpty == null) {
            ExpressionVisitor.$$$reportNull$$$0(20);
        }
        if (jsEmpty == null) {
            ExpressionVisitor.$$$reportNull$$$1(20);
        }
        return jsEmpty;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(21);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(22);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(22);
        }
        JsExpression jsExpression = BinaryOperationTranslator.translate(expression2, context2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(23);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(23);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull KtProperty expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(24);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(25);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(25);
        }
        VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(context2.bindingContext(), BindingContext.VARIABLE, expression2);
        JsExpression initializer2 = TranslationUtils.translateInitializerForProperty(expression2, context2);
        KtExpression delegateExpression2 = expression2.getDelegateExpression();
        JsName name = context2.getNameForDescriptor(descriptor2);
        if (delegateExpression2 != null) {
            initializer2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context2, expression2);
            assert (initializer2 != null) : "Initializer must be non-null for property with delegate";
        } else if (context2.isBoxedLocalCapturedInClosure(descriptor2)) {
            JsNameRef alias = Namer.getCapturedVarAccessor(name.makeRef());
            initializer2 = JsAstUtils.wrapValue(alias, initializer2 == null ? new JsNullLiteral() : initializer2);
        }
        JsNode jsNode = JsAstUtils.newVar(name, initializer2).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(26);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(26);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(27);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(28);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(27);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(28);
        }
        JsExpression jsExpression = CallableReferenceTranslator.INSTANCE.translate(expression2, context2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(29);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(29);
        }
        return jsExpression;
    }

    @Override
    public JsNode visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(30);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(30);
        }
        KtExpression receiverExpression = expression2.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = context2.bindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        ClassifierDescriptor descriptor2 = lhs.getType().getConstructor().getDeclarationDescriptor();
        if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
            JsExpression primitiveExpression;
            JsExpression receiver = Translation.translateAsExpression(receiverExpression, context2);
            receiver = TranslationUtils.coerce(context2, receiver, context2.getCurrentModule().getBuiltIns().getAnyType());
            if (ExpressionVisitor.isPrimitiveClassLiteral(lhs.getType()) && (primitiveExpression = ExpressionVisitor.getPrimitiveClass(context2, descriptor2)) != null) {
                return JsAstUtils.newSequence(Arrays.asList(receiver, primitiveExpression));
            }
            return new JsInvocation((JsExpression)context2.namer().kotlin("getKClassFromExpression"), receiver);
        }
        return ExpressionVisitor.getObjectKClass(context2, descriptor2);
    }

    @NotNull
    public static JsExpression getObjectKClass(@NotNull TranslationContext context2, @Nullable ClassifierDescriptor descriptor2) {
        JsExpression primitiveExpression;
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(31);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(31);
        }
        if ((primitiveExpression = ExpressionVisitor.getPrimitiveClass(context2, descriptor2)) != null) {
            JsExpression jsExpression = primitiveExpression;
            if (jsExpression == null) {
                ExpressionVisitor.$$$reportNull$$$0(32);
            }
            if (jsExpression == null) {
                ExpressionVisitor.$$$reportNull$$$1(32);
            }
            return jsExpression;
        }
        JsName kClassName = context2.getNameForIntrinsic(SpecialFunction.GET_KCLASS.getSuggestedName());
        MetadataProperties.setSpecialFunction(kClassName, SpecialFunction.GET_KCLASS);
        return new JsInvocation((JsExpression)kClassName.makeRef(), UtilsKt.getReferenceToJsClass(descriptor2, context2));
    }

    @Nullable
    public static JsExpression getPrimitiveClass(@NotNull TranslationContext context2, @Nullable ClassifierDescriptor classifierDescriptor) {
        FunctionClassDescriptor functionClassDescriptor;
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(33);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(33);
        }
        if (!context2.getConfig().isAtLeast(LanguageVersion.KOTLIN_1_2) || ExpressionVisitor.findPrimitiveClassesObject(context2) == null) {
            return null;
        }
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        ClassDescriptor descriptor2 = (ClassDescriptor)classifierDescriptor;
        FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(descriptor2);
        switch (fqName2.asString()) {
            case "kotlin.Boolean": 
            case "kotlin.Byte": 
            case "kotlin.Short": 
            case "kotlin.Int": 
            case "kotlin.Float": 
            case "kotlin.Double": 
            case "kotlin.String": 
            case "kotlin.Array": 
            case "kotlin.Any": 
            case "kotlin.Throwable": 
            case "kotlin.Number": 
            case "kotlin.Nothing": 
            case "kotlin.BooleanArray": 
            case "kotlin.CharArray": 
            case "kotlin.ByteArray": 
            case "kotlin.ShortArray": 
            case "kotlin.IntArray": 
            case "kotlin.LongArray": 
            case "kotlin.FloatArray": 
            case "kotlin.DoubleArray": {
                return ExpressionVisitor.getKotlinPrimitiveClassRef(context2, StringUtil.decapitalize(fqName2.shortName().asString()) + "Class");
            }
        }
        if (descriptor2 instanceof FunctionClassDescriptor && (functionClassDescriptor = (FunctionClassDescriptor)descriptor2).getFunctionKind() == FunctionClassKind.Function) {
            ClassDescriptor primitivesObject = ExpressionVisitor.findPrimitiveClassesObject(context2);
            assert (primitivesObject != null);
            FunctionDescriptor function2 = DescriptorUtils.getFunctionByName(primitivesObject.getUnsubstitutedMemberScope(), Name.identifier("functionClass"));
            JsNameRef functionRef = JsAstUtils.pureFqn(context2.getInlineableInnerNameForDescriptor(function2), null);
            return new JsInvocation((JsExpression)functionRef, new JsIntLiteral(functionClassDescriptor.getArity()));
        }
        return null;
    }

    @NotNull
    private static JsExpression getKotlinPrimitiveClassRef(@NotNull TranslationContext context2, @NotNull String name) {
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(34);
        }
        if (name == null) {
            ExpressionVisitor.$$$reportNull$$$1(35);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(34);
        }
        if (name == null) {
            ExpressionVisitor.$$$reportNull$$$0(35);
        }
        ClassDescriptor primitivesObject = ExpressionVisitor.findPrimitiveClassesObject(context2);
        assert (primitivesObject != null);
        PropertyDescriptor property2 = DescriptorUtils.getPropertyByName(primitivesObject.getUnsubstitutedMemberScope(), Name.identifier(name));
        JsNameRef jsNameRef = JsAstUtils.pureFqn(context2.getInlineableInnerNameForDescriptor(property2), null);
        if (jsNameRef == null) {
            ExpressionVisitor.$$$reportNull$$$0(36);
        }
        if (jsNameRef == null) {
            ExpressionVisitor.$$$reportNull$$$1(36);
        }
        return jsNameRef;
    }

    private static boolean isPrimitiveClassLiteral(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(37);
        }
        if (type2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(37);
        }
        return KotlinBuiltIns.isPrimitiveType(type2) || KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
    }

    @Nullable
    private static ClassDescriptor findPrimitiveClassesObject(@NotNull TranslationContext context2) {
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(38);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(38);
        }
        return FindClassInModuleKt.findClassAcrossModuleDependencies(context2.getCurrentModule(), ClassId.topLevel(primitiveClassesFqName));
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull KtCallExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(39);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(40);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(39);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(40);
        }
        JsNode jsNode = CallExpressionTranslator.translate(expression2, null, context2).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(41);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(41);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull KtIfExpression expression2, @NotNull TranslationContext context2) {
        JsStatement elseStatement;
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(42);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(43);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(42);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(43);
        }
        assert (expression2.getCondition() != null) : "condition should not ne null: " + expression2.getText();
        JsExpression testExpression = Translation.translateAsExpression(expression2.getCondition(), context2);
        KotlinType type2 = context2.bindingContext().getType(expression2);
        boolean isKotlinExpression = BindingContextUtilsKt.isUsedAsExpression(expression2, context2.bindingContext());
        KtExpression thenExpression = expression2.getThen();
        KtExpression elseExpression = expression2.getElse();
        JsStatement thenStatement = thenExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(thenExpression, context2) : null;
        JsStatement jsStatement = elseStatement = elseExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(elseExpression, context2) : null;
        if (type2 != null) {
            if (thenStatement != null) {
                thenStatement = LastExpressionMutator.mutateLastExpression(thenStatement, new CoercionMutator(type2, context2));
            }
            if (elseStatement != null) {
                elseStatement = LastExpressionMutator.mutateLastExpression(elseStatement, new CoercionMutator(type2, context2));
            }
        }
        if (isKotlinExpression) {
            boolean canBeJsExpression;
            JsExpression jsThenExpression = JsAstUtils.extractExpressionFromStatement(thenStatement);
            JsExpression jsElseExpression = JsAstUtils.extractExpressionFromStatement(elseStatement);
            boolean bl = canBeJsExpression = jsThenExpression != null && jsElseExpression != null;
            if (canBeJsExpression) {
                JsExpression jsExpression = new JsConditional(testExpression, jsThenExpression, jsElseExpression).source(expression2);
                if (jsExpression == null) {
                    ExpressionVisitor.$$$reportNull$$$0(44);
                }
                if (jsExpression == null) {
                    ExpressionVisitor.$$$reportNull$$$1(44);
                }
                return jsExpression;
            }
        }
        if (thenStatement == null) {
            thenStatement = JsEmpty.INSTANCE;
        }
        JsIf ifStatement = new JsIf(testExpression, thenStatement, elseStatement);
        JsNode jsNode = ifStatement.source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(45);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(45);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(46);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(47);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(46);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(47);
        }
        JsExpression jsExpression = ReferenceTranslator.translateSimpleName(expression2, context2).source(expression2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(48);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(48);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull KtWhileExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(49);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(50);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(49);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(50);
        }
        JsNode jsNode = LoopTranslator.createWhile(false, expression2, context2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(51);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(51);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(52);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(53);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(52);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(53);
        }
        JsNode jsNode = LoopTranslator.createWhile(true, expression2, context2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(54);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(54);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context2) {
        JsStringLiteral stringLiteral;
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(55);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(56);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(55);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(56);
        }
        if ((stringLiteral = ExpressionVisitor.resolveAsStringConstant(expression2, context2)) != null) {
            JsExpression jsExpression = stringLiteral.source(expression2);
            if (jsExpression == null) {
                ExpressionVisitor.$$$reportNull$$$0(57);
            }
            if (jsExpression == null) {
                ExpressionVisitor.$$$reportNull$$$1(57);
            }
            return jsExpression;
        }
        JsNode jsNode = ExpressionVisitor.resolveAsTemplate(expression2, context2).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(58);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(58);
        }
        return jsNode;
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(59);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(60);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(59);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(60);
        }
        JsExpression jsExpression = StringTemplateTranslator.translate(expression2, context2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(61);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(61);
        }
        return jsExpression;
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull KtExpression expression2, @NotNull TranslationContext context2) {
        Object value2;
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(62);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(63);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(62);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(63);
        }
        if ((value2 = BindingUtils.getCompileTimeValue(context2.bindingContext(), expression2)) == null) {
            return null;
        }
        assert (value2 instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value2;
        return new JsStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(64);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(65);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(64);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(65);
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression2, context2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(66);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(66);
        }
        return jsNode;
    }

    @Override
    public JsNode visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(67);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(68);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(67);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(68);
        }
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, context2.bindingContext())) {
            return Translation.translateAsExpression(baseExpression, context2).source(expression2);
        }
        JsScope scope2 = context2.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsFunctionScope functionScope = (JsFunctionScope)scope2;
        String labelIdent = ExpressionVisitor.getReferencedName(expression2.getTargetLabel());
        JsName labelName = functionScope.enterLabel(labelIdent, NameSuggestion.sanitizeName(labelIdent));
        JsStatement baseStatement = Translation.translateAsStatement(baseExpression, context2);
        functionScope.exitLabel();
        return new JsLabel(labelName, baseStatement).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull KtPrefixExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(69);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(70);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(69);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(70);
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression2, context2).source(expression2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(71);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(71);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull KtPostfixExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(72);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(73);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(72);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(73);
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression2, context2).source(expression2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(74);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(74);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull KtIsExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(75);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(76);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(75);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(76);
        }
        JsExpression jsExpression = Translation.patternTranslator(context2).translateIsExpression(expression2).source(expression2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(77);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(77);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(78);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(79);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(78);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(79);
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression2, context2).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(80);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(80);
        }
        return jsNode;
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(81);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(82);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(81);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(82);
        }
        return WhenTranslator.translate(expression2, context2);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(83);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(84);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(83);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(84);
        }
        JsExpression jsExpression = PatternTranslator.isCastExpression(expression2) ? PatternTranslator.newInstance(context2).translateCastExpression(expression2) : Translation.translateAsExpression(expression2.getLeft(), context2);
        JsExpression jsExpression2 = jsExpression.source(expression2);
        if (jsExpression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(85);
        }
        if (jsExpression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(85);
        }
        return jsExpression2;
    }

    private static String getReferencedName(KtSimpleNameExpression expression2) {
        return expression2.getReferencedName().replaceAll("^@", "").replaceAll("(?:^`(.*)`$)", "$1");
    }

    private static JsNameRef getTargetLabel(KtExpressionWithLabel expression2, TranslationContext context2) {
        KtSimpleNameExpression labelElement = expression2.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        String labelIdent = ExpressionVisitor.getReferencedName(labelElement);
        JsScope scope2 = context2.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsName labelName = ((JsFunctionScope)scope2).findLabel(labelIdent);
        assert (labelName != null);
        return labelName.makeRef();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull KtBreakExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(86);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(87);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(86);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(87);
        }
        JsNode jsNode = new JsBreak(ExpressionVisitor.getTargetLabel(expression2, context2)).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(88);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(88);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull KtContinueExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(89);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(90);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(89);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(90);
        }
        JsNode jsNode = new JsContinue(ExpressionVisitor.getTargetLabel(expression2, context2)).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(91);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(91);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(92);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(93);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(92);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(93);
        }
        JsExpression jsExpression = new LiteralFunctionTranslator(context2).translate(expression2.getFunctionLiteral()).source(expression2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(94);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(94);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull KtNamedFunction expression2, @NotNull TranslationContext context2) {
        boolean isExpression;
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(95);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(96);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(95);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(96);
        }
        JsExpression alias = new LiteralFunctionTranslator(context2).translate(expression2);
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context2.bindingContext(), expression2);
        JsNameRef nameRef = (JsNameRef)ReferenceTranslator.translateAsValueReference(descriptor2, context2);
        assert (nameRef.getName() != null);
        if (InlineUtil.isInline(descriptor2)) {
            MetadataProperties.setStaticRef(nameRef.getName(), alias);
        }
        JsExpression result2 = (isExpression = BindingContextUtilsKt.isUsedAsExpression(expression2, context2.bindingContext())) ? alias : JsAstUtils.newVar(nameRef.getName(), alias);
        JsNode jsNode = result2.source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(97);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(97);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull KtThisExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(98);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(99);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(98);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(99);
        }
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression2.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression2.getText();
        JsExpression jsExpression = context2.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(thisExpression)).source(expression2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(100);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(100);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(101);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(102);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(101);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(102);
        }
        JsExpression jsExpression = AccessTranslationUtils.translateAsGet(expression2, context2);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(103);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(103);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull KtSuperExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(104);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(105);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(104);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(105);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, context2.bindingContext());
        JsExpression jsExpression = context2.getDispatchReceiver((ReceiverParameterDescriptor)resolvedCall2.getResultingDescriptor());
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(106);
        }
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$1(106);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(107);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(108);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(107);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(108);
        }
        JsNode jsNode = LoopTranslator.translateForExpression(expression2, context2).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(109);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(109);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull KtTryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(110);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(111);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(110);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(111);
        }
        JsTry jsTry = new TryTranslator(expression2, context2).translate();
        if (jsTry == null) {
            ExpressionVisitor.$$$reportNull$$$0(112);
        }
        if (jsTry == null) {
            ExpressionVisitor.$$$reportNull$$$1(112);
        }
        return jsTry;
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull KtThrowExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(113);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(114);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(113);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(114);
        }
        KtExpression thrownExpression = expression2.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        JsNode jsNode = new JsThrow(Translation.translateAsExpression(thrownExpression, context2)).source(expression2);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(115);
        }
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$1(115);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, @NotNull TranslationContext context2) {
        ResolvedCall<FunctionDescriptor> superCall2;
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(116);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(117);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(116);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(117);
        }
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context2.bindingContext(), expression2.getObjectDeclaration());
        ExpressionVisitor.translateClassOrObject(expression2.getObjectDeclaration(), descriptor2, context2);
        JsExpression constructor2 = ReferenceTranslator.translateAsTypeReference(descriptor2, context2);
        List<DeclarationDescriptor> closure = context2.getClassOrConstructorClosure(descriptor2);
        ArrayList<JsExpression> closureArgs = new ArrayList<JsExpression>();
        if (closure != null) {
            for (DeclarationDescriptor capturedValue : closure) {
                closureArgs.add(context2.getArgumentForClosureConstructor(capturedValue));
                if (!(capturedValue instanceof TypeParameterDescriptor)) continue;
                closureArgs.add(context2.getTypeArgumentForClosureConstructor((TypeParameterDescriptor)capturedValue));
            }
        }
        if ((superCall2 = BindingUtils.getSuperCall(context2.bindingContext(), expression2.getObjectDeclaration())) != null) {
            closureArgs.addAll(CallArgumentTranslator.translate(superCall2, null, context2).getTranslateArguments());
        }
        return new JsNew(constructor2, closureArgs);
    }

    @Override
    public JsNode visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, TranslationContext context2) {
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(118);
        }
        if (expression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(118);
        }
        for (KtAnnotationEntry entry : expression2.getAnnotationEntries()) {
            KtExpression baseExpression;
            KotlinRetention retention;
            ClassDescriptor classifierDescriptor;
            AnnotationDescriptor descriptor2 = context2.bindingContext().get(BindingContext.ANNOTATION, entry);
            if (descriptor2 == null || (classifierDescriptor = DescriptorUtilsKt.getAnnotationClass(descriptor2)) == null || (retention = DescriptorUtilsKt.getAnnotationRetention(classifierDescriptor)) != KotlinRetention.SOURCE || (baseExpression = expression2.getBaseExpression()) == null) continue;
            return baseExpression.accept(this, context2);
        }
        return (JsNode)super.visitAnnotatedExpression(expression2, context2);
    }

    @Override
    public JsNode visitClass(@NotNull KtClass klass, TranslationContext context2) {
        if (klass == null) {
            ExpressionVisitor.$$$reportNull$$$1(119);
        }
        if (klass == null) {
            ExpressionVisitor.$$$reportNull$$$0(119);
        }
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context2.bindingContext(), klass);
        ExpressionVisitor.translateClassOrObject(klass, descriptor2, context2);
        return JsEmpty.INSTANCE;
    }

    @Override
    public JsNode visitTypeAlias(@NotNull KtTypeAlias typeAlias, TranslationContext data2) {
        if (typeAlias == null) {
            ExpressionVisitor.$$$reportNull$$$1(120);
        }
        if (typeAlias == null) {
            ExpressionVisitor.$$$reportNull$$$0(120);
        }
        return JsEmpty.INSTANCE;
    }

    private static void translateClassOrObject(@NotNull KtClassOrObject declaration2, @NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context2) {
        if (declaration2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(121);
        }
        if (descriptor2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(122);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$1(123);
        }
        if (declaration2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(121);
        }
        if (descriptor2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(122);
        }
        if (context2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(123);
        }
        TranslationContext classContext = context2.innerWithUsageTracker(descriptor2);
        ClassTranslator.translate(declaration2, classContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 39: 
            case 42: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 69: 
            case 72: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetBlock";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetReturnExpression";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "visitConstantExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateConstantExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBlockExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "visitReturnExpression";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "visitParenthesizedExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBinaryExpression";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "visitProperty";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "visitCallableReferenceExpression";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectKClass";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPrimitiveClassRef";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "visitCallExpression";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "visitIfExpression";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSimpleNameExpression";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "visitWhileExpression";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "visitDoWhileExpression";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "visitStringTemplateExpression";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsTemplate";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "visitDotQualifiedExpression";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPrefixExpression";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPostfixExpression";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "visitIsExpression";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSafeQualifiedExpression";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBreakExpression";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "visitContinueExpression";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "visitLambdaExpression";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "visitNamedFunction";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThisExpression";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "visitArrayAccessExpression";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSuperExpression";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "visitForExpression";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "visitTryExpression";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThrowExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "emptyResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateConstantExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalReturnTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getObjectKClass";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveClass";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinPrimitiveClassRef";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveClassLiteral";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findPrimitiveClassesObject";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsTemplate";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsStringConstant";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitDotQualifiedExpression";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "visitSafeQualifiedExpression";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "translateClassOrObject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 39: 
            case 42: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 62: 
            case 64: 
            case 67: 
            case 69: 
            case 72: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetBlock";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetReturnExpression";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "visitConstantExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateConstantExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBlockExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "visitReturnExpression";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "visitParenthesizedExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBinaryExpression";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "visitProperty";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "visitCallableReferenceExpression";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectKClass";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinPrimitiveClassRef";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "visitCallExpression";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "visitIfExpression";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSimpleNameExpression";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "visitWhileExpression";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "visitDoWhileExpression";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "visitStringTemplateExpression";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsTemplate";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "visitDotQualifiedExpression";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPrefixExpression";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPostfixExpression";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "visitIsExpression";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSafeQualifiedExpression";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBreakExpression";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "visitContinueExpression";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "visitLambdaExpression";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "visitNamedFunction";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThisExpression";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "visitArrayAccessExpression";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSuperExpression";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "visitForExpression";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "visitTryExpression";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThrowExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "emptyResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateConstantExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalReturnTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getObjectKClass";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveClass";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinPrimitiveClassRef";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveClassLiteral";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findPrimitiveClassesObject";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsTemplate";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsStringConstant";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitDotQualifiedExpression";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "visitSafeQualifiedExpression";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "translateClassOrObject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 58: 
            case 61: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: 
            case 115: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

