/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u001e\u0010\u0019\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001a\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u000b0 J6\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010$\u001a\u00020%2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010'H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0006\u0010*\u001a\u00020\u0017J \u0010+\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;)V", "bounds", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/ArrayList;", "<set-?>", "", "isFixed", "()Z", "resultValues", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "values", "getValues", "()Ljava/util/Collection;", "addBound", "", "bound", "checkOnlyInputTypes", "possibleAnswer", "commonSupertypeForNumberTypes", "numberLowerBounds", "computeValues", "filter", "condition", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "filterBounds", "", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "errorValues", "", "getIntersectionOfSupertypes", "types", "setFixed", "tryPossibleAnswer", "frontend"})
public final class TypeBoundsImpl
implements TypeBounds {
    @NotNull
    private final TypeVariable typeVariable;
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    @Nullable
    private Collection<? extends KotlinType> resultValues;
    private boolean isFixed;

    public TypeBoundsImpl(@NotNull TypeVariable typeVariable2) {
        Intrinsics.checkNotNullParameter(typeVariable2, "typeVariable");
        this.typeVariable = typeVariable2;
        this.bounds = new ArrayList();
    }

    @Override
    @NotNull
    public TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkNotNullParameter(bound, "bound");
        this.resultValues = null;
        boolean bl = Intrinsics.areEqual(bound.getTypeVariable(), this.getTypeVariable());
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<KotlinType> filterBounds(Collection<TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<KotlinType> errorValues) {
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>();
        for (TypeBounds.Bound bound : bounds) {
            if (bound.getKind() != kind) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result2.add(bound.getConstrainingType());
                continue;
            }
            Collection<KotlinType> collection = errorValues;
            if (collection == null) continue;
            collection.add(bound.getConstrainingType());
        }
        return result2;
    }

    static /* synthetic */ Set filterBounds$default(TypeBoundsImpl typeBoundsImpl, Collection collection, TypeBounds.BoundKind boundKind, Collection collection2, int n, Object object) {
        if ((n & 4) != 0) {
            collection2 = null;
        }
        return typeBoundsImpl.filterBounds(collection, boundKind, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, Boolean> condition) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(condition, "condition");
        TypeBoundsImpl result2 = new TypeBoundsImpl(this.getTypeVariable());
        Iterable iterable = this.getBounds();
        Collection collection = result2.getBounds();
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeBounds.Bound it = (TypeBounds.Bound)element$iv$iv;
            boolean bl = false;
            if (!condition.invoke(it.getPosition()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        ((ArrayList)collection).addAll(list2);
        return result2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<KotlinType> collection = this.resultValues;
        Intrinsics.checkNotNull(collection);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinType> computeValues() {
        KotlinType intersectionOfUpperBounds;
        KotlinType superTypeOfAllLowerBounds;
        Object element$iv3;
        boolean hasStrongBound;
        List bounds;
        LinkedHashSet values2;
        block14: {
            boolean bl;
            void $this$filterTo$iv$iv;
            values2 = new LinkedHashSet();
            Iterable $this$filter$iv2 = this.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeBounds.Bound it = (TypeBounds.Bound)element$iv$iv;
                boolean bl2 = false;
                if (!it.isProper()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bounds = (List)destination$iv$iv;
            if (bounds.isEmpty()) {
                boolean $this$filter$iv2 = false;
                return kotlin.collections.CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = bounds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    TypeBounds.Bound it = (TypeBounds.Bound)element$iv2;
                    boolean bl3 = false;
                    if (!it.getPosition().isStrong()) continue;
                    bl = true;
                    break block14;
                }
                bl = hasStrongBound = false;
            }
        }
        if (!hasStrongBound) {
            boolean $this$any$iv = false;
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Set<KotlinType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values2);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends KotlinType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return kotlin.collections.CollectionsKt.listOf(bestFit);
        }
        values2.addAll(exactBounds);
        Iterable $this$partition$iv = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values2);
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv3 : $this$partition$iv) {
            KotlinType it = (KotlinType)element$iv3;
            boolean bl = false;
            if (it.getConstructor() instanceof IntegerValueTypeConstructor) {
                first$iv.add(element$iv3);
                continue;
            }
            second$iv.add(element$iv3);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List numberLowerBounds = (List)pair.component1();
        List generalLowerBounds = (List)pair.component2();
        KotlinType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            KotlinType kotlinType = superTypeOfLowerBounds;
            Intrinsics.checkNotNull(kotlinType);
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values2, superTypeOfLowerBounds);
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes(numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            KotlinType kotlinType = superTypeOfNumberLowerBounds;
            Intrinsics.checkNotNull(kotlinType);
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values2, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(kotlin.collections.CollectionsKt.listOf(element$iv3 = new KotlinType[]{superTypeOfLowerBounds, superTypeOfNumberLowerBounds})))) {
            KotlinType kotlinType = superTypeOfAllLowerBounds;
            Intrinsics.checkNotNull(kotlinType);
            return SetsKt.setOf(kotlinType);
        }
        Set<KotlinType> upperBounds2 = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values2);
        element$iv3 = upperBounds2;
        boolean bl = false;
        if (!element$iv3.isEmpty() && (intersectionOfUpperBounds = TypeIntersector.intersectTypes((Collection<KotlinType>)upperBounds2)) != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return SetsKt.setOf(intersectionOfUpperBounds);
        }
        values2.addAll(TypeBoundsImpl.filterBounds$default(this, bounds, TypeBounds.BoundKind.UPPER_BOUND, null, 4, null));
        if (values2.size() == 1 && this.getTypeVariable().hasOnlyInputTypesAnnotation() && !this.tryPossibleAnswer(bounds, (KotlinType)kotlin.collections.CollectionsKt.first(values2))) {
            boolean bl4 = false;
            return kotlin.collections.CollectionsKt.emptyList();
        }
        return values2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOnlyInputTypes(Collection<TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            TypeBounds.Bound it;
            void $this$filterTo$iv$iv2;
            if (!this.getTypeVariable().hasOnlyInputTypesAnnotation()) {
                return true;
            }
            Iterable $this$filter$iv = bounds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (TypeBounds.Bound)element$iv$iv;
                boolean bl2 = false;
                if (!(it.isProper() && it.getConstrainingType().getConstructor().isDenotable())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it = (TypeBounds.Bound)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                KotlinType kotlinType = it.getConstrainingType();
                collection.add(kotlinType);
            }
            Set typesInBoundsSet = kotlin.collections.CollectionsKt.toSet((List)destination$iv$iv);
            Iterable $this$any$iv = typesInBoundsSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    KotlinType it2 = (KotlinType)element$iv2;
                    boolean bl4 = false;
                    if (!KotlinTypeChecker.DEFAULT.equalTypes(it2, possibleAnswer)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Iterable $this$filter$iv = TypeBoundsImpl.filterBounds$default(this, bounds, TypeBounds.BoundKind.LOWER_BOUND, null, 4, null);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getConstructor() instanceof IntegerValueTypeConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numberLowerBounds = (List)destination$iv$iv;
        KotlinType superTypeOfNumberLowerBounds = this.commonSupertypeForNumberTypes(numberLowerBounds);
        return Intrinsics.areEqual(possibleAnswer, superTypeOfNumberLowerBounds);
    }

    private final boolean tryPossibleAnswer(Collection<TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        if (!this.checkOnlyInputTypes(bounds, possibleAnswer)) {
            return false;
        }
        block5: for (TypeBounds.Bound bound : bounds) {
            TypeBounds.BoundKind boundKind = bound.getKind();
            int n = WhenMappings.$EnumSwitchMapping$0[boundKind.ordinal()];
            switch (n) {
                case 1: {
                    if (KotlinTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer)) continue block5;
                    return false;
                }
                case 2: {
                    if (KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType())) continue block5;
                    return false;
                }
                case 3: {
                    if (KotlinTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    private final KotlinType commonSupertypeForNumberTypes(Collection<? extends KotlinType> numberLowerBounds) {
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        Set<KotlinType> intersectionOfSupertypes = this.getIntersectionOfSupertypes(numberLowerBounds);
        KotlinType kotlinType = TypeUtils.getDefaultPrimitiveNumberType((Collection<KotlinType>)intersectionOfSupertypes);
        return kotlinType == null ? CommonSupertypes.commonSupertype(numberLowerBounds) : kotlinType;
    }

    private final Set<KotlinType> getIntersectionOfSupertypes(Collection<? extends KotlinType> types2) {
        HashSet<KotlinType> upperBounds2 = new HashSet<KotlinType>();
        for (KotlinType kotlinType : types2) {
            Collection<KotlinType> collection = kotlinType.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, "type.constructor.supertypes");
            Collection<KotlinType> supertypes2 = collection;
            if (upperBounds2.isEmpty()) {
                upperBounds2.addAll(supertypes2);
                continue;
            }
            upperBounds2.retainAll(supertypes2);
        }
        return upperBounds2;
    }

    @Override
    @Nullable
    public KotlinType getValue() {
        return TypeBounds.DefaultImpls.getValue(this);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 1;
            nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            nArray[TypeBounds.BoundKind.EXACT_BOUND.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

