/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PlatformClassMappedToKotlinTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class PlatformClassMappedToKotlinTypeRefChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final PlatformClassMappedToKotlinTypeRefChecker INSTANCE = new PlatformClassMappedToKotlinTypeRefChecker();

    private PlatformClassMappedToKotlinTypeRefChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        ClassId kotlinClass2;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (typeRef instanceof FirResolvedTypeRef && (kotlinClass2 = FirPlatformClassMapperKt.getPlatformClassMapper(context.getSession()).getCorrespondingKotlinClass(ConeTypeUtilsKt.getClassId(((FirResolvedTypeRef)typeRef).getType()))) != null) {
            AbstractKtSourceElement abstractKtSourceElement = typeRef.getSource();
            KtDiagnosticFactory1<FqName> ktDiagnosticFactory1 = FirErrors.INSTANCE.getPLATFORM_CLASS_MAPPED_TO_KOTLIN();
            FqName fqName2 = kotlinClass2.asSingleFqName();
            Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinClass.asSingleFqName()");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)fqName2, (DiagnosticContext)context, null, 16, null);
        }
    }
}

