/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"getBackingFieldIfApplicable", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isVisible", "", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "declaration", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolve"})
public final class VisibilityUtilsKt {
    public static final boolean isVisible(@NotNull FirVisibilityChecker $this$isVisible, @NotNull FirMemberDeclaration declaration, @NotNull Candidate candidate2) {
        FirBackingField backingField2;
        Intrinsics.checkNotNullParameter($this$isVisible, "<this>");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        if (declaration instanceof FirCallableDeclaration && (ClassMembersKt.isIntersectionOverride((FirCallableDeclaration)declaration) || ClassMembersKt.isSubstitutionOverride((FirCallableDeclaration)declaration))) {
            FirCallableDeclaration $this$originalIfFakeOverride$iv = (FirCallableDeclaration)declaration;
            boolean $i$f$originalIfFakeOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = $this$originalIfFakeOverride$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            if (firCallableDeclaration == null) {
                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv = $this$originalIfFakeOverride$iv;
                boolean $i$f$getBaseForIntersectionOverride = false;
                firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv) : null;
            }
            Intrinsics.checkNotNull(firCallableDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
            return VisibilityUtilsKt.isVisible($this$isVisible, firCallableDeclaration, candidate2);
        }
        if (declaration instanceof FirBackingField) {
            return true;
        }
        CallInfo callInfo = candidate2.getCallInfo();
        FirFile useSiteFile = callInfo.getContainingFile();
        List<FirDeclaration> containingDeclarations = callInfo.getContainingDeclarations();
        FirSession session2 = callInfo.getSession();
        boolean visible = FirVisibilityChecker.isVisible$default($this$isVisible, declaration, session2, useSiteFile, containingDeclarations, candidate2.getDispatchReceiverValue(), candidate2.getCallInfo().getCallSite() instanceof FirVariableAssignment, false, null, 192, null);
        if (visible && (backingField2 = VisibilityUtilsKt.getBackingFieldIfApplicable(declaration)) != null) {
            candidate2.setHasVisibleBackingField(FirVisibilityChecker.isVisible$default($this$isVisible, backingField2, session2, useSiteFile, containingDeclarations, candidate2.getDispatchReceiverValue(), candidate2.getCallInfo().getCallSite() instanceof FirVariableAssignment, false, null, 192, null));
        }
        return visible;
    }

    private static final FirBackingField getBackingFieldIfApplicable(FirMemberDeclaration $this$getBackingFieldIfApplicable) {
        FirVariable firVariable = $this$getBackingFieldIfApplicable instanceof FirProperty ? (FirProperty)$this$getBackingFieldIfApplicable : null;
        if (firVariable == null || (firVariable = DeclarationAttributesKt.getExplicitBackingField(firVariable)) == null) {
            return null;
        }
        FirVariable field2 = firVariable;
        FirMemberDeclaration $this$visibility$iv = field2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        return ((Intrinsics.areEqual(visibility2, Visibilities.PrivateToThis.INSTANCE) ? true : Intrinsics.areEqual(visibility2, Visibilities.Private.INSTANCE)) ? true : Intrinsics.areEqual(visibility2, Visibilities.Internal.INSTANCE)) ? field2 : null;
    }
}

