/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSingleAbstractMember", "abstractMember", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "funInterfaceKeyword", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class FunInterfaceDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable reportOn;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(declaration instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        List<CallableMemberDescriptor> abstractMembers = SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)descriptor2);
        for (CallableMemberDescriptor abstractMember : abstractMembers) {
            PsiElement psiElement2;
            if (!(abstractMember instanceof PropertyDescriptor)) continue;
            boolean reportOnProperty = Intrinsics.areEqual(((PropertyDescriptor)abstractMember).getContainingDeclaration(), descriptor2);
            if (reportOnProperty) {
                SourceElement sourceElement = ((PropertyDescriptor)abstractMember).getSource();
                Intrinsics.checkNotNullExpressionValue(sourceElement, "abstractMember.source");
                PsiElement psiElement3 = PsiSourceElementKt.getPsi(sourceElement);
                psiElement2 = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
                if (psiElement2 == null || (psiElement2 = psiElement2.getValOrVarKeyword()) == null) {
                    psiElement2 = funKeyword;
                }
            } else {
                psiElement2 = funKeyword;
            }
            reportOn = psiElement2;
            context.getTrace().report(Errors.FUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES.on((PsiElement)reportOn));
            if (reportOnProperty) continue;
            return;
        }
        Iterable $this$filterIsInstance$iv = abstractMembers;
        boolean $i$f$filterIsInstance = false;
        reportOn = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FunctionDescriptor abstractMember = (FunctionDescriptor)CollectionsKt.singleOrNull((List)destination$iv$iv);
        if (abstractMember == null) {
            context.getTrace().report(Errors.FUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS.on(funKeyword));
            return;
        }
        this.checkSingleAbstractMember(abstractMember, funKeyword, context);
    }

    private final void checkSingleAbstractMember(FunctionDescriptor abstractMember, PsiElement funInterfaceKeyword, DeclarationCheckerContext context) {
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "abstractMember.source");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtNamedFunction ktFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        List<TypeParameterDescriptor> list2 = abstractMember.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "abstractMember.typeParameters");
        if (!((Collection)list2).isEmpty()) {
            Object object;
            KtElementImplStub ktElementImplStub = ktFunction;
            if (ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getTypeParameterList()) != null) {
                object = ktElementImplStub;
            } else {
                KtNamedFunction ktNamedFunction = ktFunction;
                object = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
                if (object == null) {
                    object = funInterfaceKeyword;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, "ktFunction?.typeParamete\u2026rd ?: funInterfaceKeyword");
            PsiElement reportOn = object;
            context.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS.on(reportOn));
            return;
        }
        for (ValueParameterDescriptor parameter : abstractMember.getValueParameters()) {
            Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter)) continue;
            SourceElement sourceElement2 = parameter.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement2, "parameter.source");
            Object object = PsiSourceElementKt.getPsi(sourceElement2);
            if (object == null) {
                KtNamedFunction ktNamedFunction = ktFunction;
                object = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
                if (object == null) {
                    object = funInterfaceKeyword;
                }
            }
            PsiElement reportOn = object;
            context.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE.on(reportOn));
            return;
        }
    }
}

