/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TFloatByteHashMap;
import gnu.trove.TFloatByteIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatByteHashMapDecorator
extends AbstractMap<Float, Byte> {
    protected final TFloatByteHashMap _map;

    public TFloatByteHashMapDecorator(TFloatByteHashMap map) {
        this._map = map;
    }

    @Override
    public Byte put(Float key, Byte value2) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value2)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Float && val instanceof Byte) {
                    float k = this.unwrapKey(key);
                    byte v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Byte get(Object object) {
        return this.get((Float)object);
    }

    public Byte get(Float key) {
        float k = this.unwrapKey(key);
        byte v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Byte remove(Float key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Byte remove(Object object) {
        return this.remove((Float)object);
    }

    @Override
    public Set<Map.Entry<Float, Byte>> entrySet() {
        return new AbstractSet<Map.Entry<Float, Byte>>(){

            @Override
            public int size() {
                return TFloatByteHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TFloatByteHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TFloatByteHashMapDecorator.this.containsKey(k) && TFloatByteHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Float, Byte>> iterator() {
                return new Iterator<Map.Entry<Float, Byte>>(){
                    private final TFloatByteIterator it;
                    {
                        this.it = TFloatByteHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Float, Byte> next() {
                        this.it.advance();
                        final Float key = TFloatByteHashMapDecorator.this.wrapKey(this.it.key());
                        final Byte v = TFloatByteHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Float, Byte>(){
                            private Byte val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Float getKey() {
                                return key;
                            }

                            @Override
                            public Byte getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Byte setValue(Byte value2) {
                                this.val = value2;
                                return TFloatByteHashMapDecorator.this.put(key, value2);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Float, Byte> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Float, Byte>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TFloatByteHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Byte> map) {
        Iterator<Map.Entry<? extends Float, ? extends Byte>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Float, ? extends Byte> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Float wrapKey(float k) {
        return new Float(k);
    }

    protected float unwrapKey(Object key) {
        return ((Float)key).floatValue();
    }

    protected Byte wrapValue(byte k) {
        return new Byte(k);
    }

    protected byte unwrapValue(Object value2) {
        return (Byte)value2;
    }
}

