/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.InputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001f\u0010\u001a\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "index", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "enableSearchInCtSym", "", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;Lcom/intellij/psi/search/GlobalSearchScope;Z)V", "findBinaryClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "fileName", "", "findBinaryOrSigClass", "simpleName", "rootType", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findClass", "findMetadata", "findSigFileIfEnabled", "Lorg/jetbrains/annotations/Nullable;", "dir", "findSourceClass", "findSourceOrBinaryVirtualFile", "findVirtualFileWithHeader", "hasMetadataPackage", "fqName", "cli"})
public final class CliVirtualFileFinder
extends VirtualFileFinder {
    private final JvmDependenciesIndex index;
    private final GlobalSearchScope scope;
    private final boolean enableSearchInCtSym;

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.findBinaryOrSigClass(classId);
    }

    @Override
    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        VirtualFile virtualFile2 = this.findBinaryOrSigClass(classId);
        if (virtualFile2 == null) {
            virtualFile2 = this.findSourceClass(classId, classId.getRelativeClassName().asString() + ".java");
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        boolean bl;
        Intrinsics.checkNotNullParameter(classId, "classId");
        boolean bl2 = bl = !classId.isNestedClass();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Nested classes are not supported here: " + classId;
            throw new AssertionError((Object)string2);
        }
        VirtualFile virtualFile2 = this.findBinaryClass(classId, classId.getShortClassName().asString() + ".kotlin_metadata");
        return virtualFile2 != null ? virtualFile2.getInputStream() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        void found;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        JvmDependenciesIndex.DefaultImpls.traverseDirectoriesInPackage$default(this.index, fqName2, null, new Function2<VirtualFile, JavaRoot.RootType, Boolean>((Ref.BooleanRef)found){
            final /* synthetic */ Ref.BooleanRef $found;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                boolean bl;
                boolean bl2;
                block1: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter(dir, "dir");
                    Intrinsics.checkNotNullParameter((Object)((Object)$noName_1), "<anonymous parameter 1>");
                    boolean bl3 = this.$found.element;
                    VirtualFile[] virtualFileArray = dir.getChildren();
                    Intrinsics.checkNotNullExpressionValue(virtualFileArray, "dir.children");
                    VirtualFile[] virtualFileArray2 = virtualFileArray;
                    bl2 = bl3;
                    Ref.BooleanRef booleanRef = this.$found;
                    boolean $i$f$any = false;
                    int n = ((void)$this$any$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$any$iv[i];
                        boolean bl4 = false;
                        void v2 = it;
                        Intrinsics.checkNotNullExpressionValue(v2, "it");
                        if (!Intrinsics.areEqual(v2.getExtension(), "kotlin_metadata")) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean bl5 = bl;
                booleanRef.element = bl2 | bl5;
                return !this.$found.element;
            }
            {
                this.$found = booleanRef;
                super(2);
            }
        }, 2, null);
        return found.element;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        ClassId classId = new ClassId(packageFqName, Name.special("<builtins-metadata>"));
        VirtualFile virtualFile2 = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile2 != null ? virtualFile2.getInputStream() : null;
    }

    private final VirtualFile findClass(ClassId classId, String fileName, Set<? extends JavaRoot.RootType> rootType) {
        Object object;
        VirtualFile virtualFile2 = (VirtualFile)this.index.findClass(classId, rootType, (Function2)new Function2<VirtualFile, JavaRoot.RootType, VirtualFile>(fileName){
            final /* synthetic */ String $fileName;

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                Object object;
                Intrinsics.checkNotNullParameter(dir, "dir");
                Intrinsics.checkNotNullParameter((Object)((Object)$noName_1), "<anonymous parameter 1>");
                VirtualFile virtualFile2 = dir.findChild(this.$fileName);
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3;
                    VirtualFile p1 = virtualFile3 = virtualFile2;
                    boolean bl = false;
                    object = p1.isValid() ? virtualFile3 : null;
                } else {
                    object = null;
                }
                return object;
            }
            {
                this.$fileName = string2;
                super(2);
            }
        });
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl = false;
            object = this.scope.contains(it) ? virtualFile3 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final VirtualFile findSigFileIfEnabled(VirtualFile dir, String simpleName2) {
        return this.enableSearchInCtSym ? dir.findChild(simpleName2 + ".sig") : null;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId, String simpleName2, Set<? extends JavaRoot.RootType> rootType) {
        Object object;
        VirtualFile virtualFile2 = (VirtualFile)this.index.findClass(classId, rootType, (Function2)new Function2<VirtualFile, JavaRoot.RootType, VirtualFile>(this, simpleName2){
            final /* synthetic */ CliVirtualFileFinder this$0;
            final /* synthetic */ String $simpleName;

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile dir, @NotNull JavaRoot.RootType $noName_1) {
                VirtualFile file2;
                Intrinsics.checkNotNullParameter(dir, "dir");
                Intrinsics.checkNotNullParameter((Object)((Object)$noName_1), "<anonymous parameter 1>");
                VirtualFile virtualFile2 = dir.findChild(this.$simpleName + ".class");
                if (virtualFile2 == null) {
                    virtualFile2 = CliVirtualFileFinder.access$findSigFileIfEnabled(this.this$0, dir, this.$simpleName);
                }
                return (file2 = virtualFile2) != null && file2.isValid() ? file2 : null;
            }
            {
                this.this$0 = cliVirtualFileFinder;
                this.$simpleName = string2;
                super(2);
            }
        });
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl = false;
            object = this.scope.contains(it) ? virtualFile3 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId) {
        String string2 = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "classId.relativeClassName.asString()");
        return this.findBinaryOrSigClass(classId, StringsKt.replace$default(string2, '.', '$', false, 4, null), JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findSourceClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlySource());
    }

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index2, @NotNull GlobalSearchScope scope2, boolean enableSearchInCtSym) {
        Intrinsics.checkNotNullParameter(index2, "index");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.index = index2;
        this.scope = scope2;
        this.enableSearchInCtSym = enableSearchInCtSym;
    }

    public static final /* synthetic */ VirtualFile access$findSigFileIfEnabled(CliVirtualFileFinder $this, VirtualFile dir, String simpleName2) {
        return $this.findSigFileIfEnabled(dir, simpleName2);
    }
}

