/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\n\u0010\u000b\u001a\u00020\u0005*\u00020\fJ\n\u0010\r\u001a\u00020\u000e*\u00020\u000fR\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ElementTypeUtils;", "", "()V", "expressionSet", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "getKotlinBlockImbalanceCount", "", "seq", "", "getOperationSymbol", "", "isExpression", "", "Lcom/intellij/lang/LighterASTNode;", "psi"})
public final class ElementTypeUtils {
    @NotNull
    public static final ElementTypeUtils INSTANCE = new ElementTypeUtils();
    @NotNull
    private static final List<IElementType> expressionSet;

    private ElementTypeUtils() {
    }

    @JvmStatic
    public static final int getKotlinBlockImbalanceCount(@NotNull CharSequence seq) {
        Intrinsics.checkNotNullParameter(seq, "seq");
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(seq);
        if (lexer.getTokenType() != KtTokens.LBRACE) {
            return Integer.MIN_VALUE;
        }
        lexer.advance();
        int balance = 1;
        while (!Intrinsics.areEqual(lexer.getTokenType(), (Object)KtTokens.EOF) && lexer.getTokenType() != null) {
            IElementType type2;
            if (balance == 0) {
                return Integer.MIN_VALUE;
            }
            if (type2 == KtTokens.LBRACE) {
                ++balance;
            } else if (type2 == KtTokens.RBRACE) {
                --balance;
            }
            lexer.advance();
        }
        return balance;
    }

    @NotNull
    public final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkNotNullParameter($this$getOperationSymbol, "<this>");
        IElementType[] iElementTypeArray = KotlinExpressionParsing.ALL_OPERATIONS.getTypes();
        Intrinsics.checkNotNullExpressionValue(iElementTypeArray, "ALL_OPERATIONS.types");
        Object[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IElementType it = (IElementType)element$iv;
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual(((KtSingleValueToken)it).getValue(), $this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual($this$getOperationSymbol, "as?")) {
            KtToken ktToken = KtTokens.AS_SAFE;
            Intrinsics.checkNotNullExpressionValue((Object)ktToken, "AS_SAFE");
            return ktToken;
        }
        KtToken ktToken = KtTokens.IDENTIFIER;
        Intrinsics.checkNotNullExpressionValue((Object)ktToken, "IDENTIFIER");
        return ktToken;
    }

    public final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkNotNullParameter($this$isExpression, "<this>");
        IElementType iElementType = $this$isExpression.getTokenType();
        return ((iElementType instanceof KtNodeType ? true : iElementType instanceof KtConstantExpressionElementType) ? true : iElementType instanceof KtStringTemplateExpressionElementType) ? true : expressionSet.contains(iElementType);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN};
        expressionSet = CollectionsKt.listOf(iElementTypeArray);
    }
}

