/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.mangle.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.KotlinMangleComputer;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleConstant;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B!\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH&J\u001c\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020!2\n\u0010&\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\n\u0010\"\u001a\u00060\u0005j\u0002`\u0006H\u0014J\u001c\u0010*\u001a\u00020!2\n\u0010+\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010'\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020!2\u0006\u0010\u001d\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020!2\u0006\u0010\u001d\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020!2\u0006\u0010\u001d\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020(H\u0016J\u0018\u0010G\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010G\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010J\u001a\u00020\u001cH\u0002J\u0018\u0010K\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010K\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010L\u001a\u00020MH\u0002J\u0018\u0010K\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010J\u001a\u00020\u001cH\u0002J\f\u0010N\u001a\u00020\u0003*\u00020(H\u0002J$\u0010O\u001a\u00020!*\u00020\u001a2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\n2\u0006\u0010R\u001a\u00020\u0003H\u0002J\u001c\u0010S\u001a\u00020!*\u00020\u001a2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\nH\u0002J\u0014\u0010T\u001a\u00020!*\u00020\u00032\u0006\u0010U\u001a\u00020\u001cH\u0002J\u0018\u0010V\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010W\u001a\u00020(H\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010\u001c*\u00020\u001aH\u0016J\u0014\u0010Y\u001a\u00020\u001c*\u00020\u001a2\u0006\u0010'\u001a\u00020,H\u0016R\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0012j\b\u0012\u0004\u0012\u00020\u0003`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\n*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/mangle/ir/IrMangleComputer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/KotlinMangleComputer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "compatibleMode", "", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;Z)V", "getBuilder", "()Ljava/lang/StringBuilder;", "getCompatibleMode", "()Z", "isRealExpect", "typeParameterContainer", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isSyntheticForJavaField", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "addReturnType", "addReturnTypeSpecialCase", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "computeMangle", "", "declaration", "copy", "newMode", "mangleType", "", "tBuilder", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "mangleTypeParameter", "tpBuilder", "param", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "mangleTypePlatformSpecific", "mangleValueParameter", "vpBuilder", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "visitErrorDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrErrorDeclaration;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "visitProperty", "visitScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "visitTypeParameter", "appendName", "c", "", "s", "appendSignature", "i", "", "effectiveParent", "mangleFunction", "isCtor", "isStatic", "container", "mangleSignature", "mangleSimpleDeclaration", "name", "mangleTypeParameterReference", "typeParameter", "platformSpecificFunctionName", "specialValueParamPrefix", "ir.serialization.common"})
public abstract class IrMangleComputer
implements KotlinMangleComputer<IrDeclaration>,
IrElementVisitorVoid {
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final MangleMode mode;
    private final boolean compatibleMode;
    @NotNull
    private final ArrayList<IrDeclaration> typeParameterContainer;
    private boolean isRealExpect;

    public IrMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        this.builder = builder2;
        this.mode = mode;
        this.compatibleMode = compatibleMode;
        this.typeParameterContainer = new ArrayList(4);
    }

    @NotNull
    protected final StringBuilder getBuilder() {
        return this.builder;
    }

    protected final boolean getCompatibleMode() {
        return this.compatibleMode;
    }

    @Nullable
    public String platformSpecificFunctionName(@NotNull IrFunction $this$platformSpecificFunctionName) {
        Intrinsics.checkNotNullParameter($this$platformSpecificFunctionName, "<this>");
        return null;
    }

    @NotNull
    public String specialValueParamPrefix(@NotNull IrFunction $this$specialValueParamPrefix, @NotNull IrValueParameter param) {
        Intrinsics.checkNotNullParameter($this$specialValueParamPrefix, "<this>");
        Intrinsics.checkNotNullParameter(param, "param");
        return "";
    }

    public boolean addReturnType() {
        return false;
    }

    protected boolean addReturnTypeSpecialCase(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        return false;
    }

    @NotNull
    public abstract IrMangleComputer copy(@NotNull MangleMode var1);

    private final void appendName(StringBuilder $this$appendName, String s) {
        if (this.mode.getFqn()) {
            $this$appendName.append(s);
        }
    }

    private final void appendName(StringBuilder $this$appendName, char c) {
        if (this.mode.getFqn()) {
            $this$appendName.append(c);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, String s) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(s);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, char c) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(c);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, int i) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(i);
        }
    }

    @Override
    @NotNull
    public String computeMangle(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrVisitorsKt.acceptVoid(declaration, this);
        String string2 = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "builder.toString()");
        return string2;
    }

    private final void mangleSimpleDeclaration(IrDeclaration $this$mangleSimpleDeclaration, String name) {
        int l = this.builder.length();
        IrVisitorsKt.acceptVoid($this$mangleSimpleDeclaration.getParent(), this);
        if (this.builder.length() != l) {
            this.appendName(this.builder, '.');
        }
        this.appendName(this.builder, name);
    }

    private final void mangleFunction(IrFunction $this$mangleFunction, boolean isCtor, boolean isStatic, IrDeclaration container) {
        this.isRealExpect |= $this$mangleFunction.isExpect();
        this.typeParameterContainer.add(container);
        IrDeclarationParent containerParent = container.getParent();
        IrDeclarationParent realParent = containerParent instanceof IrField && Intrinsics.areEqual(((IrField)containerParent).getOrigin(), IrDeclarationOrigin.DELEGATE.INSTANCE) ? ((IrField)containerParent).getParent() : containerParent;
        IrVisitorsKt.acceptVoid(realParent, this);
        this.appendName(this.builder, '#');
        String string2 = this.platformSpecificFunctionName($this$mangleFunction);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.builder.append(it);
            return;
        }
        String string3 = $this$mangleFunction.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string3, "name.asString()");
        String funName = string3;
        this.builder.append(funName);
        this.mangleSignature($this$mangleFunction, isCtor, isStatic);
    }

    private final void mangleSignature(IrFunction $this$mangleSignature, boolean isCtor, boolean isStatic) {
        if (!this.mode.getSignature()) {
            return;
        }
        if (isStatic) {
            this.appendSignature(this.builder, "#static");
        }
        IrValueParameter irValueParameter = $this$mangleSignature.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            if (!it.isHidden()) {
                this.appendSignature(this.builder, '@');
                this.mangleValueParameter(this.builder, it);
            }
        }
        MangleUtilsKt.collectForMangler((Collection)$this$mangleSignature.getValueParameters(), this.builder, MangleConstant.VALUE_PARAMETERS, (Function2)new Function2<StringBuilder, IrValueParameter, Unit>(this, $this$mangleSignature){
            final /* synthetic */ IrMangleComputer this$0;
            final /* synthetic */ IrFunction $this_mangleSignature;
            {
                this.this$0 = $receiver;
                this.$this_mangleSignature = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrValueParameter it) {
                Intrinsics.checkNotNullParameter($this$collectForMangler, "$this$collectForMangler");
                Intrinsics.checkNotNullParameter(it, "it");
                if (!it.isHidden()) {
                    IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, this.this$0.specialValueParamPrefix(this.$this_mangleSignature, it));
                    IrMangleComputer.access$mangleValueParameter(this.this$0, $this$collectForMangler, it);
                }
            }
        });
        MangleUtilsKt.collectForMangler((Collection)$this$mangleSignature.getTypeParameters(), this.builder, MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IrTypeParameter, Unit>(this){
            final /* synthetic */ IrMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrTypeParameter it) {
                Intrinsics.checkNotNullParameter($this$collectForMangler, "$this$collectForMangler");
                Intrinsics.checkNotNullParameter(it, "it");
                IrMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, it);
            }
        });
        if (!isCtor && !IrTypePredicatesKt.isUnit($this$mangleSignature.getReturnType()) && (this.addReturnType() || this.addReturnTypeSpecialCase($this$mangleSignature))) {
            this.mangleType(this.builder, $this$mangleSignature.getReturnType());
        }
    }

    private final IrDeclaration effectiveParent(IrTypeParameter $this$effectiveParent) {
        IrDeclaration irDeclaration2;
        IrDeclarationParent irParent2 = $this$effectiveParent.getParent();
        if (irParent2 instanceof IrSimpleFunction) {
            Object object = ((IrSimpleFunction)irParent2).getCorrespondingPropertySymbol();
            irDeclaration2 = (IrDeclaration)(object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)irParent2);
        } else if (irParent2 instanceof IrTypeParametersContainer) {
            irDeclaration2 = (IrDeclaration)((Object)irParent2);
        } else {
            throw new IllegalStateException(("Unexpected type parameter container " + RenderIrElementKt.render(irParent2) + " for TP " + RenderIrElementKt.render($this$effectiveParent)).toString());
        }
        return irDeclaration2;
    }

    private final void mangleValueParameter(StringBuilder vpBuilder, IrValueParameter param) {
        this.mangleType(vpBuilder, param.getType());
        if (AdditionalIrUtilsKt.isVararg(param)) {
            this.appendSignature(vpBuilder, "...");
        }
    }

    private final void mangleTypeParameter(StringBuilder tpBuilder, IrTypeParameter param) {
        this.appendSignature(tpBuilder, param.getIndex());
        this.appendSignature(tpBuilder, '\u00a7');
        MangleUtilsKt.collectForMangler((Collection)param.getSuperTypes(), tpBuilder, MangleConstant.UPPER_BOUNDS, (Function2)new Function2<StringBuilder, IrType, Unit>(this){
            final /* synthetic */ IrMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrType it) {
                Intrinsics.checkNotNullParameter($this$collectForMangler, "$this$collectForMangler");
                Intrinsics.checkNotNullParameter(it, "it");
                IrMangleComputer.access$mangleType(this.this$0, $this$collectForMangler, it);
            }
        });
    }

    private final void mangleTypeParameterReference(StringBuilder $this$mangleTypeParameterReference, IrTypeParameter typeParameter) {
        IrDeclaration parent2 = this.effectiveParent(typeParameter);
        int ci = this.typeParameterContainer.indexOf(parent2);
        this.appendSignature($this$mangleTypeParameterReference, ci);
        this.appendSignature($this$mangleTypeParameterReference, ':');
        this.appendSignature($this$mangleTypeParameterReference, typeParameter.getIndex());
    }

    private final void mangleType(StringBuilder tBuilder, IrType type2) {
        IrType irType = type2;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier2 = ((IrSimpleType)type2).getClassifier();
            if (classifier2 instanceof IrClassSymbol) {
                IrVisitorsKt.acceptVoid((IrElement)((IrClassSymbol)classifier2).getOwner(), this.copy(MangleMode.FQNAME));
            } else if (classifier2 instanceof IrTypeParameterSymbol) {
                this.mangleTypeParameterReference(tBuilder, (IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner());
            }
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)type2).getArguments();
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                List $this$mangleType_u24lambda_u242 = (List)$this$ifNotEmpty$iv;
                boolean bl = false;
                MangleUtilsKt.collectForMangler($this$mangleType_u24lambda_u242, tBuilder, MangleConstant.TYPE_ARGUMENTS, (Function2)new Function2<StringBuilder, IrTypeArgument, Unit>(this){
                    final /* synthetic */ IrMangleComputer this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrTypeArgument arg) {
                        Intrinsics.checkNotNullParameter($this$collectForMangler, "$this$collectForMangler");
                        Intrinsics.checkNotNullParameter(arg, "arg");
                        IrTypeArgument irTypeArgument = arg;
                        if (irTypeArgument instanceof IrStarProjection) {
                            IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, '*');
                        } else if (irTypeArgument instanceof IrTypeProjection) {
                            if (((IrTypeProjection)arg).getVariance() != Variance.INVARIANT) {
                                IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, ((IrTypeProjection)arg).getVariance().getLabel());
                                IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, '|');
                            }
                            IrMangleComputer.access$mangleType(this.this$0, $this$collectForMangler, ((IrTypeProjection)arg).getType());
                        }
                    }
                });
            }
            if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2)) {
                this.appendSignature(tBuilder, '?');
            }
            this.mangleTypePlatformSpecific(type2, tBuilder);
        } else if (irType instanceof IrDynamicType) {
            this.appendSignature(tBuilder, "<dynamic>");
        } else if (irType instanceof IrErrorType) {
            this.appendSignature(tBuilder, "<ERROR CLASS>");
        } else {
            throw new IllegalStateException(("Unexpected type " + type2).toString());
        }
    }

    protected void mangleTypePlatformSpecific(@NotNull IrType type2, @NotNull StringBuilder tBuilder) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(tBuilder, "tBuilder");
    }

    @NotNull
    public Void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException(("unexpected element " + RenderIrElementKt.render(element)).toString());
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrVisitorsKt.acceptVoid(declaration.getParent(), this);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.mangleSimpleDeclaration(declaration, "<ERROR DECLARATION>");
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.isRealExpect |= declaration.isExpect();
        this.typeParameterContainer.add(declaration);
        String string2 = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
        String className2 = string2;
        this.mangleSimpleDeclaration(declaration, className2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FqName it = declaration.getFqName();
        boolean bl = false;
        if (!it.isRoot()) {
            String string2 = it.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
            this.appendName(this.builder, string2);
        }
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        List list2;
        IrDeclarationBase irDeclarationBase;
        boolean isStaticProperty;
        boolean bl;
        IrSimpleFunction accessor;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrProperty $this$visitProperty_u24lambda_u244 = declaration;
        boolean bl2 = false;
        IrSimpleFunction irSimpleFunction = $this$visitProperty_u24lambda_u244.getGetter();
        if (irSimpleFunction == null) {
            irSimpleFunction = $this$visitProperty_u24lambda_u244.getSetter();
        }
        if (!((accessor = irSimpleFunction) != null || declaration.getBackingField() != null)) {
            boolean $i$a$-require-IrMangleComputer$visitProperty$22 = false;
            String $i$a$-require-IrMangleComputer$visitProperty$22 = "Expected at least one accessor or backing field for property " + RenderIrElementKt.render(declaration);
            throw new IllegalArgumentException($i$a$-require-IrMangleComputer$visitProperty$22.toString());
        }
        this.isRealExpect |= declaration.isExpect();
        this.typeParameterContainer.add(declaration);
        IrVisitorsKt.acceptVoid(declaration.getParent(), this);
        if (accessor != null) {
            IrSimpleFunction it = accessor;
            boolean bl3 = false;
            bl = it.getDispatchReceiverParameter() == null && !(declaration.getParent() instanceof IrPackageFragment) && !IrUtilsKt.isFacadeClass(declaration.getParent());
        } else {
            IrDeclarationBase irDeclarationBase2 = (IrProperty)IrFakeOverrideUtilsKt.resolveFakeOverride$default(declaration, false, null, 3, null);
            if (irDeclarationBase2 == null || (irDeclarationBase2 = ((IrProperty)irDeclarationBase2).getBackingField()) == null) {
                throw new IllegalStateException(("Expected at least one accessor or a backing field for property " + RenderIrElementKt.render(declaration)).toString());
            }
            IrDeclarationBase backingField2 = irDeclarationBase2;
            bl = isStaticProperty = ((IrField)backingField2).isStatic();
        }
        if (isStaticProperty) {
            this.appendSignature(this.builder, "#static");
        }
        if ((irDeclarationBase = accessor) != null && (irDeclarationBase = irDeclarationBase.getExtensionReceiverParameter()) != null) {
            IrDeclarationBase it = irDeclarationBase;
            boolean bl4 = false;
            this.appendSignature(this.builder, '@');
            this.mangleValueParameter(this.builder, (IrValueParameter)it);
        }
        if ((list2 = accessor) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = CollectionsKt.emptyList();
        }
        List typeParameters2 = list2;
        MangleUtilsKt.collectForMangler(typeParameters2, this.builder, MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IrTypeParameter, Unit>(this){
            final /* synthetic */ IrMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrTypeParameter it) {
                Intrinsics.checkNotNullParameter($this$collectForMangler, "$this$collectForMangler");
                Intrinsics.checkNotNullParameter(it, "it");
                IrMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, it);
            }
        });
        this.builder.append(declaration.getName().asString());
        if (this.isSyntheticForJavaField(declaration)) {
            this.builder.append("#jf");
        }
    }

    private final boolean isSyntheticForJavaField(IrProperty $this$isSyntheticForJavaField) {
        return Intrinsics.areEqual($this$isSyntheticForJavaField.getOrigin(), IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && $this$isSyntheticForJavaField.getGetter() == null && $this$isSyntheticForJavaField.getSetter() == null;
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrPropertySymbol prop2 = declaration.getCorrespondingPropertySymbol();
        if (this.compatibleMode || prop2 == null) {
            IrDeclaration irDeclaration2 = declaration;
            String string2 = declaration.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
            this.mangleSimpleDeclaration(irDeclaration2, string2);
        } else {
            this.visitProperty((IrProperty)prop2.getOwner());
        }
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrDeclaration irDeclaration2 = declaration;
        String string2 = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
        this.mangleSimpleDeclaration(irDeclaration2, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        StringBuilder stringBuilder2;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrClass klass = IrUtilsKt.getParentAsClass(declaration);
        Iterable $this$filterIsInstance$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List anonInitializers = (List)destination$iv$iv;
        StringBuilder $this$visitAnonymousInitializer_u24lambda_u248 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$visitAnonymousInitializer_u24lambda_u248.append("<ANI>");
        if (anonInitializers.size() > 1) {
            $this$visitAnonymousInitializer_u24lambda_u248.append('$');
            $this$visitAnonymousInitializer_u24lambda_u248.append(anonInitializers.indexOf(declaration));
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String anonName = string2;
        this.mangleSimpleDeclaration(declaration, anonName);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrDeclaration irDeclaration2 = declaration;
        String string2 = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
        this.mangleSimpleDeclaration(irDeclaration2, string2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrVisitorsKt.acceptVoid(this.effectiveParent(declaration), this);
        this.appendSignature(this.builder, '@');
        this.appendSignature(this.builder, declaration.getIndex());
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.isRealExpect |= declaration.isExpect();
        Object object = declaration.getCorrespondingPropertySymbol();
        IrElement container = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)declaration;
        boolean isStatic = declaration.getDispatchReceiverParameter() == null && !(((IrDeclarationBase)container).getParent() instanceof IrPackageFragment) && !IrUtilsKt.isFacadeClass(((IrDeclarationBase)container).getParent());
        this.mangleFunction(declaration, false, isStatic, (IrDeclaration)container);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.mangleFunction(declaration, true, false, declaration);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    public static final /* synthetic */ void access$appendSignature(IrMangleComputer $this, StringBuilder $receiver, String s) {
        $this.appendSignature($receiver, s);
    }

    public static final /* synthetic */ void access$mangleValueParameter(IrMangleComputer $this, StringBuilder vpBuilder, IrValueParameter param) {
        $this.mangleValueParameter(vpBuilder, param);
    }

    public static final /* synthetic */ void access$mangleTypeParameter(IrMangleComputer $this, StringBuilder tpBuilder, IrTypeParameter param) {
        $this.mangleTypeParameter(tpBuilder, param);
    }

    public static final /* synthetic */ void access$mangleType(IrMangleComputer $this, StringBuilder tBuilder, IrType type2) {
        $this.mangleType(tBuilder, type2);
    }

    public static final /* synthetic */ void access$appendSignature(IrMangleComputer $this, StringBuilder $receiver, char c) {
        $this.appendSignature($receiver, c);
    }
}

