/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "mapRangeTypeToPrimitiveType", "Lorg/jetbrains/org/objectweb/asm/Type;", "rangeType", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "backend.jvm.codegen"})
public final class RangeTo
extends IntrinsicMethod {
    @NotNull
    public static final RangeTo INSTANCE = new RangeTo();

    private RangeTo() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull ClassCodegen classCodegen) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
        Type type2 = signature2.getReturnType();
        Intrinsics.checkNotNullExpressionValue(type2, "signature.returnType");
        Type argType = this.mapRangeTypeToPrimitiveType(type2);
        Collection collection = CollectionsKt.listOf(argType);
        List<JvmMethodParameterSignature> list2 = signature2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "signature.valueParameters");
        Iterable iterable = list2;
        Collection collection2 = collection;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JvmMethodParameterSignature jvmMethodParameterSignature = (JvmMethodParameterSignature)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(argType);
        }
        List<Type> list3 = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        return new IrIntrinsicFunction(expression2, signature2, classCodegen, argType, list3){
            final /* synthetic */ JvmMethodSignature $signature;
            final /* synthetic */ Type $argType;
            {
                this.$signature = $signature;
                this.$argType = $argType;
                super($expression, $signature, $classCodegen, $super_call_param$1);
            }

            public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                Intrinsics.checkNotNullParameter(v, "v");
                Type[] typeArray = new Type[]{this.$argType, this.$argType};
                v.invokespecial(this.$signature.getReturnType().getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, typeArray), false);
            }

            @NotNull
            public StackValue invoke(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2, @NotNull IrFunctionAccessExpression expression2) {
                Intrinsics.checkNotNullParameter(v, "v");
                Intrinsics.checkNotNullParameter(codegen2, "codegen");
                Intrinsics.checkNotNullParameter(data2, "data");
                Intrinsics.checkNotNullParameter(expression2, "expression");
                codegen2.markLineNumber(expression2);
                v.anew(this.getReturnType());
                v.dup();
                return super.invoke(v, codegen2, data2, expression2);
            }
        };
    }

    private final Type mapRangeTypeToPrimitiveType(Type rangeType) {
        Type type2;
        String fqName2 = rangeType.getInternalName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "fqName");
        switch (StringsKt.substringBefore$default(StringsKt.substringAfter$default(fqName2, "kotlin/ranges/", null, 2, null), "Range", null, 2, null)) {
            case "Double": {
                Type type3 = Type.DOUBLE_TYPE;
                type2 = type3;
                Intrinsics.checkNotNullExpressionValue(type3, "DOUBLE_TYPE");
                break;
            }
            case "Float": {
                Type type4 = Type.FLOAT_TYPE;
                type2 = type4;
                Intrinsics.checkNotNullExpressionValue(type4, "FLOAT_TYPE");
                break;
            }
            case "Long": {
                Type type5 = Type.LONG_TYPE;
                type2 = type5;
                Intrinsics.checkNotNullExpressionValue(type5, "LONG_TYPE");
                break;
            }
            case "Int": {
                Type type6 = Type.INT_TYPE;
                type2 = type6;
                Intrinsics.checkNotNullExpressionValue(type6, "INT_TYPE");
                break;
            }
            case "Short": {
                Type type7 = Type.SHORT_TYPE;
                type2 = type7;
                Intrinsics.checkNotNullExpressionValue(type7, "SHORT_TYPE");
                break;
            }
            case "Char": {
                Type type8 = Type.CHAR_TYPE;
                type2 = type8;
                Intrinsics.checkNotNullExpressionValue(type8, "CHAR_TYPE");
                break;
            }
            case "Byte": {
                Type type9 = Type.BYTE_TYPE;
                type2 = type9;
                Intrinsics.checkNotNullExpressionValue(type9, "BYTE_TYPE");
                break;
            }
            default: {
                throw new IllegalStateException("RangeTo intrinsic can only work for primitive types: " + fqName2);
            }
        }
        return type2;
    }
}

