/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedReifiedParameterReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0018H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirClassLiteralChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirGetClassCallChecker;", "()V", "canBeDoubleColonLHSAsType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getCanBeDoubleColonLHSAsType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "safeAsTypeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getSafeAsTypeParameterSymbol", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isAllowedInClassLiteral", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isNullableTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "checkers"})
public final class FirClassLiteralChecker
extends FirExpressionChecker<FirGetClassCall> {
    @NotNull
    public static final FirClassLiteralChecker INSTANCE = new FirClassLiteralChecker();

    private FirClassLiteralChecker() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull FirGetClassCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        v0 = expression.getSource();
        if (v0 == null) {
            return;
        }
        source = v0;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        argument = expression.getArgument();
        if (argument instanceof FirResolvedQualifier && (Intrinsics.areEqual(classId = ((FirResolvedQualifier)argument).getClassId(), OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) || Intrinsics.areEqual(classId, OptInNames.INSTANCE.getOPT_IN_CLASS_ID()))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirErrors.INSTANCE.getOPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
        }
        v1 = KtTokens.QUEST;
        Intrinsics.checkNotNullExpressionValue((Object)v1, "QUEST");
        v2 = markedNullable = FirSourceUtilsKt.getChild$default(source, v1, 0, 1, false, 10, null) != null;
        if (markedNullable) ** GOTO lbl-1000
        v3 = argument instanceof FirResolvedQualifier != false ? (FirResolvedQualifier)argument : null;
        v4 = v3 != null ? v3.isNullableLHSForCallableReference() : false;
        if (v4 || ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getConeType(argument.getTypeRef())) || this.isNullableTypeParameter(FirTypeUtilsKt.getConeType(argument.getTypeRef()), TypeComponentsKt.getTypeContext(context.getSession()))) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = isNullable = false;
        }
        if (isNullable) {
            if (this.getCanBeDoubleColonLHSAsType(argument)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNULLABLE_TYPE_IN_CLASS_LITERAL_LHS(), (DiagnosticContext)context, null, 8, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirErrors.INSTANCE.getEXPRESSION_OF_NULLABLE_TYPE_IN_CLASS_LITERAL_LHS(), (Object)FirTypeUtilsKt.getConeType(argument.getTypeRef()), (DiagnosticContext)context, null, 16, null);
            }
            return;
        }
        v6 = this.getSafeAsTypeParameterSymbol(argument);
        if (v6 != null) {
            it = v6;
            $i$a$-let-FirClassLiteralChecker$check$1 = false;
            if (!it.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), (Object)it, (DiagnosticContext)context, null, 16, null);
            }
        }
        if (!(argument instanceof FirResolvedQualifier)) {
            return;
        }
        if (((Collection)((FirResolvedQualifier)argument).getTypeArguments()).isEmpty() == false && !this.isAllowedInClassLiteral(FirTypeUtilsKt.getConeType(argument.getTypeRef()), context)) {
            v7 = symbol = ((FirResolvedQualifier)argument).getSymbol();
            if (v7 != null) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)v7, FirResolvePhase.TYPES);
            }
            v8 = symbol;
            var11_12 = v8 != null ? (FirClassLikeDeclaration)v8.getFir() : null;
            v9 = var11_12 instanceof FirTypeParameterRefsOwner != false ? (FirTypeParameterRefsOwner)var11_12 : null;
            v10 = typeParameters = v9 != null ? v9.getTypeParameters() : null;
            if (v10 != null) {
                $this$count$iv = v10;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v11 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (FirTypeParameterRef)element$iv;
                        $i$a$-count-FirClassLiteralChecker$check$expectedTypeArgumentSize$1 = false;
                        if (!(it instanceof FirTypeParameter) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v11 = count$iv;
                }
            } else {
                v11 = expectedTypeArgumentSize = 0;
            }
            if (expectedTypeArgumentSize != ((FirResolvedQualifier)argument).getTypeArguments().size()) {
                return;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCLASS_LITERAL_LHS_NOT_A_CLASS(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isNullableTypeParameter(ConeKotlinType $this$isNullableTypeParameter, ConeInferenceContext context) {
        if (!($this$isNullableTypeParameter instanceof ConeTypeParameterType)) {
            return false;
        }
        FirTypeParameterSymbol typeParameter = ((ConeTypeParameterType)$this$isNullableTypeParameter).getLookupTag().getTypeParameterSymbol();
        ConeInferenceContext $this$isNullableTypeParameter_u24lambda_u242 = context;
        boolean bl = false;
        return !typeParameter.isReified() && $this$isNullableTypeParameter_u24lambda_u242.isNullableType(FirNestedClassifierScopeKt.toConeType(typeParameter));
    }

    private final boolean getCanBeDoubleColonLHSAsType(FirExpression $this$canBeDoubleColonLHSAsType) {
        return $this$canBeDoubleColonLHSAsType instanceof FirResolvedQualifier || $this$canBeDoubleColonLHSAsType instanceof FirResolvedReifiedParameterReference || this.getSafeAsTypeParameterSymbol($this$canBeDoubleColonLHSAsType) != null;
    }

    private final FirTypeParameterSymbol getSafeAsTypeParameterSymbol(FirExpression $this$safeAsTypeParameterSymbol) {
        FirPureAbstractElement firPureAbstractElement = $this$safeAsTypeParameterSymbol instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$safeAsTypeParameterSymbol : null;
        FirBasedSymbol<?> firBasedSymbol = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? UtilsKt.getResolvedSymbol((FirReference)firPureAbstractElement) : null;
        return firBasedSymbol instanceof FirTypeParameterSymbol ? (FirTypeParameterSymbol)firBasedSymbol : null;
    }

    private final boolean isAllowedInClassLiteral(ConeKotlinType $this$isAllowedInClassLiteral, CheckerContext context) {
        boolean bl;
        block9: {
            ConeKotlinType coneKotlinType = $this$isAllowedInClassLiteral;
            if (coneKotlinType instanceof ConeClassLikeType) {
                if (ConeBuiltinTypeUtilsKt.isNonPrimitiveArray($this$isAllowedInClassLiteral)) {
                    ConeTypeProjection[] $this$none$iv = $this$isAllowedInClassLiteral.getTypeArguments();
                    boolean $i$f$none = false;
                    int n = $this$none$iv.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl2;
                        ConeTypeProjection element$iv;
                        ConeTypeProjection typeArgument = element$iv = $this$none$iv[i];
                        boolean bl3 = false;
                        ConeTypeProjection coneTypeProjection = typeArgument;
                        if (coneTypeProjection instanceof ConeStarProjection) {
                            bl2 = true;
                        } else if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                            bl2 = !INSTANCE.isAllowedInClassLiteral(((ConeKotlinTypeProjection)typeArgument).getType(), context);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        if (!bl2) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                } else {
                    bl = $this$isAllowedInClassLiteral.getTypeArguments().length == 0;
                }
            } else {
                bl = coneKotlinType instanceof ConeTypeParameterType ? ((ConeTypeParameterType)$this$isAllowedInClassLiteral).getLookupTag().getTypeParameterSymbol().isReified() : false;
            }
        }
        return bl;
    }
}

