/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.lexer.Lexer;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtIoFileSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinLightParser;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u001b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "lightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "sourceFile", "Lorg/jetbrains/kotlin/KtSourceFile;", "linesMapping", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "code", "", "makeDiagnosticContext", "org/jetbrains/kotlin/fir/lightTree/LightTree2Fir$makeDiagnosticContext$1", "", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir$makeDiagnosticContext$1;", "Companion", "light-tree2fir"})
public final class LightTree2Fir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirScopeProvider scopeProvider;
    @Nullable
    private final DiagnosticReporter diagnosticsReporter;
    @NotNull
    private static final KotlinParserDefinition parserDefinition = new KotlinParserDefinition();

    public LightTree2Fir(@NotNull FirSession session2, @NotNull FirScopeProvider scopeProvider, @Nullable DiagnosticReporter diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeProvider, "scopeProvider");
        this.session = session2;
        this.scopeProvider = scopeProvider;
        this.diagnosticsReporter = diagnosticsReporter;
    }

    public /* synthetic */ LightTree2Fir(FirSession firSession, FirScopeProvider firScopeProvider, DiagnosticReporter diagnosticReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            diagnosticReporter = null;
        }
        this(firSession, firScopeProvider, diagnosticReporter);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        File file2 = path2.toFile();
        Intrinsics.checkNotNullExpressionValue(file2, "path.toFile()");
        return this.buildFirFile(file2);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        KtIoFileSourceFile sourceFile = new KtIoFileSourceFile(file2);
        InputStreamReader $this$buildFirFile_u24lambda_u240 = new InputStreamReader((InputStream)new FileInputStream(file2), Charsets.UTF_8);
        boolean bl = false;
        Pair<CharSequence, KtSourceFileLinesMapping> pair = KtSourceFileLinesMappingKt.readSourceFileWithMapping($this$buildFirFile_u24lambda_u240);
        CharSequence code = pair.component1();
        KtSourceFileLinesMapping linesMapping = pair.component2();
        return this.buildFirFile(code, (KtSourceFile)sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull FlyweightCapableTreeStructure<LighterASTNode> lightTree, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter(lightTree, "lightTree");
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(linesMapping, "linesMapping");
        DeclarationsConverter declarationsConverter = new DeclarationsConverter(this.session, this.scopeProvider, lightTree, 0, null, this.diagnosticsReporter, this.makeDiagnosticContext(sourceFile.getPath()), 24, null);
        Object object = lightTree.getRoot();
        Intrinsics.checkNotNullExpressionValue(object, "lightTree.root");
        return declarationsConverter.convertFile((LighterASTNode)object, sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull CharSequence code, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(linesMapping, "linesMapping");
        return this.buildFirFile(Companion.buildLightTree(code), sourceFile, linesMapping);
    }

    private final makeDiagnosticContext.1 makeDiagnosticContext(String path2) {
        return this.diagnosticsReporter == null ? null : new DiagnosticContext(path2, this){
            @Nullable
            private final String containingFilePath;
            final /* synthetic */ LightTree2Fir this$0;
            {
                this.this$0 = $receiver;
                this.containingFilePath = $path;
            }

            @Nullable
            public String getContainingFilePath() {
                return this.containingFilePath;
            }

            @NotNull
            public LanguageVersionSettings getLanguageVersionSettings() {
                return FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.this$0.getSession());
            }

            public boolean isDiagnosticSuppressed(@NotNull KtDiagnostic diagnostic) {
                Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
                return false;
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir$Companion;", "", "()V", "parserDefinition", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "buildLightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "code", "", "buildLightTreeBlockExpression", "", "buildLightTreeLambdaExpression", "makeLexer", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "light-tree2fir"})
    public static final class Companion {
        private Companion() {
        }

        private final KotlinLexer makeLexer() {
            return new KotlinLexer();
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTreeBlockExpression(@NotNull String code) {
            Intrinsics.checkNotNullParameter(code, "code");
            PsiBuilder psiBuilder = new PsiBuilderFactoryImpl().createBuilder((ParserDefinition)parserDefinition, (Lexer)this.makeLexer(), (CharSequence)code);
            Intrinsics.checkNotNullExpressionValue(psiBuilder, "PsiBuilderFactoryImpl().\u2026ition, makeLexer(), code)");
            PsiBuilder builder2 = psiBuilder;
            KotlinLightParser.parseBlockExpression(builder2);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder2.getLightTree();
            Intrinsics.checkNotNullExpressionValue(flyweightCapableTreeStructure, "builder.lightTree");
            return flyweightCapableTreeStructure;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTreeLambdaExpression(@NotNull String code) {
            Intrinsics.checkNotNullParameter(code, "code");
            PsiBuilder psiBuilder = new PsiBuilderFactoryImpl().createBuilder((ParserDefinition)parserDefinition, (Lexer)this.makeLexer(), (CharSequence)code);
            Intrinsics.checkNotNullExpressionValue(psiBuilder, "PsiBuilderFactoryImpl().\u2026ition, makeLexer(), code)");
            PsiBuilder builder2 = psiBuilder;
            KotlinLightParser.parseLambdaExpression(builder2);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder2.getLightTree();
            Intrinsics.checkNotNullExpressionValue(flyweightCapableTreeStructure, "builder.lightTree");
            return flyweightCapableTreeStructure;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTree(@NotNull CharSequence code) {
            Intrinsics.checkNotNullParameter(code, "code");
            PsiBuilder psiBuilder = new PsiBuilderFactoryImpl().createBuilder((ParserDefinition)parserDefinition, (Lexer)this.makeLexer(), code);
            Intrinsics.checkNotNullExpressionValue(psiBuilder, "PsiBuilderFactoryImpl().\u2026ition, makeLexer(), code)");
            PsiBuilder builder2 = psiBuilder;
            KotlinLightParser.parse(builder2);
            FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder2.getLightTree();
            Intrinsics.checkNotNullExpressionValue(flyweightCapableTreeStructure, "builder.lightTree");
            return flyweightCapableTreeStructure;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

