/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.ExtractPDFTextComposer;
import net.doo.snap.process.compose.JpegComposer;
import net.doo.snap.process.compose.OcrComposer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.device.DeviceUtils;
import org.jetbrains.annotations.NotNull;
import roboguice.RoboGuice;

public class P2ComposerFactory
implements ComposerFactory {
    private final Context context;
    private final SharedPreferences preferences;
    private final DeviceUtils deviceUtils;

    @Inject
    public P2ComposerFactory(Context context, SharedPreferences preferences, DeviceUtils deviceUtils) {
        this.context = context;
        this.preferences = preferences;
        this.deviceUtils = deviceUtils;
    }

    @NotNull
    public Composer composerForDocument(Document document) {
        if (document.getName().endsWith(".jpg")) {
            return this.buildJpegOrDummyComposer(document);
        }
        OcrStatus status = document.getOcrStatus();
        if (status == OcrStatus.DONE) {
            return this.buildExtractPDFTextComposer();
        }
        if (status == OcrStatus.PENDING_FORCED) {
            return this.buildOcrComposer();
        }
        if (status == OcrStatus.PENDING_ON_CHARGER && this.deviceUtils.isDeviceOnCharger()) {
            return this.buildOcrComposer();
        }
        if (!this.preferences.getBoolean("PERFORM_OCR", true) || status == OcrStatus.NOT_SCHEDULED) {
            return this.buildSimpleOrDummyComposer(document);
        }
        if (this.preferences.getBoolean("OCR_ONLY_WHILE_CHARGING", false) && !this.deviceUtils.isDeviceOnCharger()) {
            return this.buildSimpleOrDummyComposer(document);
        }
        if (status == OcrStatus.PENDING) {
            return this.buildOcrComposer();
        }
        return new ComposerFactory.DummyComposer();
    }

    private OcrComposer buildOcrComposer() {
        OcrComposer composer = new OcrComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }

    private ExtractPDFTextComposer buildExtractPDFTextComposer() {
        ExtractPDFTextComposer composer = new ExtractPDFTextComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        SimpleComposer composer = new SimpleComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        JpegComposer composer = new JpegComposer();
        RoboGuice.getInjector((Context)this.context).injectMembersWithoutViews((Object)composer);
        return composer;
    }
}

