/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.security;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.inject.Inject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.ScanbotDialogFragment;
import net.doo.snap.util.log.DebugLog;
import org.apache.commons.codec.binary.Hex;
import roboguice.event.EventManager;

public class AddCertificateDialogFragment
extends ScanbotDialogFragment {
    public static final String FINGERPRINT_ALGORITHM = "SHA1";
    @Inject
    private EventManager eventManager;
    private X509Certificate certificate;

    public static AddCertificateDialogFragment newInstance(X509Certificate certificate) {
        AddCertificateDialogFragment fragment = new AddCertificateDialogFragment();
        fragment.certificate = certificate;
        return fragment;
    }

    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.certificate == null) {
            return new View((Context)this.getActivity());
        }
        this.setTitle(R.string.not_trusted_certificate_title);
        this.setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                AddCertificateDialogFragment.this.eventManager.fire((Object)new CertificateApprovedEvent(AddCertificateDialogFragment.this.certificate));
                AddCertificateDialogFragment.this.dismissAllowingStateLoss();
            }
        });
        this.setNegativeButton(17039369, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                AddCertificateDialogFragment.this.eventManager.fire((Object)new CertificateApprovedEvent(null));
                AddCertificateDialogFragment.this.dismissAllowingStateLoss();
            }
        });
        TextView message = (TextView)inflater.inflate(R.layout.dialog_message, container, false);
        message.setText((CharSequence)this.getString(R.string.not_trusted_certificate_warning, new Object[]{this.getCertificateFingerprint()}));
        return message;
    }

    private String getCertificateFingerprint() {
        try {
            MessageDigest digest = MessageDigest.getInstance(FINGERPRINT_ALGORITHM);
            byte[] fingerprint = digest.digest(this.certificate.getEncoded());
            return new String(Hex.encodeHex((byte[])fingerprint));
        }
        catch (NoSuchAlgorithmException e) {
            DebugLog.logException((Throwable)e);
        }
        catch (CertificateEncodingException e) {
            DebugLog.logException((Throwable)e);
        }
        return "";
    }

    public void onResume() {
        super.onResume();
        if (this.certificate == null) {
            this.dismissAllowingStateLoss();
        }
    }

    public static class CertificateApprovedEvent {
        private final X509Certificate certificate;

        public CertificateApprovedEvent(X509Certificate certificate) {
            this.certificate = certificate;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }
    }
}

