/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.google.inject.Inject;
import de.aflx.sardine.Sardine;
import de.aflx.sardine.SardineFactory;
import java.io.File;
import java.io.IOException;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.log.DebugLog;

public class BoxActivity
extends CustomThemeActivity {
    private static final int CHOOSER_REQUEST_CODE = 1;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private SardineFactory sardineFactory;
    private EditText usernameView;
    private EditText passwordView;
    private ViewGroup progressView;
    private ViewGroup contentView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_webdav);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.findViewById(R.id.webdavurls).setVisibility(8);
        ((TextView)this.findViewById(R.id.title)).setText(R.string.storage_box);
        ((TextView)this.findViewById(R.id.description)).setText((CharSequence)this.getString(R.string.storage_description, new Object[]{this.getString(R.string.storage_box)}));
        this.findViewById(R.id.host).setVisibility(8);
        this.usernameView = (EditText)this.findViewById(R.id.username);
        this.passwordView = (EditText)this.findViewById(R.id.password);
        this.progressView = (ViewGroup)this.findViewById(R.id.progress);
        this.progressView.setVisibility(8);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.BOX.getNameResource())}));
        this.contentView = (ViewGroup)this.findViewById(R.id.content_container);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.BOX, this.usernameView.getText().toString()));
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.webdav_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.login) {
            if (TextUtils.isEmpty((CharSequence)this.usernameView.getText()) || TextUtils.isEmpty((CharSequence)this.passwordView.getText())) {
                Toast.makeText((Context)this, (int)R.string.web_dav_fempty_fields_error, (int)1).show();
            } else {
                this.finishAuthorization();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void finishAuthorization() {
        new AsyncTask<Void, Void, Boolean>(){

            protected void onPreExecute() {
                super.onPreExecute();
                BoxActivity.this.progressView.setVisibility(0);
                BoxActivity.this.contentView.setVisibility(8);
                InputMethodManager imm = (InputMethodManager)BoxActivity.this.getSystemService("input_method");
                imm.hideSoftInputFromWindow(BoxActivity.this.usernameView.getWindowToken(), 0);
                imm.hideSoftInputFromWindow(BoxActivity.this.passwordView.getWindowToken(), 0);
            }

            protected Boolean doInBackground(Void ... params) {
                Sardine sardine = BoxActivity.this.sardineFactory.begin(BoxActivity.this.usernameView.getText().toString(), BoxActivity.this.passwordView.getText().toString());
                if (sardine == null) {
                    return false;
                }
                try {
                    boolean rootFolderExists = sardine.exists(new Uri.Builder().encodedPath(ManifestConstantsProvider.getConstantValue((Context)BoxActivity.this, (String)"box_cloud_url") + File.separator).toString());
                    if (rootFolderExists) {
                        return true;
                    }
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                }
                return false;
            }

            protected void onPostExecute(Boolean result) {
                super.onPostExecute((Object)result);
                if (result.booleanValue()) {
                    BoxActivity.this.storeCredentials();
                    BoxActivity.this.preferences.edit().remove(CloudStorage.BOX.getDefaultFolderKey()).commit();
                    Intent intent = new Intent((Context)BoxActivity.this, CloudStorage.getChooserActivity(CloudStorage.BOX));
                    intent.putExtra("CLOUD_STORAGE", CloudStorage.BOX.getDatabaseId());
                    BoxActivity.this.startActivityForResult(intent, 1);
                } else {
                    BoxActivity.this.progressView.setVisibility(8);
                    BoxActivity.this.contentView.setVisibility(0);
                    Toast.makeText((Context)BoxActivity.this, (int)R.string.predefined_webdav_invalid_toast, (int)1).show();
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }

    private void storeCredentials() {
        this.preferences.edit().putString("BOX_USERNAME", this.usernameView.getText().toString()).putString("BOX_PASS", this.passwordView.getText().toString()).commit();
    }
}

