/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.LoaderManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Loader;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.ScanbotDialogFragment;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.slack.SlackApi;
import net.doo.snap.upload.cloud.slack.model.Channel;
import net.doo.snap.upload.cloud.slack.model.ChannelsListResponse;
import net.doo.snap.upload.cloud.slack.model.Group;
import net.doo.snap.upload.cloud.slack.model.GroupsListResponse;
import net.doo.snap.upload.cloud.slack.model.Im;
import net.doo.snap.upload.cloud.slack.model.ImListResponse;
import net.doo.snap.upload.cloud.slack.model.User;
import net.doo.snap.upload.cloud.slack.model.UsersListResponse;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;

public class SlackManualUploadFragment
extends ScanbotDialogFragment {
    private static final int TARGETS_LOADER_ID = 51;
    private static final String UPLOAD_INFOS_KEY = "DOCUMENTS";
    private static final String CHANNEL_FORMAT = "#%s";
    private static final String IM_CHANNEL_FORMAT = "@%s";
    private static final String GROUP_FORMAT = "\ud83d\udd12%s";
    private static final String SEPARATOR = ",";
    @Inject
    private SlackApi slackApi;
    @Inject
    private SharedPreferences preferences;
    private SlackUploadListener slackUploadListener;
    private ListView targetsList;
    private SlackUploadTargetsAdapter adapter;
    private EditText titleView;
    private EditText commentView;
    private TextView targetNamesView;
    private ArrayList<UploadInfo> uploadInfos;
    private LinearLayout topContainer;
    private LinearLayout bottomContainer;
    private HashSet<String> targetIds = new HashSet();
    private LoaderManager.LoaderCallbacks itemsLoaderCallbacks = new LoaderManager.LoaderCallbacks<List<ListItem>>(){

        public Loader<List<ListItem>> onCreateLoader(int i, Bundle bundle) {
            return new SingleThreadLoader<List<ListItem>>((Context)SlackManualUploadFragment.this.getActivity()){

                protected List<ListItem> doInBackground() {
                    ArrayList<ListItem> items = new ArrayList<ListItem>();
                    this.loadChannels(items);
                    this.loadImChannels(items);
                    this.loadGroups(items);
                    return items;
                }
            };
        }

        private void loadChannels(List<ListItem> dest) {
            try {
                ChannelsListResponse channelsListResponse = SlackManualUploadFragment.this.slackApi.getChannels();
                if (channelsListResponse != null && channelsListResponse.isOk() && !channelsListResponse.getChannels().isEmpty()) {
                    List<Channel> channels = channelsListResponse.getChannels();
                    dest.add(new ListItem(ItemType.SECTION_NAME, SlackManualUploadFragment.this.getString(R.string.slack_section_channels), null));
                    for (Channel channel : channels) {
                        dest.add(new ListItem(ItemType.CHANNEL, String.format(SlackManualUploadFragment.CHANNEL_FORMAT, channel.getName()), channel.getId()));
                    }
                }
            }
            catch (IOException e) {
                DebugLog.logException((Throwable)e);
            }
        }

        private void loadImChannels(List<ListItem> dest) {
            try {
                UsersListResponse usersListResponse = SlackManualUploadFragment.this.slackApi.getUsers();
                if (usersListResponse != null && usersListResponse.isOk()) {
                    ImListResponse imListResponse;
                    HashMap<String, User> users = new HashMap<String, User>();
                    List<User> usersList = usersListResponse.getMembers();
                    for (User user : usersList) {
                        if (user == null || TextUtils.isEmpty((CharSequence)user.getName())) continue;
                        users.put(user.getId(), user);
                    }
                    if (!users.isEmpty() && (imListResponse = SlackManualUploadFragment.this.slackApi.getImChannels()) != null && imListResponse.isOk() && !imListResponse.getIms().isEmpty()) {
                        dest.add(new ListItem(ItemType.SECTION_NAME, SlackManualUploadFragment.this.getString(R.string.slack_section_im), null));
                        List<Im> ims = imListResponse.getIms();
                        for (Im im : ims) {
                            if (!users.containsKey(im.getUser())) continue;
                            dest.add(new ListItem(ItemType.IM, String.format(SlackManualUploadFragment.IM_CHANNEL_FORMAT, ((User)users.get(im.getUser())).getName()), im.getId()));
                        }
                    }
                }
            }
            catch (IOException e) {
                DebugLog.logException((Throwable)e);
            }
        }

        private void loadGroups(List<ListItem> dest) {
            try {
                GroupsListResponse groupsListResponse = SlackManualUploadFragment.this.slackApi.getGroups();
                if (groupsListResponse != null && groupsListResponse.isOk() && !groupsListResponse.getGroups().isEmpty()) {
                    List<Group> groups = groupsListResponse.getGroups();
                    dest.add(new ListItem(ItemType.SECTION_NAME, SlackManualUploadFragment.this.getString(R.string.slack_section_groups), null));
                    for (Group group : groups) {
                        dest.add(new ListItem(ItemType.GROUP, String.format(SlackManualUploadFragment.GROUP_FORMAT, group.getName()), group.getId()));
                    }
                }
            }
            catch (IOException e) {
                DebugLog.logException((Throwable)e);
            }
        }

        public void onLoadFinished(Loader<List<ListItem>> itemsLoader, List<ListItem> items) {
            if (!items.isEmpty()) {
                SlackManualUploadFragment.this.adapter.setItems(items);
                String defaultFolderId = null;
                Uri defaultFolderUri = CloudStorage.SLACK.getDefaultFolder(SlackManualUploadFragment.this.preferences);
                if (defaultFolderUri != null) {
                    defaultFolderId = defaultFolderUri.getQueryParameter("id");
                    defaultFolderId = SlackManualUploadFragment.this.preferences.getString("LAST_SLACK_TARGET_ID", defaultFolderId);
                }
                ListItem defaultTarget = items.get(1);
                if (!TextUtils.isEmpty((CharSequence)defaultFolderId)) {
                    for (ListItem item : items) {
                        if (item.id == null || !item.id.equals(defaultFolderId)) continue;
                        defaultTarget = item;
                        break;
                    }
                }
                SlackManualUploadFragment.this.targetNamesView.setText((CharSequence)defaultTarget.caption);
                SlackManualUploadFragment.this.targetIds.clear();
                SlackManualUploadFragment.this.targetIds.add(defaultTarget.id);
                SlackManualUploadFragment.this.checkPositiveButtonEnabled(null);
            }
        }

        public void onLoaderReset(Loader<List<ListItem>> itemsLoader) {
        }
    };

    public static SlackManualUploadFragment newInstance(ArrayList<UploadInfo> uploadInfos) {
        if (uploadInfos == null) {
            throw new IllegalArgumentException("docs cannot be empty for upload");
        }
        SlackManualUploadFragment fragment = new SlackManualUploadFragment();
        Bundle args = new Bundle();
        args.putParcelableArrayList(UPLOAD_INFOS_KEY, uploadInfos);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.uploadInfos = this.getArguments().getParcelableArrayList(UPLOAD_INFOS_KEY);
    }

    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setTitle(R.string.slack_upload_fragment_title);
        this.setPositiveButton(R.string.slack_upload_positive_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int index) {
                String title = SlackManualUploadFragment.this.titleView.getText().toString();
                if (TextUtils.isEmpty((CharSequence)title) && SlackManualUploadFragment.this.uploadInfos.size() == 1) {
                    Toast.makeText((Context)SlackManualUploadFragment.this.getActivity(), (int)R.string.slack_error_title_is_empty, (int)0).show();
                    return;
                }
                String targets = TextUtils.join((CharSequence)SlackManualUploadFragment.SEPARATOR, (Iterable)SlackManualUploadFragment.this.targetIds);
                if (TextUtils.isEmpty((CharSequence)targets)) {
                    Toast.makeText((Context)SlackManualUploadFragment.this.getActivity(), (int)R.string.slack_error_channel_is_empty, (int)0).show();
                    return;
                }
                String comment = SlackManualUploadFragment.this.commentView.getText().toString();
                SlackManualUploadFragment.this.uploadDocuments(targets, title, comment);
                SlackManualUploadFragment.this.dismiss();
            }
        });
        this.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                SlackManualUploadFragment.this.dismiss();
            }
        });
        View view = inflater.inflate(R.layout.slack_manual_upload_fragment, container, false);
        this.titleView = (EditText)view.findViewById(R.id.title);
        this.titleView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void afterTextChanged(Editable editable) {
                SlackManualUploadFragment.this.checkPositiveButtonEnabled(editable.toString());
            }
        });
        this.titleView.setText((CharSequence)this.uploadInfos.get(0).getName());
        this.commentView = (EditText)view.findViewById(R.id.comment);
        this.targetNamesView = (TextView)view.findViewById(R.id.targets_names);
        this.targetNamesView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SlackManualUploadFragment.this.showTargetsList();
            }
        });
        this.targetsList = (ListView)view.findViewById(R.id.upload_targets);
        this.adapter = new SlackUploadTargetsAdapter((Context)this.getActivity());
        this.targetsList.setAdapter((ListAdapter)this.adapter);
        this.targetsList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                ListItem listItem = SlackManualUploadFragment.this.adapter.getItem(i);
                if (listItem.type != ItemType.SECTION_NAME) {
                    SlackManualUploadFragment.this.targetNamesView.setText((CharSequence)listItem.caption);
                    SlackManualUploadFragment.this.targetIds.clear();
                    SlackManualUploadFragment.this.targetIds.add(listItem.id);
                    SlackManualUploadFragment.this.hideTargetsList();
                    SlackManualUploadFragment.this.preferences.edit().putString("LAST_SLACK_TARGET_ID", listItem.id).apply();
                }
            }
        });
        this.topContainer = (LinearLayout)view.findViewById(R.id.top_container);
        this.bottomContainer = (LinearLayout)view.findViewById(R.id.bottom_container);
        this.getActivity().getLoaderManager().initLoader(51, null, this.itemsLoaderCallbacks);
        return view;
    }

    public void onStart() {
        super.onStart();
        this.hideTargetsList();
    }

    public void setSlackUploadListener(SlackUploadListener slackUploadListener) {
        this.slackUploadListener = slackUploadListener;
    }

    private void showTargetsList() {
        ((AlertDialog)this.getDialog()).getButton(-1).setEnabled(false);
        this.targetsList.setVisibility(0);
        this.targetNamesView.setVisibility(8);
        this.topContainer.setVisibility(8);
        this.bottomContainer.setVisibility(8);
    }

    private void hideTargetsList() {
        this.checkPositiveButtonEnabled(this.titleView.getText().toString());
        this.targetsList.setVisibility(8);
        this.targetNamesView.setVisibility(0);
        this.bottomContainer.setVisibility(0);
        if (this.uploadInfos.size() > 1) {
            this.topContainer.setVisibility(8);
        } else {
            this.topContainer.setVisibility(0);
        }
    }

    private void checkPositiveButtonEnabled(String title) {
        Dialog dialog = this.getDialog();
        if (dialog == null) {
            return;
        }
        Button button = ((AlertDialog)dialog).getButton(-1);
        if (button == null) {
            return;
        }
        if (title == null) {
            title = this.titleView.getText().toString();
        }
        if (title.isEmpty()) {
            button.setEnabled(false);
            return;
        }
        if (this.targetIds.isEmpty()) {
            button.setEnabled(false);
            return;
        }
        button.setEnabled(true);
    }

    private void uploadDocuments(String targets, String title, String comment) {
        Bundle extras = new Bundle();
        extras.putString("TARGETS_EXTRA", targets);
        if (this.uploadInfos.size() == 1) {
            extras.putString("TITLE_EXTRA", title);
        }
        extras.putString("COMMENT_EXTRA", comment);
        for (UploadInfo info : this.uploadInfos) {
            info.setExtras(extras);
        }
        if (this.slackUploadListener == null) {
            throw new RuntimeException("UploadDocumentsListener is not initiated!");
        }
        this.slackUploadListener.startUpload(this.uploadInfos, CloudStorage.SLACK);
    }

    public static interface SlackUploadListener {
        public void startUpload(List<UploadInfo> var1, CloudStorage var2);
    }

    private static enum ItemType {
        SECTION_NAME,
        CHANNEL,
        IM,
        GROUP;

    }

    private class ListItem {
        ItemType type;
        String caption;
        String id;

        public ListItem(ItemType type, String caption, String id2) {
            this.type = type;
            this.caption = caption;
            this.id = id2;
        }
    }

    private class SlackUploadTargetsAdapter
    extends BaseAdapter {
        private List<ListItem> items = new ArrayList<ListItem>();
        private LayoutInflater inflater;

        SlackUploadTargetsAdapter(Context context) {
            this.inflater = LayoutInflater.from((Context)context);
        }

        public void setItems(List<ListItem> items) {
            this.items.clear();
            this.items.addAll(items);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.items.size();
        }

        public ListItem getItem(int position) {
            return this.items.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            return this.getItem((int)position).type == ItemType.SECTION_NAME ? 0 : 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                holder = new ViewHolder();
                ListItem item = this.getItem(position);
                if (item.type == ItemType.SECTION_NAME) {
                    convertView = this.inflater.inflate(R.layout.slack_section_header, parent, false);
                    holder.name = (TextView)convertView.findViewById(R.id.header);
                } else {
                    convertView = this.inflater.inflate(R.layout.slack_list_item, parent, false);
                    holder.name = (TextView)convertView.findViewById(R.id.caption);
                }
                holder.item = item;
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.name.setText((CharSequence)this.getItem((int)position).caption);
            return convertView;
        }

        class ViewHolder {
            ListItem item;
            TextView name;

            ViewHolder() {
            }
        }
    }
}

