/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.ui.widget.text.CustomTypefaceTextView;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.wunderlist.ForbiddenException;
import net.doo.snap.upload.cloud.wunderlist.WunderlistApi;
import net.doo.snap.upload.cloud.wunderlist.model.CreateListRequest;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class WunderlistChooserActivity
extends ChooserActivity {
    @Inject
    private WunderlistApi wunderlistApi;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.WUNDERLIST;
    }

    @Override
    protected void createFolder(String name) {
        try {
            this.wunderlistApi.createList(new CreateListRequest(name));
        }
        catch (IOException | ForbiddenException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        this.foldersHierarchy.clear();
        List<net.doo.snap.upload.cloud.wunderlist.model.List> lists = null;
        try {
            lists = this.wunderlistApi.getLists();
        }
        catch (IOException | ForbiddenException e) {
            DebugLog.logException((Throwable)e);
        }
        if (lists == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_list);
            return Collections.emptyList();
        }
        ArrayList<Uri> listUris = new ArrayList<Uri>();
        for (net.doo.snap.upload.cloud.wunderlist.model.List list : lists) {
            Uri uri = new Uri.Builder().appendQueryParameter("folder_name", list.getTitle()).appendQueryParameter("id", String.valueOf(list.getId())).build();
            listUris.add(uri);
        }
        return listUris;
    }

    @Override
    protected View initHeader() {
        View view = super.initHeader();
        ((CustomTypefaceTextView)view.findViewById(R.id.new_folder).findViewById(R.id.name)).setText(R.string.new_list);
        return view;
    }
}

