/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload;

import android.content.Context;
import android.util.Pair;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.DocumentLockProvider;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.UploadDocumentsProvider;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.upload.cloud.UploaderProvider;

public class DocumentUploader {
    private final OnFileUploadListener uploadListener;
    @Inject
    private Context context;
    @Inject
    private UploaderProvider uploaderProvider;
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private DocumentLockProvider documentLockProvider;

    @Inject
    public DocumentUploader() {
        this.uploadListener = new OnFileUploadListenerImpl();
    }

    public DocumentUploader(Context context, UploaderProvider uploaderProvider, DocumentStoreStrategy documentStoreStrategy, OnFileUploadListener uploadListener, DocumentLockProvider documentLockProvider) {
        this.context = context;
        this.uploaderProvider = uploaderProvider;
        this.documentStoreStrategy = documentStoreStrategy;
        this.uploadListener = uploadListener;
        this.documentLockProvider = documentLockProvider;
    }

    public boolean uploadDocuments(UploadDocumentsProvider uploadDocumentsProvider) throws IOException {
        List<Pair<List<UploadInfo>, CloudStorage>> documentsForUpload = uploadDocumentsProvider.getDocumentsForUpload();
        if (documentsForUpload == null || documentsForUpload.size() == 0) {
            return false;
        }
        boolean result = false;
        for (Pair<List<UploadInfo>, CloudStorage> pair : documentsForUpload) {
            result = result && this.uploadDocuments((List)pair.first, (CloudStorage)((Object)pair.second));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadDocuments(List<UploadInfo> infos, CloudStorage target) throws IOException {
        if (infos == null) {
            return false;
        }
        for (UploadInfo info : infos) {
            String id2 = info.getId();
            ReentrantReadWriteLock.ReadLock readLock = this.documentLockProvider.getLock(id2).readLock();
            readLock.lock();
            try {
                CloudUploader uploader = this.uploaderProvider.getUploader(target);
                File docDir = this.documentStoreStrategy.getDocumentDir(id2);
                if (!this.documentStoreStrategy.ensureDocumentDir(docDir)) continue;
                info.setFile(this.documentStoreStrategy.getDocumentFile(id2, info.getName()));
                uploader.upload(info, this.uploadListener);
            }
            finally {
                readLock.unlock();
            }
        }
        return true;
    }

    private class OnFileUploadListenerImpl
    implements OnFileUploadListener {
        private OnFileUploadListenerImpl() {
        }

        @Override
        public void onUploadFinished(String id2, CloudStorage target, String cloudFileId) {
        }

        @Override
        public void onUploadFailed(String id2, CloudStorage target) {
        }

        @Override
        public void onUploadFailed(CloudStorage target, String label) {
        }

        @Override
        public void onUploadProgress(String id2, int progress, CloudStorage target) {
        }

        @Override
        public void onUploadAuthorizationFailed(String id2, CloudStorage target) {
            CloudStorage.disconnect(target, DocumentUploader.this.context);
        }
    }
}

