/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import de.aflx.sardine.Sardine;
import de.aflx.sardine.SardineFactory;
import de.aflx.sardine.impl.SardineException;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidParameterException;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.MimeUtils;

class WebDavStorageUploader
implements CloudUploader {
    @Inject
    private SharedPreferences preferences;
    @Inject
    private SardineFactory sardineFactory;
    @Inject
    private Context context;
    private final CloudStorage storage;
    private final String usernameKey;
    private final String passKey;
    private Sardine sardine;
    private Uri.Builder scanbotFolderUri;
    private String host;

    public WebDavStorageUploader(CloudStorage storage) {
        this.storage = storage;
        switch (storage) {
            case WEBDAV_STORAGE: {
                this.usernameKey = "WEBDAV_USERNAME";
                this.passKey = "WEBDAV_PASS";
                break;
            }
            case TELEKOM_CLOUD: {
                this.usernameKey = "TELEKOM_USERNAME";
                this.passKey = "TELEKOM_PASS";
                break;
            }
            case BOX: {
                this.usernameKey = "BOX_USERNAME";
                this.passKey = "BOX_PASS";
                break;
            }
            default: {
                throw new InvalidParameterException("CloudStorage doesn't support WebDAV!");
            }
        }
    }

    @Override
    public synchronized void upload(UploadInfo info, OnFileUploadListener listener) throws IOException {
        this.initWebDavStorage();
        if (!this.preferences.contains(this.usernameKey) || !this.preferences.contains(this.passKey) || TextUtils.isEmpty((CharSequence)this.host)) {
            listener.onUploadAuthorizationFailed(info.getId(), this.storage);
            return;
        }
        if (this.sardine == null) {
            listener.onUploadFailed(info.getId(), this.storage);
            return;
        }
        this.findFolderAndUploadFile(info, listener);
    }

    private void findFolderAndUploadFile(UploadInfo info, OnFileUploadListener listener) {
        try {
            if (this.preferences.contains(this.storage.getDefaultFolderKey())) {
                Uri folder = this.storage.getDefaultFolder(this.preferences);
                this.scanbotFolderUri = new Uri.Builder().encodedPath(folder.getQueryParameter("id"));
            } else {
                this.scanbotFolderUri = new Uri.Builder().encodedPath(this.host).appendEncodedPath("Scanbot" + File.separator);
                if (!this.sardine.exists(this.scanbotFolderUri.toString())) {
                    this.sardine.createDirectory(this.scanbotFolderUri.toString());
                }
            }
            this.saveFileToWebDavStorage(info, listener);
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            String id2 = info.getId();
            if (e instanceof SardineException && ((SardineException)e).getStatusCode() == 401) {
                listener.onUploadAuthorizationFailed(id2, this.storage);
            }
            if (e instanceof ConnectException && e.getMessage().contains("EHOSTUNREACH")) {
                listener.onUploadFailed(this.storage, "upload_failed_host_unreachable" + this.storage.name());
            }
            listener.onUploadFailed(id2, this.storage);
        }
    }

    private void saveFileToWebDavStorage(UploadInfo info, OnFileUploadListener listener) throws IOException {
        File file = info.getFile();
        String filePath = this.scanbotFolderUri.appendPath(file.getName()).toString();
        String cloudFileId = info.getCloudFileId();
        if (!TextUtils.isEmpty((CharSequence)cloudFileId) && this.sardine.exists(cloudFileId)) {
            this.sardine.delete(cloudFileId);
        }
        this.sardine.put(filePath, file, MimeUtils.getMimeByName((String)file.getName()));
        listener.onUploadFinished(info.getId(), this.storage, filePath);
    }

    private void initWebDavStorage() {
        switch (this.storage) {
            case WEBDAV_STORAGE: {
                this.host = this.preferences.getString("WEBDAV_HOST", "");
                break;
            }
            case TELEKOM_CLOUD: {
                this.host = "https://webdav.mediencenter.t-online.de";
                break;
            }
            case BOX: {
                this.host = ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"box_cloud_url");
            }
        }
        this.sardine = this.sardineFactory.begin(this.preferences.getString(this.usernameKey, ""), this.preferences.getString(this.passKey, ""));
    }
}

