/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.io.Serializable;

public class AuthError
extends Exception
implements Parcelable {
    private static final String LOG_TAG = AuthError.class.getName();
    private static final long serialVersionUID = 1L;
    public static final String AUTH_ERROR_EXECEPTION = "AUTH_ERROR_EXECEPTION";
    public static final int RESULT_AUTH_ERROR = 1;
    private final ERROR_TYPE _type;
    public static final Parcelable.Creator<AuthError> CREATOR = new Parcelable.Creator<AuthError>(){

        public AuthError createFromParcel(Parcel in) {
            return new AuthError(in);
        }

        public AuthError[] newArray(int size) {
            return new AuthError[size];
        }
    };

    public AuthError(String detailMessage, ERROR_TYPE type) {
        super(detailMessage);
        this._type = type;
    }

    public AuthError(String detailMessage, Throwable throwable, ERROR_TYPE type) {
        super(detailMessage, throwable);
        this._type = type;
    }

    public ERROR_CATEGORY getCategory() {
        return this._type.getCategory();
    }

    public ERROR_TYPE getType() {
        return this._type;
    }

    @Override
    public String toString() {
        return "AuthError cat= " + (Object)((Object)this._type.getCategory()) + " type=" + (Object)((Object)this._type) + " - " + super.toString();
    }

    public int describeContents() {
        return 0;
    }

    public AuthError(Parcel source) {
        this(source.readString(), (Throwable)source.readValue(Throwable.class.getClassLoader()), (ERROR_TYPE)((Object)source.readSerializable()));
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getMessage());
        if (this.getCause() != null) {
            dest.writeValue((Object)this.getCause());
        } else {
            dest.writeValue(null);
        }
        dest.writeSerializable((Serializable)((Object)this._type));
    }

    public static AuthError extractError(Intent intent) {
        AuthError authError = null;
        try {
            authError = (AuthError)intent.getParcelableExtra(AUTH_ERROR_EXECEPTION);
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "Error Extracting AuthError");
        }
        return authError;
    }

    public static AuthError extractError(Bundle bundle) {
        AuthError authError = null;
        try {
            authError = (AuthError)bundle.getParcelable(AUTH_ERROR_EXECEPTION);
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "Error Extracting AuthError");
        }
        return authError;
    }

    public static Bundle getErrorBundle(AuthError e) {
        Bundle errorBundle = new Bundle();
        errorBundle.putParcelable(AUTH_ERROR_EXECEPTION, (Parcelable)e);
        return errorBundle;
    }

    public static Bundle getErrorBundle(Intent intent) {
        return AuthError.getErrorBundle(AuthError.extractError(intent));
    }

    public static <T> Bundle getErrorBundle(Throwable throwable, Class<T> c, ERROR_TYPE authErrorType) {
        return AuthError.getErrorBundle(AuthError.getAuthError(throwable, c, authErrorType));
    }

    public static <T> AuthError getAuthError(Throwable throwable, Class<T> c) {
        return AuthError.getAuthError(throwable, c, ERROR_TYPE.ERROR_UNKNOWN);
    }

    public static <T> AuthError getAuthError(Throwable throwable, Class<T> c, ERROR_TYPE type) {
        return new AuthError("Unexpected error in " + c.getName(), throwable, type);
    }

    public static enum ERROR_TYPE {
        ERROR_INVALID_TOKEN(ERROR_CATEGORY.ACTION),
        ERROR_INVALID_GRANT(ERROR_CATEGORY.ACTION),
        ERROR_INVALID_CLIENT(ERROR_CATEGORY.ACTION),
        ERROR_INVALID_SCOPE(ERROR_CATEGORY.ACTION),
        ERROR_UNAUTHORIZED_CLIENT(ERROR_CATEGORY.ACTION),
        ERROR_WEBVIEW_SSL(ERROR_CATEGORY.ACTION),
        ERROR_ACCESS_DENIED(ERROR_CATEGORY.ACTION),
        ERROR_COM(ERROR_CATEGORY.NETWORK),
        ERROR_IO(ERROR_CATEGORY.NETWORK),
        ERROR_UNKNOWN(ERROR_CATEGORY.UNKNOWN),
        ERROR_BAD_PARAM(ERROR_CATEGORY.INTERNAL),
        ERROR_JSON(ERROR_CATEGORY.INTERNAL),
        ERROR_PARSE(ERROR_CATEGORY.INTERNAL),
        ERROR_SERVER_REPSONSE(ERROR_CATEGORY.INTERNAL),
        ERROR_DATA_STORAGE(ERROR_CATEGORY.INTERNAL),
        ERROR_THREAD(ERROR_CATEGORY.INTERNAL),
        ERROR_DCP_DMS(ERROR_CATEGORY.ACTION),
        ERROR_FORCE_UPDATE(ERROR_CATEGORY.ACTION),
        ERROR_REVOKE_AUTH(ERROR_CATEGORY.INTERNAL),
        ERROR_AUTH_DIALOG(ERROR_CATEGORY.INTERNAL),
        ERROR_BAD_API_PARAM(ERROR_CATEGORY.BAD_REQUEST),
        ERROR_INIT(ERROR_CATEGORY.BAD_REQUEST),
        ERROR_RESOURCES(ERROR_CATEGORY.BAD_REQUEST),
        ERROR_DIRECTED_ID_NOT_FOUND(ERROR_CATEGORY.BAD_REQUEST),
        ERROR_INVALID_API(ERROR_CATEGORY.BAD_REQUEST),
        ERROR_SECURITY(ERROR_CATEGORY.BAD_REQUEST);

        private final ERROR_CATEGORY _category;

        private ERROR_TYPE(ERROR_CATEGORY category) {
            this._category = category;
        }

        public ERROR_CATEGORY getCategory() {
            return this._category;
        }
    }

    public static enum ERROR_CATEGORY {
        ACTION,
        BAD_REQUEST,
        NETWORK,
        INTERNAL,
        UNKNOWN;

    }
}

