/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.appid;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.amazon.identity.auth.device.appid.APIKeyDecoder;
import com.amazon.identity.auth.device.appid.AppIdentifier;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.utils.MAPLog;
import com.amazon.identity.auth.device.utils.ThirdPartyResourceParser;

public abstract class AbstractAppIdentifier
implements AppIdentifier {
    private static final String LOG_TAG = AbstractAppIdentifier.class.getName();

    @Override
    public boolean isAPIKeyValid(Context context) {
        if (context == null) {
            MAPLog.w(LOG_TAG, "context can't be null!");
            return false;
        }
        String packageName = context.getPackageName();
        return this.isAPIKeyValid(packageName, context);
    }

    @Override
    public boolean isAPIKeyValid(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "isAPIKeyValid : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return false;
        }
        return this.getAppInfo(packageName, context) != null;
    }

    @Override
    public boolean isAPIKeyValid(String packageName, String apiKey, Context context) {
        MAPLog.pii(LOG_TAG, "isAPIKeyValid : packageName=" + packageName, "apiKey=" + apiKey);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return false;
        }
        if (apiKey == null) {
            MAPLog.w(LOG_TAG, "apiKey can't be null!");
            return false;
        }
        return APIKeyDecoder.decode(packageName, apiKey, context) != null;
    }

    @Override
    public AppInfo getAppInfo(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "getAppInfo : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        String apiKey = this.getAPIKey(packageName, context);
        return APIKeyDecoder.decode(packageName, apiKey, context);
    }

    @Override
    public abstract String getPackageName(String var1, Context var2);

    @Override
    public abstract String[] getPackageNames(String var1, Context var2);

    @Override
    public abstract String getPackageNameByVariant(String var1, Context var2);

    @Override
    public String getAppLabel(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "getAppLabel : packageName=" + packageName);
        if (packageName == null) {
            MAPLog.w(LOG_TAG, "packageName can't be null!");
            return null;
        }
        String to_return = null;
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
            to_return = (String)context.getPackageManager().getApplicationLabel(appInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            to_return = null;
        }
        return to_return;
    }

    private String getAPIKey(String packageName, Context context) {
        MAPLog.i(LOG_TAG, "Finding API Key for " + packageName);
        assert (packageName != null);
        String to_return = null;
        ThirdPartyResourceParser parser = null;
        parser = new ThirdPartyResourceParser(context, packageName);
        to_return = parser.getApiKey();
        return to_return;
    }

    @Override
    public abstract String getAppFamilyId(String var1, Context var2);

    @Override
    public abstract String getAppVariantId(String var1, Context var2);
}

