/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.text.TextUtils;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.utils.MAPLog;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class CallbackInfo {
    private static final String LOG_TAG = CallbackInfo.class.getName();
    public final Date mDateCreated;
    public final String[] mRequestedScopes;
    public final String mClientId;
    public final String mRequestId;
    public final AuthorizationListener mlistener;
    private static final Object lock = new Object();
    private static final int MAX_OUTSTANDING = 10;
    private static final Map<String, CallbackInfo> browserCallbacks = new HashMap<String, CallbackInfo>();

    CallbackInfo(Date dateCreated, String requestId, String clientId, String[] requestedScopes, AuthorizationListener listener) {
        this.mDateCreated = dateCreated;
        this.mClientId = clientId;
        this.mRequestedScopes = requestedScopes;
        this.mRequestId = requestId;
        this.mlistener = listener;
        browserCallbacks.put(requestId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addCallbackInfo(CallbackInfo callbackInfo) {
        Object object = lock;
        synchronized (object) {
            CallbackInfo.cleanUp();
            browserCallbacks.put(callbackInfo.mRequestId, callbackInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CallbackInfo getCallbackInfo(String requestId) {
        CallbackInfo callbackInfo = null;
        Object object = lock;
        synchronized (object) {
            callbackInfo = browserCallbacks.get(requestId);
            if (callbackInfo != null) {
                browserCallbacks.remove(callbackInfo.mRequestId);
            }
        }
        return callbackInfo;
    }

    static void cleanUpAll() {
        browserCallbacks.clear();
    }

    static void cleanUp() {
        if (browserCallbacks.size() > 10) {
            long oldestTime = Long.MAX_VALUE;
            CallbackInfo oldest = null;
            for (Map.Entry<String, CallbackInfo> callbackEntry : browserCallbacks.entrySet()) {
                if (callbackEntry.getValue().mDateCreated != null) {
                    long callbackCreateTime = callbackEntry.getValue().mDateCreated.getTime();
                    if (callbackCreateTime >= oldestTime) continue;
                    oldestTime = callbackCreateTime;
                    oldest = callbackEntry.getValue();
                    continue;
                }
                browserCallbacks.remove(callbackEntry.getValue().mRequestId);
            }
            if (oldest != null) {
                MAPLog.i(LOG_TAG, "Removing oldest request id=" + oldest.mRequestId);
                browserCallbacks.remove(oldest.mRequestId);
            }
        }
    }

    static int getCallbackInfoCount() {
        return browserCallbacks.size();
    }

    public boolean equals(CallbackInfo callbackInfo) {
        if (callbackInfo == null) {
            return false;
        }
        return this.mDateCreated.equals(callbackInfo.mDateCreated) && TextUtils.equals((CharSequence)this.mRequestId, (CharSequence)callbackInfo.mRequestId) && TextUtils.equals((CharSequence)this.mClientId, (CharSequence)callbackInfo.mClientId) && this.mlistener == callbackInfo.mlistener;
    }
}

