/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.AuthorizationResponseParser;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.service.MAPServiceResult;
import com.amazon.identity.auth.device.token.MAPCookie;
import com.amazon.identity.auth.device.utils.MAPLog;
import com.amazon.identity.auth.device.utils.MAPUtils;
import java.util.UUID;

class MAPAuthzDialog
extends Dialog
implements DialogInterface.OnCancelListener {
    private static final String LOG_TAG = MAPAuthzDialog.class.getName();
    private static final String AT_MAIN_COOKIE_NAME = "at-main";
    private static final String US_DOMAIN = ".amazon.com";
    private static final String REDIRECT_SCHEME = "amzn://";
    private static final int DEFAULT_THEME = 16973831;
    private final String mUrl;
    private final AuthorizationListener authorizationListener;
    private final UUID mRequestId;
    private final String[] mRequestedScopes;
    private WebView mWebView;
    private RelativeLayout mAuthzDialogViewContainer;
    private LinearLayout mWebViewContainer;
    private RelativeLayout mProgressBarContainer;
    private ProgressBar mProgressBar;
    private boolean isDetachedFromWindow = false;
    private boolean mShowProgressBar = false;
    private static final String LOG_TAG_CLIENT = MAPAuthzDialog.class.getName() + ".Client";

    MAPAuthzDialog(Context context, String url, AuthorizationListener listener, UUID requestId, String[] scopes) {
        super(context, 16973831);
        this.authorizationListener = listener;
        this.mUrl = url;
        MAPLog.pii(LOG_TAG, "Starting MAP Authz Dialog", "url=" + this.mUrl);
        this.mRequestId = requestId;
        this.mRequestedScopes = scopes;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MAPLog.i(LOG_TAG, "OnCreate Oauth Dialog");
        this.mProgressBar = new ProgressBar(this.getContext(), null, 16842872);
        this.mProgressBar.setIndeterminate(true);
        this.mProgressBar.getIndeterminateDrawable().setAlpha(150);
        super.onCreate(savedInstanceState);
        MAPLog.i(LOG_TAG, "ONCreate MAP Authz Dialog");
        this.requestWindowFeature(1);
        this.setUpWebView();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView() {
        MAPLog.i(LOG_TAG, "Setting up webview");
        this.mAuthzDialogViewContainer = new RelativeLayout(this.getContext());
        this.mProgressBarContainer = new RelativeLayout(this.getContext());
        float pixelDensity = this.getContext().getResources().getDisplayMetrics().density;
        int dpHeight = 30;
        int pixelHeight = (int)((float)dpHeight * pixelDensity);
        RelativeLayout.LayoutParams myParams = new RelativeLayout.LayoutParams(-1, pixelHeight);
        this.mProgressBarContainer.setLayoutParams((ViewGroup.LayoutParams)myParams);
        this.mProgressBarContainer.setVisibility(8);
        RelativeLayout.LayoutParams progressBarParams = new RelativeLayout.LayoutParams(200, -2);
        progressBarParams.addRule(13);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)progressBarParams);
        this.mProgressBarContainer.addView((View)this.mProgressBar);
        AlphaAnimation alphaUp = new AlphaAnimation(0.6f, 0.6f);
        alphaUp.setFillAfter(true);
        this.mProgressBar.startAnimation((Animation)alphaUp);
        this.mWebViewContainer = new LinearLayout(this.getContext());
        ViewGroup.LayoutParams webViewParams = new ViewGroup.LayoutParams(-1, -1);
        this.mWebViewContainer.setLayoutParams(webViewParams);
        this.mWebView = new WebView(this.getContext());
        this.mWebView.setVerticalScrollBarEnabled(false);
        this.mWebView.setHorizontalScrollBarEnabled(false);
        this.mWebView.setWebViewClient((WebViewClient)new MAPAuthzWebViewClient());
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.loadUrl(this.mUrl);
        this.mWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWebView.setVisibility(0);
        this.mWebView.getSettings().setSavePassword(false);
        this.mWebViewContainer.addView((View)this.mWebView);
        this.mAuthzDialogViewContainer.addView((View)this.mWebViewContainer);
        this.mAuthzDialogViewContainer.addView((View)this.mProgressBarContainer);
        this.setContentView((View)this.mAuthzDialogViewContainer, new ViewGroup.LayoutParams(-1, -1));
    }

    public void dismiss() {
        if (this.mWebView != null) {
            this.mWebView.stopLoading();
        }
        if (!this.isDetachedFromWindow) {
            this.showProgressBar(false);
            super.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        this.isDetachedFromWindow = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetachedFromWindow = false;
        super.onAttachedToWindow();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        MAPLog.i(LOG_TAG, "OnKeyDown");
        if (keyCode == 4) {
            MAPLog.i(LOG_TAG, "KeyEvent.KEYCODE_BACK");
            if (!this.isDetachedFromWindow) {
                this.showProgressBar(false);
            }
            if (this.mWebView != null && this.mWebView.canGoBack()) {
                MAPLog.i(LOG_TAG, "Going back in webview");
                this.mWebView.goBack();
                return true;
            }
            MAPLog.i(LOG_TAG, "onKeyDown Dismissing webview");
            this.authorizationListener.onCancel(MAPServiceResult.getOnCancelBundle(0, this.mRequestedScopes));
            this.dismiss();
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onCancel(DialogInterface dialog) {
        MAPLog.i(LOG_TAG, "Spinner in webview cancelled");
        if (this.mWebView == null || !this.mWebView.canGoBack()) {
            MAPLog.i(LOG_TAG, "Dismissing Dialog");
            this.authorizationListener.onCancel(MAPServiceResult.getOnCancelBundle(0, this.mRequestedScopes));
            this.dismiss();
        } else {
            this.mWebView.goBack();
            MAPLog.i(LOG_TAG, "Stop Loading");
        }
    }

    private void showProgressBar(boolean showProgressBar) {
        if (this.mShowProgressBar != showProgressBar) {
            PeekingAnimationView peekingViewAnimation = new PeekingAnimationView((View)this.mProgressBarContainer, showProgressBar);
            this.mAuthzDialogViewContainer.startAnimation((Animation)peekingViewAnimation);
            this.mShowProgressBar = showProgressBar;
        }
    }

    private class PeekingAnimationView
    extends Animation {
        private static final int DURATION = 600;
        private final View mPeekingView;
        private final int mPeekingViewHeight;
        private final boolean mShowState;

        public PeekingAnimationView(View view, boolean state) {
            this.setDuration(600L);
            this.mPeekingView = view;
            this.mPeekingViewHeight = this.mPeekingView.getLayoutParams().height;
            this.mShowState = state;
            if (this.mShowState) {
                this.mPeekingView.setVisibility(0);
                this.mPeekingView.getLayoutParams().height = 0;
            }
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            if (interpolatedTime < 1.0f) {
                this.mPeekingView.getLayoutParams().height = this.mShowState ? (int)((float)this.mPeekingViewHeight * interpolatedTime) : this.mPeekingViewHeight - (int)((float)this.mPeekingViewHeight * interpolatedTime);
                this.mPeekingView.requestLayout();
            } else if (this.mShowState) {
                this.mPeekingView.getLayoutParams().height = this.mPeekingViewHeight;
                this.mPeekingView.requestLayout();
            } else {
                this.mPeekingView.getLayoutParams().height = 0;
                this.mPeekingView.setVisibility(8);
                this.mPeekingView.requestLayout();
                this.mPeekingView.getLayoutParams().height = this.mPeekingViewHeight;
            }
        }
    }

    private class MAPAuthzWebViewClient
    extends WebViewClient {
        public void onPageFinished(WebView view, String url) {
            MAPLog.pii(LOG_TAG_CLIENT, "onPageFinished", "url=" + url);
            super.onPageFinished(view, url);
            if (!MAPAuthzDialog.this.isDetachedFromWindow) {
                MAPAuthzDialog.this.showProgressBar(false);
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            MAPLog.pii(LOG_TAG_CLIENT, "onPageStarted", "url=" + url);
            super.onPageStarted(view, url, favicon);
            if (!MAPAuthzDialog.this.isDetachedFromWindow) {
                MAPAuthzDialog.this.showProgressBar(true);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            MAPLog.pii(LOG_TAG_CLIENT, "shouldOverrideUrlLoading", "url=" + url);
            if (url != null && url.startsWith(MAPAuthzDialog.REDIRECT_SCHEME)) {
                MAPLog.i(LOG_TAG, "Processing redirectUrl");
                if (!MAPAuthzDialog.this.isDetachedFromWindow) {
                    MAPAuthzDialog.this.showProgressBar(false);
                }
                MAPAuthzDialog.this.dismiss();
                this.cleanCookies(MAPAuthzDialog.this.getContext(), url);
                try {
                    AuthorizationResponseParser parser = new AuthorizationResponseParser();
                    Bundle results = parser.extractResultsBundle(url, MAPAuthzDialog.this.mRequestId.toString(), MAPAuthzDialog.this.mRequestedScopes);
                    if (results.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val)) {
                        MAPAuthzDialog.this.authorizationListener.onCancel(results);
                    } else {
                        MAPAuthzDialog.this.authorizationListener.onSuccess(results);
                    }
                }
                catch (AuthError e) {
                    MAPAuthzDialog.this.authorizationListener.onError(e);
                }
                return true;
            }
            if (!MAPUtils.isMAPUrl(url)) {
                MAPLog.pii(LOG_TAG, "URL clicked - override", "url=" + url);
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                view.getContext().startActivity(browserIntent);
                return true;
            }
            return false;
        }

        private void cleanCookies(Context context, String url) {
            try {
                MAPCookie atMain = new MAPCookie(MAPAuthzDialog.AT_MAIN_COOKIE_NAME, "", MAPAuthzDialog.US_DOMAIN, null, true);
                MAPCookie.clearCookieInCookieManager(context, atMain, url, null);
            }
            catch (AuthError e) {
                MAPLog.i(LOG_TAG_CLIENT, "Unable to clear cookies : " + e.getMessage());
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            MAPLog.i(LOG_TAG_CLIENT, "onReceivedError=" + errorCode + " desc=" + description);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            MAPLog.i(LOG_TAG_CLIENT, "onReceivedSslError");
            if (this.isDevo()) {
                MAPLog.d(LOG_TAG_CLIENT, "Hitting devo");
                handler.proceed();
            } else {
                super.onReceivedSslError(view, handler, error);
                handler.cancel();
                MAPAuthzDialog.this.dismiss();
                MAPAuthzDialog.this.authorizationListener.onError(new AuthError("SSL Error", AuthError.ERROR_TYPE.ERROR_WEBVIEW_SSL));
            }
        }

        private boolean isDevo() {
            Context context = MAPAuthzDialog.this.getContext();
            String packageName = context.getPackageName();
            try {
                String hostType;
                ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
                if (appInfo.metaData != null && (hostType = appInfo.metaData.getString("host.type")).equals("development")) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
            return false;
        }
    }
}

